/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.replication.LogEntry;
import org.sdmlib.replication.Task;
import org.sdmlib.replication.util.LogEntrySet;
import org.sdmlib.replication.util.TaskPO;

public class TaskSet
extends SDMSet<Task> {
    public static final TaskSet EMPTY_SET = (TaskSet)new TaskSet().withReadOnly(true);

    public TaskPO hasTaskPO() {
        return new TaskPO((Task[])this.toArray(new Task[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.Task";
    }

    public TaskSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((Task)value);
        }
        return this;
    }

    public TaskSet without(Task value) {
        this.remove(value);
        return this;
    }

    public LogEntrySet getLogEntries() {
        LogEntrySet result = new LogEntrySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Task obj = (Task)iterator.next();
            result.addAll((Collection)((Object)obj.getLogEntries()));
        }
        return result;
    }

    public TaskSet hasLogEntries(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        TaskSet answer = new TaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Task obj = (Task)iterator.next();
            if (Collections.disjoint(neighbors, obj.getLogEntries())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public TaskSet withLogEntries(LogEntry value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Task obj = (Task)iterator.next();
            obj.withLogEntries(value);
        }
        return this;
    }

    public TaskSet withoutLogEntries(LogEntry value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Task obj = (Task)iterator.next();
            obj.withoutLogEntries(value);
        }
        return this;
    }
}

