/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.net.Socket;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.models.modelsets.booleanList;
import org.sdmlib.models.modelsets.longList;
import org.sdmlib.replication.ChangeHistory;
import org.sdmlib.replication.ReplicationChannel;
import org.sdmlib.replication.ReplicationNode;
import org.sdmlib.replication.SharedSpace;
import org.sdmlib.replication.util.ChangeHistorySet;
import org.sdmlib.replication.util.ReplicationChannelSet;
import org.sdmlib.replication.util.ReplicationNodeSet;
import org.sdmlib.replication.util.SharedSpacePO;
import org.sdmlib.replication.util.SocketSet;

public class SharedSpaceSet
extends SDMSet<SharedSpace> {
    public static final SharedSpaceSet EMPTY_SET = (SharedSpaceSet)new SharedSpaceSet().withReadOnly(true);

    public SharedSpacePO hasSharedSpacePO() {
        return new SharedSpacePO((SharedSpace[])this.toArray(new SharedSpace[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.SharedSpace";
    }

    public SharedSpaceSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((SharedSpace)value);
        }
        return this;
    }

    public SharedSpaceSet without(SharedSpace value) {
        this.remove(value);
        return this;
    }

    public SocketSet getSocket() {
        SocketSet result = new SocketSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.getSocket());
        }
        return result;
    }

    public SharedSpaceSet hasSocket(Socket value) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (value != obj.getSocket()) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet withSocket(Socket value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.setSocket(value);
        }
        return this;
    }

    public StringList getTargetNodeId() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.getTargetNodeId());
        }
        return result;
    }

    public SharedSpaceSet hasTargetNodeId(String value) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (!value.equals(obj.getTargetNodeId())) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet hasTargetNodeId(String lower, String upper) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (lower.compareTo(obj.getTargetNodeId()) > 0 || obj.getTargetNodeId().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet withTargetNodeId(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.setTargetNodeId(value);
        }
        return this;
    }

    public ReplicationNodeSet getNode() {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.getNode());
        }
        return result;
    }

    public SharedSpaceSet hasNode(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        SharedSpaceSet answer = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (!neighbors.contains(obj.getNode())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public SharedSpaceSet withNode(ReplicationNode value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.withNode(value);
        }
        return this;
    }

    public ReplicationChannelSet getChannels() {
        ReplicationChannelSet result = new ReplicationChannelSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.addAll((Collection)((Object)obj.getChannels()));
        }
        return result;
    }

    public SharedSpaceSet hasChannels(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        SharedSpaceSet answer = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (Collections.disjoint(neighbors, obj.getChannels())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public SharedSpaceSet withChannels(ReplicationChannel value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.withChannels(value);
        }
        return this;
    }

    public SharedSpaceSet withoutChannels(ReplicationChannel value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.withoutChannels(value);
        }
        return this;
    }

    public StringList getSpaceId() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.getSpaceId());
        }
        return result;
    }

    public SharedSpaceSet hasSpaceId(String value) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if ((value != null || obj.getSpaceId() != null) && (value == null || !value.equals(obj.getSpaceId()))) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet hasSpaceId(String lower, String upper) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (lower.compareTo(obj.getSpaceId()) > 0 || obj.getSpaceId().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet withSpaceId(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.setSpaceId(value);
        }
        return this;
    }

    public ChangeHistorySet getHistory() {
        ChangeHistorySet result = new ChangeHistorySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.getHistory());
        }
        return result;
    }

    public SharedSpaceSet hasHistory(ChangeHistory value) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (value != obj.getHistory()) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet withHistory(ChangeHistory value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.setHistory(value);
        }
        return this;
    }

    public longList getLastChangeId() {
        longList result = new longList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.getLastChangeId());
        }
        return result;
    }

    public SharedSpaceSet hasLastChangeId(long value) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (value != obj.getLastChangeId()) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet hasLastChangeId(long lower, long upper) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (lower > obj.getLastChangeId() || obj.getLastChangeId() > upper) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet withLastChangeId(long value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.setLastChangeId(value);
        }
        return this;
    }

    public StringList getNodeId() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.getNodeId());
        }
        return result;
    }

    public SharedSpaceSet hasNodeId(String value) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (!value.equals(obj.getNodeId())) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet hasNodeId(String lower, String upper) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (lower.compareTo(obj.getNodeId()) > 0 || obj.getNodeId().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet withNodeId(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.setNodeId(value);
        }
        return this;
    }

    public booleanList getJavaFXApplication() {
        booleanList result = new booleanList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            result.add(obj.isJavaFXApplication());
        }
        return result;
    }

    public SharedSpaceSet hasJavaFXApplication(boolean value) {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            if (value != obj.isJavaFXApplication()) continue;
            result.add(obj);
        }
        return result;
    }

    public SharedSpaceSet withJavaFXApplication(boolean value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SharedSpace obj = (SharedSpace)iterator.next();
            obj.setJavaFXApplication(value);
        }
        return this;
    }
}

