/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.replication.SeppelScope;
import org.sdmlib.replication.SeppelSpaceProxy;
import org.sdmlib.replication.util.SeppelScopePO;
import org.sdmlib.replication.util.SeppelSpaceProxySet;

public class SeppelScopeSet
extends SDMSet<SeppelScope> {
    public static final SeppelScopeSet EMPTY_SET = (SeppelScopeSet)new SeppelScopeSet().withReadOnly(true);

    public SeppelScopePO hasSeppelScopePO() {
        return new SeppelScopePO((SeppelScope[])this.toArray(new SeppelScope[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.SeppelScope";
    }

    public SeppelScopeSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((SeppelScope)value);
        }
        return this;
    }

    public SeppelScopeSet without(SeppelScope value) {
        this.remove(value);
        return this;
    }

    public StringList getScopeName() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            result.add(obj.getScopeName());
        }
        return result;
    }

    public SeppelScopeSet hasScopeName(String value) {
        SeppelScopeSet result = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            if (!value.equals(obj.getScopeName())) continue;
            result.add(obj);
        }
        return result;
    }

    public SeppelScopeSet hasScopeName(String lower, String upper) {
        SeppelScopeSet result = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            if (lower.compareTo(obj.getScopeName()) > 0 || obj.getScopeName().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public SeppelScopeSet withScopeName(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.setScopeName(value);
        }
        return this;
    }

    public SeppelScopeSet getSubScopes() {
        SeppelScopeSet result = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            result.addAll((Collection)((Object)obj.getSubScopes()));
        }
        return result;
    }

    public SeppelScopeSet hasSubScopes(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        SeppelScopeSet answer = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            if (Collections.disjoint(neighbors, obj.getSubScopes())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public SeppelScopeSet getSubScopesTransitive() {
        SeppelScopeSet todo = new SeppelScopeSet().with(this);
        SeppelScopeSet result = new SeppelScopeSet();
        while (!todo.isEmpty()) {
            SeppelScope current = (SeppelScope)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            todo.with(current.getSubScopes().minus(result));
        }
        return result;
    }

    public SeppelScopeSet withSubScopes(SeppelScope value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withSubScopes(value);
        }
        return this;
    }

    public SeppelScopeSet withoutSubScopes(SeppelScope value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withoutSubScopes(value);
        }
        return this;
    }

    public SeppelScopeSet getSuperScopes() {
        SeppelScopeSet result = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            result.addAll((Collection)((Object)obj.getSuperScopes()));
        }
        return result;
    }

    public SeppelScopeSet hasSuperScopes(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        SeppelScopeSet answer = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            if (Collections.disjoint(neighbors, obj.getSuperScopes())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public SeppelScopeSet getSuperScopesTransitive() {
        SeppelScopeSet todo = new SeppelScopeSet().with(this);
        SeppelScopeSet result = new SeppelScopeSet();
        while (!todo.isEmpty()) {
            SeppelScope current = (SeppelScope)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            todo.with(current.getSuperScopes().minus(result));
        }
        return result;
    }

    public SeppelScopeSet withSuperScopes(SeppelScope value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withSuperScopes(value);
        }
        return this;
    }

    public SeppelScopeSet withoutSuperScopes(SeppelScope value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withoutSuperScopes(value);
        }
        return this;
    }

    public SeppelSpaceProxySet getSpaces() {
        SeppelSpaceProxySet result = new SeppelSpaceProxySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            result.addAll((Collection)((Object)obj.getSpaces()));
        }
        return result;
    }

    public SeppelScopeSet hasSpaces(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        SeppelScopeSet answer = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            if (Collections.disjoint(neighbors, obj.getSpaces())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public SeppelScopeSet withSpaces(SeppelSpaceProxy value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withSpaces(value);
        }
        return this;
    }

    public SeppelScopeSet withoutSpaces(SeppelSpaceProxy value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withoutSpaces(value);
        }
        return this;
    }

    public ObjectSet getObservedObjects() {
        ObjectSet result = new ObjectSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            result.addAll((Collection)((Object)obj.getObservedObjects()));
        }
        return result;
    }

    public SeppelScopeSet hasObservedObjects(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        SeppelScopeSet answer = new SeppelScopeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            if (Collections.disjoint(neighbors, obj.getObservedObjects())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public SeppelScopeSet withObservedObjects(Object value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withObservedObjects(value);
        }
        return this;
    }

    public SeppelScopeSet withoutObservedObjects(Object value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope obj = (SeppelScope)iterator.next();
            obj.withoutObservedObjects(value);
        }
        return this;
    }

    public boolean containsObservedObjects(Object targetObject) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            SeppelScope scope = (SeppelScope)iterator.next();
            if (!scope.getObservedObjects().contains(targetObject)) continue;
            return true;
        }
        return false;
    }
}

