/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.replication.ReplicationRoot;
import org.sdmlib.replication.util.ReplicationRootPO;

public class ReplicationRootSet
extends SDMSet<ReplicationRoot> {
    public static final ReplicationRootSet EMPTY_SET = (ReplicationRootSet)new ReplicationRootSet().withReadOnly(true);

    public ReplicationRootPO hasReplicationRootPO() {
        return new ReplicationRootPO((ReplicationRoot[])this.toArray(new ReplicationRoot[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.ReplicationRoot";
    }

    public ReplicationRootSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((ReplicationRoot)value);
        }
        return this;
    }

    public ReplicationRootSet without(ReplicationRoot value) {
        this.remove(value);
        return this;
    }

    public StringList getName() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            result.add(obj.getName());
        }
        return result;
    }

    public ReplicationRootSet hasName(String value) {
        ReplicationRootSet result = new ReplicationRootSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            if (!value.equals(obj.getName())) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationRootSet hasName(String lower, String upper) {
        ReplicationRootSet result = new ReplicationRootSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            if (lower.compareTo(obj.getName()) > 0 || obj.getName().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationRootSet withName(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            obj.setName(value);
        }
        return this;
    }

    public ObjectSet getApplicationObject() {
        ObjectSet result = new ObjectSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            result.add(obj.getApplicationObject());
        }
        return result;
    }

    public ReplicationRootSet hasApplicationObject(Object value) {
        ReplicationRootSet result = new ReplicationRootSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            if (value != obj.getApplicationObject()) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationRootSet withApplicationObject(Object value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            obj.setApplicationObject(value);
        }
        return this;
    }

    public ReplicationRootSet getKids() {
        ReplicationRootSet result = new ReplicationRootSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            result.addAll((Collection)((Object)obj.getKids()));
        }
        return result;
    }

    public ReplicationRootSet hasKids(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        ReplicationRootSet answer = new ReplicationRootSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            if (Collections.disjoint(neighbors, obj.getKids())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public ReplicationRootSet getKidsTransitive() {
        ReplicationRootSet todo = new ReplicationRootSet().with(this);
        ReplicationRootSet result = new ReplicationRootSet();
        while (!todo.isEmpty()) {
            ReplicationRoot current = (ReplicationRoot)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            todo.with(current.getKids().minus(result));
        }
        return result;
    }

    public ReplicationRootSet withKids(ReplicationRoot value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            obj.withKids(value);
        }
        return this;
    }

    public ReplicationRootSet withoutKids(ReplicationRoot value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            obj.withoutKids(value);
        }
        return this;
    }

    public ReplicationRootSet getParent() {
        ReplicationRootSet result = new ReplicationRootSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            result.add(obj.getParent());
        }
        return result;
    }

    public ReplicationRootSet hasParent(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        ReplicationRootSet answer = new ReplicationRootSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            if (!neighbors.contains(obj.getParent())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public ReplicationRootSet getParentTransitive() {
        ReplicationRootSet todo = new ReplicationRootSet().with(this);
        ReplicationRootSet result = new ReplicationRootSet();
        while (!todo.isEmpty()) {
            ReplicationRoot current = (ReplicationRoot)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            if (result.contains(current.getParent())) continue;
            todo.with(current.getParent());
        }
        return result;
    }

    public ReplicationRootSet withParent(ReplicationRoot value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationRoot obj = (ReplicationRoot)iterator.next();
            obj.withParent(value);
        }
        return this;
    }
}

