/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.models.modelsets.booleanList;
import org.sdmlib.models.modelsets.longList;
import org.sdmlib.replication.ChangeHistory;
import org.sdmlib.replication.ReplicationNode;
import org.sdmlib.replication.SharedSpace;
import org.sdmlib.replication.util.ChangeHistorySet;
import org.sdmlib.replication.util.ReplicationNodePO;
import org.sdmlib.replication.util.SharedSpaceSet;

public class ReplicationNodeSet
extends SDMSet<ReplicationNode> {
    public static final ReplicationNodeSet EMPTY_SET = (ReplicationNodeSet)new ReplicationNodeSet().withReadOnly(true);

    public ReplicationNodePO hasReplicationNodePO() {
        return new ReplicationNodePO((ReplicationNode[])this.toArray(new ReplicationNode[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.ReplicationNode";
    }

    public ReplicationNodeSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((ReplicationNode)value);
        }
        return this;
    }

    public ReplicationNodeSet without(ReplicationNode value) {
        this.remove(value);
        return this;
    }

    public StringList getSpaceId() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            result.add(obj.getSpaceId());
        }
        return result;
    }

    public ReplicationNodeSet hasSpaceId(String value) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (!value.equals(obj.getSpaceId())) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet hasSpaceId(String lower, String upper) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (lower.compareTo(obj.getSpaceId()) > 0 || obj.getSpaceId().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet withSpaceId(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            obj.setSpaceId(value);
        }
        return this;
    }

    public ChangeHistorySet getHistory() {
        ChangeHistorySet result = new ChangeHistorySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            result.add(obj.getHistory());
        }
        return result;
    }

    public ReplicationNodeSet hasHistory(ChangeHistory value) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (value != obj.getHistory()) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet withHistory(ChangeHistory value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            obj.setHistory(value);
        }
        return this;
    }

    public longList getLastChangeId() {
        longList result = new longList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            result.add(obj.getLastChangeId());
        }
        return result;
    }

    public ReplicationNodeSet hasLastChangeId(long value) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (value != obj.getLastChangeId()) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet hasLastChangeId(long lower, long upper) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (lower > obj.getLastChangeId() || obj.getLastChangeId() > upper) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet withLastChangeId(long value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            obj.setLastChangeId(value);
        }
        return this;
    }

    public StringList getNodeId() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            result.add(obj.getNodeId());
        }
        return result;
    }

    public ReplicationNodeSet hasNodeId(String value) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (!value.equals(obj.getNodeId())) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet hasNodeId(String lower, String upper) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (lower.compareTo(obj.getNodeId()) > 0 || obj.getNodeId().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet withNodeId(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            obj.setNodeId(value);
        }
        return this;
    }

    public booleanList getJavaFXApplication() {
        booleanList result = new booleanList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            result.add(obj.isJavaFXApplication());
        }
        return result;
    }

    public ReplicationNodeSet hasJavaFXApplication(boolean value) {
        ReplicationNodeSet result = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (value != obj.isJavaFXApplication()) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationNodeSet withJavaFXApplication(boolean value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            obj.setJavaFXApplication(value);
        }
        return this;
    }

    public SharedSpaceSet getSharedSpaces() {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            result.addAll((Collection)((Object)obj.getSharedSpaces()));
        }
        return result;
    }

    public ReplicationNodeSet hasSharedSpaces(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        ReplicationNodeSet answer = new ReplicationNodeSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            if (Collections.disjoint(neighbors, obj.getSharedSpaces())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public ReplicationNodeSet withSharedSpaces(SharedSpace value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            obj.withSharedSpaces(value);
        }
        return this;
    }

    public ReplicationNodeSet withoutSharedSpaces(SharedSpace value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationNode obj = (ReplicationNode)iterator.next();
            obj.withoutSharedSpaces(value);
        }
        return this;
    }
}

