/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.net.Socket;
import java.util.Collection;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.replication.ReplicationChannel;
import org.sdmlib.replication.SharedSpace;
import org.sdmlib.replication.util.ReplicationChannelPO;
import org.sdmlib.replication.util.SharedSpaceSet;
import org.sdmlib.replication.util.SocketSet;

public class ReplicationChannelSet
extends SDMSet<ReplicationChannel> {
    public static final ReplicationChannelSet EMPTY_SET = (ReplicationChannelSet)new ReplicationChannelSet().withReadOnly(true);

    public ReplicationChannelPO hasReplicationChannelPO() {
        return new ReplicationChannelPO((ReplicationChannel[])this.toArray(new ReplicationChannel[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.ReplicationChannel";
    }

    public ReplicationChannelSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((ReplicationChannel)value);
        }
        return this;
    }

    public ReplicationChannelSet without(ReplicationChannel value) {
        this.remove(value);
        return this;
    }

    public SocketSet getSocket() {
        SocketSet result = new SocketSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            result.add(obj.getSocket());
        }
        return result;
    }

    public ReplicationChannelSet hasSocket(Socket value) {
        ReplicationChannelSet result = new ReplicationChannelSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            if (value != obj.getSocket()) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationChannelSet withSocket(Socket value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            obj.setSocket(value);
        }
        return this;
    }

    public StringList getTargetNodeId() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            result.add(obj.getTargetNodeId());
        }
        return result;
    }

    public ReplicationChannelSet hasTargetNodeId(String value) {
        ReplicationChannelSet result = new ReplicationChannelSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            if (!value.equals(obj.getTargetNodeId())) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationChannelSet hasTargetNodeId(String lower, String upper) {
        ReplicationChannelSet result = new ReplicationChannelSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            if (lower.compareTo(obj.getTargetNodeId()) > 0 || obj.getTargetNodeId().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public ReplicationChannelSet withTargetNodeId(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            obj.setTargetNodeId(value);
        }
        return this;
    }

    public SharedSpaceSet getSharedSpace() {
        SharedSpaceSet result = new SharedSpaceSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            result.add(obj.getSharedSpace());
        }
        return result;
    }

    public ReplicationChannelSet hasSharedSpace(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        ReplicationChannelSet answer = new ReplicationChannelSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            if (!neighbors.contains(obj.getSharedSpace())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public ReplicationChannelSet withSharedSpace(SharedSpace value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            ReplicationChannel obj = (ReplicationChannel)iterator.next();
            obj.withSharedSpace(value);
        }
        return this;
    }
}

