/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.replication.BoardTask;
import org.sdmlib.replication.LogEntry;
import org.sdmlib.replication.RemoteTask;
import org.sdmlib.replication.util.BoardTaskSet;
import org.sdmlib.replication.util.LogEntrySet;

public class RemoteTaskSet
extends SDMSet<RemoteTask> {
    public static final RemoteTaskSet EMPTY_SET = (RemoteTaskSet)new RemoteTaskSet().withReadOnly(true);

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.RemoteTask";
    }

    public RemoteTaskSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((RemoteTask)value);
        }
        return this;
    }

    public RemoteTaskSet without(RemoteTask value) {
        this.remove(value);
        return this;
    }

    public BoardTaskSet getBoardTask() {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RemoteTask obj = (RemoteTask)iterator.next();
            result.add(obj.getBoardTask());
        }
        return result;
    }

    public RemoteTaskSet hasBoardTask(BoardTask value) {
        RemoteTaskSet result = new RemoteTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RemoteTask obj = (RemoteTask)iterator.next();
            if (value != obj.getBoardTask()) continue;
            result.add(obj);
        }
        return result;
    }

    public RemoteTaskSet withBoardTask(BoardTask value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RemoteTask obj = (RemoteTask)iterator.next();
            obj.setBoardTask(value);
        }
        return this;
    }

    public Object hasRemoteTaskPO() {
        return null;
    }

    public LogEntrySet getLogEntries() {
        LogEntrySet result = new LogEntrySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RemoteTask obj = (RemoteTask)iterator.next();
            result.addAll((Collection)((Object)obj.getLogEntries()));
        }
        return result;
    }

    public RemoteTaskSet hasLogEntries(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        RemoteTaskSet answer = new RemoteTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RemoteTask obj = (RemoteTask)iterator.next();
            if (Collections.disjoint(neighbors, obj.getLogEntries())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public RemoteTaskSet withLogEntries(LogEntry value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RemoteTask obj = (RemoteTask)iterator.next();
            obj.withLogEntries(value);
        }
        return this;
    }

    public RemoteTaskSet withoutLogEntries(LogEntry value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            RemoteTask obj = (RemoteTask)iterator.next();
            obj.withoutLogEntries(value);
        }
        return this;
    }
}

