/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.replication.BoardTask;
import org.sdmlib.replication.Lane;
import org.sdmlib.replication.RemoteTaskBoard;
import org.sdmlib.replication.util.BoardTaskSet;
import org.sdmlib.replication.util.LanePO;
import org.sdmlib.replication.util.RemoteTaskBoardSet;

public class LaneSet
extends SDMSet<Lane> {
    public static final LaneSet EMPTY_SET = (LaneSet)new LaneSet().withReadOnly(true);

    public LanePO hasLanePO() {
        return new LanePO((Lane[])this.toArray(new Lane[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.Lane";
    }

    public LaneSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((Lane)value);
        }
        return this;
    }

    public LaneSet without(Lane value) {
        this.remove(value);
        return this;
    }

    public StringList getName() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            result.add(obj.getName());
        }
        return result;
    }

    public LaneSet hasName(String value) {
        LaneSet result = new LaneSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            if (!value.equals(obj.getName())) continue;
            result.add(obj);
        }
        return result;
    }

    public LaneSet hasName(String lower, String upper) {
        LaneSet result = new LaneSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            if (lower.compareTo(obj.getName()) > 0 || obj.getName().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public LaneSet withName(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            obj.setName(value);
        }
        return this;
    }

    public RemoteTaskBoardSet getBoard() {
        RemoteTaskBoardSet result = new RemoteTaskBoardSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            result.add(obj.getBoard());
        }
        return result;
    }

    public LaneSet hasBoard(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        LaneSet answer = new LaneSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            if (!neighbors.contains(obj.getBoard())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public LaneSet withBoard(RemoteTaskBoard value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            obj.withBoard(value);
        }
        return this;
    }

    public BoardTaskSet getTasks() {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            result.addAll((Collection)((Object)obj.getTasks()));
        }
        return result;
    }

    public LaneSet hasTasks(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        LaneSet answer = new LaneSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            if (Collections.disjoint(neighbors, obj.getTasks())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public LaneSet withTasks(BoardTask value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            obj.withTasks(value);
        }
        return this;
    }

    public LaneSet withoutTasks(BoardTask value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Lane obj = (Lane)iterator.next();
            obj.withoutTasks(value);
        }
        return this;
    }
}

