/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication.util;

import java.beans.PropertyChangeEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.models.modelsets.booleanList;
import org.sdmlib.replication.BoardTask;
import org.sdmlib.replication.Lane;
import org.sdmlib.replication.LogEntry;
import org.sdmlib.replication.SeppelSpaceProxy;
import org.sdmlib.replication.util.BoardTaskPO;
import org.sdmlib.replication.util.LaneSet;
import org.sdmlib.replication.util.LogEntrySet;
import org.sdmlib.replication.util.SeppelSpaceProxySet;

public class BoardTaskSet
extends SDMSet<BoardTask> {
    public static final BoardTaskSet EMPTY_SET = (BoardTaskSet)new BoardTaskSet().withReadOnly(true);

    public BoardTaskPO hasBoardTaskPO() {
        return new BoardTaskPO((BoardTask[])this.toArray(new BoardTask[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.replication.BoardTask";
    }

    public BoardTaskSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((BoardTask)value);
        }
        return this;
    }

    public BoardTaskSet without(BoardTask value) {
        this.remove(value);
        return this;
    }

    public StringList getName() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.add(obj.getName());
        }
        return result;
    }

    public BoardTaskSet hasName(String value) {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (!value.equals(obj.getName())) continue;
            result.add(obj);
        }
        return result;
    }

    public BoardTaskSet hasName(String lower, String upper) {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (lower.compareTo(obj.getName()) > 0 || obj.getName().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public BoardTaskSet withName(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.setName(value);
        }
        return this;
    }

    public StringList getStatus() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.add(obj.getStatus());
        }
        return result;
    }

    public BoardTaskSet hasStatus(String value) {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (!value.equals(obj.getStatus())) continue;
            result.add(obj);
        }
        return result;
    }

    public BoardTaskSet hasStatus(String lower, String upper) {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (lower.compareTo(obj.getStatus()) > 0 || obj.getStatus().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public BoardTaskSet withStatus(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.setStatus(value);
        }
        return this;
    }

    public LogEntrySet getLogEntries() {
        LogEntrySet result = new LogEntrySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.addAll((Collection)((Object)obj.getLogEntries()));
        }
        return result;
    }

    public BoardTaskSet hasLogEntries(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        BoardTaskSet answer = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (Collections.disjoint(neighbors, obj.getLogEntries())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public BoardTaskSet withLogEntries(LogEntry value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withLogEntries(value);
        }
        return this;
    }

    public BoardTaskSet withoutLogEntries(LogEntry value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withoutLogEntries(value);
        }
        return this;
    }

    public LaneSet getLane() {
        LaneSet result = new LaneSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.add(obj.getLane());
        }
        return result;
    }

    public BoardTaskSet hasLane(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        BoardTaskSet answer = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (!neighbors.contains(obj.getLane())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public BoardTaskSet withLane(Lane value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withLane(value);
        }
        return this;
    }

    public BoardTaskSet getNext() {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.addAll((Collection)((Object)obj.getNext()));
        }
        return result;
    }

    public BoardTaskSet hasNext(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        BoardTaskSet answer = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (Collections.disjoint(neighbors, obj.getNext())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public BoardTaskSet getNextTransitive() {
        BoardTaskSet todo = new BoardTaskSet().with(this);
        BoardTaskSet result = new BoardTaskSet();
        while (!todo.isEmpty()) {
            BoardTask current = (BoardTask)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            todo.with(current.getNext().minus(result));
        }
        return result;
    }

    public BoardTaskSet withNext(BoardTask value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withNext(value);
        }
        return this;
    }

    public BoardTaskSet withoutNext(BoardTask value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withoutNext(value);
        }
        return this;
    }

    public BoardTaskSet getPrev() {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.addAll((Collection)((Object)obj.getPrev()));
        }
        return result;
    }

    public BoardTaskSet hasPrev(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        BoardTaskSet answer = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (Collections.disjoint(neighbors, obj.getPrev())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public BoardTaskSet getPrevTransitive() {
        BoardTaskSet todo = new BoardTaskSet().with(this);
        BoardTaskSet result = new BoardTaskSet();
        while (!todo.isEmpty()) {
            BoardTask current = (BoardTask)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            todo.with(current.getPrev().minus(result));
        }
        return result;
    }

    public BoardTaskSet withPrev(BoardTask value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withPrev(value);
        }
        return this;
    }

    public BoardTaskSet withoutPrev(BoardTask value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withoutPrev(value);
        }
        return this;
    }

    public SeppelSpaceProxySet getProxy() {
        SeppelSpaceProxySet result = new SeppelSpaceProxySet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.add(obj.getProxy());
        }
        return result;
    }

    public BoardTaskSet hasProxy(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        BoardTaskSet answer = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (!neighbors.contains(obj.getProxy())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public BoardTaskSet withProxy(SeppelSpaceProxy value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.withProxy(value);
        }
        return this;
    }

    public booleanList getManualExecution() {
        booleanList result = new booleanList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            result.add(obj.isManualExecution());
        }
        return result;
    }

    public BoardTaskSet hasManualExecution(boolean value) {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (value != obj.isManualExecution()) continue;
            result.add(obj);
        }
        return result;
    }

    public BoardTaskSet withManualExecution(boolean value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.setManualExecution(value);
        }
        return this;
    }

    public BoardTaskSet execute() {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.execute();
        }
        return this;
    }

    public BoardTaskSet hasStashedPropertyChangeEvent(PropertyChangeEvent value) {
        BoardTaskSet result = new BoardTaskSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            if (value != obj.getStashedPropertyChangeEvent()) continue;
            result.add(obj);
        }
        return result;
    }

    public BoardTaskSet withStashedPropertyChangeEvent(PropertyChangeEvent value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            BoardTask obj = (BoardTask)iterator.next();
            obj.setStashedPropertyChangeEvent(value);
        }
        return this;
    }
}

