/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeSupport;
import java.util.LinkedHashSet;
import org.sdmlib.replication.LogEntry;
import org.sdmlib.replication.util.LogEntrySet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class Task
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_LOGENTRIES = "logEntries";
    public static final int DO_LOG = 1;
    private LogEntrySet logEntries = null;

    public Object get(String attrName) {
        if (PROPERTY_LOGENTRIES.equalsIgnoreCase(attrName)) {
            return this.getLogEntries();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_LOGENTRIES.equalsIgnoreCase(attrName)) {
            this.addToLogEntries((LogEntry)value);
            return true;
        }
        if ("logEntriesrem".equalsIgnoreCase(attrName)) {
            this.removeFromLogEntries((LogEntry)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.removeAllFromLogEntries();
        this.withoutLogEntries((LogEntry[])this.getLogEntries().toArray(new LogEntry[this.getLogEntries().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public LogEntrySet getLogEntries() {
        if (this.logEntries == null) {
            return LogEntry.EMPTY_SET;
        }
        return this.logEntries;
    }

    public boolean addToLogEntries(LogEntry value) {
        boolean changed = false;
        if (value != null) {
            if (this.logEntries == null) {
                this.logEntries = new LogEntrySet();
            }
            if (changed = this.logEntries.add(value)) {
                value.withTask(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LOGENTRIES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromLogEntries(LogEntry value) {
        boolean changed = false;
        if (this.logEntries != null && value != null && (changed = this.logEntries.remove(value))) {
            value.setTask(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LOGENTRIES, value, null);
        }
        return changed;
    }

    public Task withLogEntries(LogEntry value) {
        this.addToLogEntries(value);
        return this;
    }

    public Task withoutLogEntries(LogEntry value) {
        this.removeFromLogEntries(value);
        return this;
    }

    public void removeAllFromLogEntries() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getLogEntries());
        for (LogEntry value : tmpSet) {
            this.removeFromLogEntries(value);
        }
    }

    public LogEntry createLogEntries() {
        LogEntry value = new LogEntry();
        this.withLogEntries(value);
        return value;
    }

    public Task withLogEntries(LogEntry ... value) {
        for (LogEntry item : value) {
            this.addToLogEntries(item);
        }
        return this;
    }

    public Task withoutLogEntries(LogEntry ... value) {
        for (LogEntry item : value) {
            this.removeFromLogEntries(item);
        }
        return this;
    }
}

