/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.SimpleIdCounter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.list.SimpleKeyValueList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;
import org.sdmlib.StrUtil;
import org.sdmlib.replication.ChangeHistory;
import org.sdmlib.replication.GUIListener;
import org.sdmlib.replication.RemoteTaskBoard;
import org.sdmlib.replication.ReplicationChange;
import org.sdmlib.replication.ReplicationChannel;
import org.sdmlib.replication.ReplicationNode;
import org.sdmlib.replication.ReplicationRoot;
import org.sdmlib.replication.util.ReplicationChangeSet;
import org.sdmlib.replication.util.ReplicationChannelSet;
import org.sdmlib.replication.util.ReplicationNodeCreator;
import org.sdmlib.replication.util.ReplicationRootSet;
import org.sdmlib.replication.util.SharedSpaceCreator;
import org.sdmlib.replication.util.SharedSpaceSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class SharedSpace
extends Thread
implements PropertyChangeInterface,
PropertyChangeListener,
UpdateListener {
    public static final String JLOG = "jlog";
    public static final String CURRENT_HISTORY_ID = "currentHistoryId";
    public static final String TERMINATE = "terminate";
    public static final String RESEND_ID_HISTORY_PREFIX = "resendIdHistoryPrefix";
    public static final String RESEND_ID_HISTORY_NUMBER = "resendIdHistoryNumber";
    private static final String LOWER_ID_PREFIX = "lowerIdPrefix";
    private static final String LOWER_ID_NUMBER = "lowerIdNumber";
    private LinkedBlockingQueue<ChannelMsg> msgQueue = new LinkedBlockingQueue();
    private boolean firstMessage = true;
    private String serverIp;
    private int serverPort;
    private GUIListener listener = null;
    private ReplicationRoot replicationRoot;
    private LinkedHashSet<HookAction> beforeHandleMessageActions = new LinkedHashSet();
    private LinkedHashSet<HookAction> afterHandleMessageActions = new LinkedHashSet();
    private ReplicationChange previousChange = null;
    private File logFile = null;
    private boolean loadingHistory = false;
    private boolean isApplyingChangeMsg = false;
    private int logLevel = 0;
    public static int msgNo = 0;
    private JsonIdMap changeMap = null;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_SPACEID = "spaceId";
    private String spaceId;
    public static final SharedSpaceSet EMPTY_SET = new SharedSpaceSet();
    public static final String PROPERTY_NODE = "node";
    private ReplicationNode node = null;
    public static final String PROPERTY_CHANNELS = "channels";
    private ReplicationChannelSet channels = null;
    private JsonIdMap map;
    public static final String PROPERTY_HISTORY = "history";
    private ChangeHistory history;
    public static final String PROPERTY_LASTCHANGEID = "lastChangeId";
    private long lastChangeId;
    public static final String PROPERTY_NODEID = "nodeId";
    private String nodeId;
    private FileWriter logFileWriter;
    public static final String REMOTE_TASK_BOARD_ROOT = "taskFlowBoardRoot";
    public static final String REPLICATION_ROOT = "replicationRoot";
    private RemoteTaskBoard remoteTaskBoard;
    private boolean readMessages = false;
    public static final String PROPERTY_SOCKET = "socket";
    private Socket socket;
    public static final String PROPERTY_TARGETNODEID = "targetNodeId";
    private String targetNodeId;
    private Map<String, MousePositionInfo> mousePositions = new HashMap<String, MousePositionInfo>();
    public static final String PROPERTY_JAVAFXAPPLICATION = "javaFXApplication";
    private boolean javaFXApplication;

    public SharedSpace() {
    }

    public SharedSpace(String spaceId, String nodeId, String serverIp, int serverPort, JsonIdMap map) {
        this.spaceId = spaceId;
        this.nodeId = nodeId;
        this.serverIp = serverIp;
        this.serverPort = serverPort;
        this.map = map;
    }

    public ReplicationRoot plainInit() {
        this.map.withCreator((Iterable)ReplicationNodeCreator.createIdMap("i"));
        this.map.withUpdateListenerSend((UpdateListener)this);
        this.setReplicationRoot(new ReplicationRoot());
        this.map.put(REPLICATION_ROOT, (Object)this.getReplicationRoot());
        return this.getReplicationRoot();
    }

    public SharedSpace init(PropertyChangeListener laneListener) {
        this.plainInit();
        this.setName("Lane" + this.nodeId);
        ReplicationChannel channel = this.createChannels().withConnect(this.serverIp, this.serverPort);
        channel.setName("ReplicationChannel" + this.nodeId);
        channel.start();
        channel.sendSpaceConnectionRequest(this.spaceId);
        this.waitForCurrentHistoryId();
        if (this.map.getCounter() instanceof SimpleIdCounter) {
            ((SimpleIdCounter)this.map.getCounter()).withNumber(this.lastChangeId);
        }
        this.remoteTaskBoard = new RemoteTaskBoard();
        this.map.put(REMOTE_TASK_BOARD_ROOT, (Object)this.remoteTaskBoard);
        if (laneListener != null) {
            this.remoteTaskBoard.getPropertyChangeSupport().addPropertyChangeListener(laneListener);
            this.replicationRoot.addPropertyChangeListener(laneListener);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void enqueueMsg(ReplicationChannel channel, String msg) {
        try {
            if (this.firstMessage) {
                this.firstMessage = false;
                JsonObject jsonObject = new JsonObject().withValue(new String[]{msg});
                if (jsonObject.get((Object)CURRENT_HISTORY_ID) != null) {
                    long receivedId = Long.parseLong(jsonObject.getString((Object)CURRENT_HISTORY_ID));
                    if (receivedId > this.lastChangeId) {
                        this.lastChangeId = receivedId;
                        SharedSpace sharedSpace = this;
                        synchronized (sharedSpace) {
                            this.notifyAll();
                        }
                    }
                    return;
                }
            }
            final ChannelMsg channelMsg = new ChannelMsg(channel, msg);
            if (this.isJavaFXApplication()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        SharedSpace.this.handleMessage(channelMsg);
                    }
                });
            } else if (this.listener != null) {
                this.listener.enqueueMsg(this, channelMsg);
            } else {
                this.msgQueue.put(channelMsg);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForCurrentHistoryId() {
        while (this.lastChangeId == 0L) {
            try {
                SharedSpace sharedSpace = this;
                synchronized (sharedSpace) {
                    this.wait();
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void run() {
        block2: while (true) {
            try {
                while (true) {
                    ChannelMsg msg = this.msgQueue.take();
                    if (TERMINATE.equals(msg.msg)) {
                        Iterator iterator = this.getChannels().iterator();
                        while (iterator.hasNext()) {
                            ReplicationChannel c = (ReplicationChannel)iterator.next();
                            c.send(TERMINATE);
                        }
                        break block2;
                    }
                    this.handleMessage(msg);
                }
            }
            catch (Exception exception) {
                continue;
            }
            break;
        }
    }

    public void addToBeforeHandleMessageActions(HookAction r) {
        this.beforeHandleMessageActions.add(r);
    }

    public void removeFromBeforeHandleMessageActions(HookAction r) {
        this.beforeHandleMessageActions.remove(r);
    }

    public void addToAfterHandleMessageActions(HookAction r) {
        this.afterHandleMessageActions.add(r);
    }

    public void removeFromAfterHandleMessageActions(HookAction r) {
        this.afterHandleMessageActions.remove(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ChannelMsg msg) {
        try {
            JsonObject jsonObject = new JsonObject().withValue(new String[]{msg.msg});
            this.isApplyingChangeMsg = true;
            if (this.previousChange == null) {
                this.previousChange = new ReplicationChange();
            }
            if (jsonObject.get((Object)PROPERTY_SPACEID) != null) {
                JsonObject jsonHistoryId = new JsonObject();
                jsonHistoryId.put((Object)CURRENT_HISTORY_ID, (Object)this.lastChangeId);
                msg.channel.send(jsonHistoryId.toString());
                this.previousChange.withHistoryIdNumber(0L).withHistoryIdPrefix(" ");
                this.sendAllChangesSince(this.previousChange, msg.channel);
                return;
            }
            if (jsonObject.get((Object)RESEND_ID_HISTORY_NUMBER) != null) {
                this.previousChange.setHistoryIdNumber(jsonObject.getLong(RESEND_ID_HISTORY_NUMBER));
                this.previousChange.setHistoryIdPrefix(jsonObject.getString((Object)RESEND_ID_HISTORY_PREFIX));
                this.sendAllChangesSince(this.previousChange, msg.channel);
                return;
            }
            JsonIdMap cmap = this.getChangeMap();
            ReplicationChange change = (ReplicationChange)cmap.decode(jsonObject);
            change.setChangeMsg(EntityUtil.unQuote((String)change.getChangeMsg()));
            if (this.getHistory().getChanges().contains(change)) {
                change.withLog("ignore change already known", this.getName());
                return;
            }
            if (change.getHistoryIdNumber() <= -2L) {
                System.out.println("Handling change\n" + change.toString());
            }
            String key = change.getTargetObjectId() + "|" + change.getTargetProperty();
            Object oldChange = this.getHistory().getChangeMap().get(key);
            if (change.getIsToManyProperty()) {
                if (oldChange == null) {
                    this.applyChange(change, msg.channel);
                } else {
                    ReplicationChangeSet oldChanges = (ReplicationChangeSet)oldChange;
                    ReplicationChange higher = oldChanges.higher(change);
                    if (higher == null) {
                        this.applyChange(change, msg.channel);
                    } else {
                        Iterator keyIter;
                        String changeMsg = higher.getChangeMsg();
                        JsonObject higherJson = new JsonObject().withValue(new String[]{changeMsg});
                        String sourceId = higherJson.getString((Object)"id");
                        Object sourceObject = this.map.getObject(sourceId);
                        JsonObject updateJson = (JsonObject)higherJson.get((Object)"upd");
                        if (updateJson == null) {
                            updateJson = (JsonObject)higherJson.get((Object)"rem");
                        }
                        if ((keyIter = updateJson.keyIterator()).hasNext()) {
                            String property = (String)keyIter.next();
                            JsonObject targetJson = updateJson.getJsonObject(property);
                            String targetId = targetJson.getString((Object)"id");
                            Object targetObj = this.map.getObject(targetId);
                            SendableEntityCreator creatorClass = this.map.getCreatorClass(sourceObject);
                            Collection collection = (Collection)creatorClass.getValue(sourceObject, property);
                            LinkedList higherList = new LinkedList();
                            boolean found = false;
                            for (Object obj : collection) {
                                if (obj == targetObj) {
                                    found = true;
                                }
                                if (!found) continue;
                                higherList.add(obj);
                            }
                            for (Object obj : higherList) {
                                creatorClass.setValue(sourceObject, property + "rem", obj, null);
                            }
                            this.applyChange(change, msg.channel);
                            for (Object obj : higherList) {
                                creatorClass.setValue(sourceObject, property, obj, null);
                            }
                        }
                    }
                }
            } else if (oldChange == null || ((ReplicationChange)oldChange).compareTo(change) < 0) {
                this.applyChange(change, msg.channel);
            } else {
                this.getHistory().addToChanges(change);
                this.getHistory().addToObsoleteChanges(change);
            }
        }
        finally {
            this.isApplyingChangeMsg = false;
        }
    }

    public void sendAllChangesSince(ReplicationChange lower, ReplicationChannel channel) {
        if (lower == null) {
            lower = new ReplicationChange().withHistoryIdNumber(0L).withHistoryIdPrefix(" ");
        }
        for (ReplicationChange change : this.getHistory().getChanges().tailSet(lower)) {
            if (this.logLevel >= 1) {
                change.withLog("resending", this.getName());
            }
            this.sendChangeTo(channel, change);
        }
    }

    private void sendChangeTo(ReplicationChannel channel, ReplicationChange change) {
        if (channel == null) {
            return;
        }
        JsonIdMap cmap = this.getChangeMap();
        JsonObject jsonObject = cmap.toJsonObject((Object)change);
        ReplicationChange lower = this.getHistory().getChanges().lower(change);
        if (lower != null) {
            jsonObject.put((Object)LOWER_ID_NUMBER, (Object)lower.getHistoryIdNumber());
            jsonObject.put((Object)LOWER_ID_PREFIX, (Object)lower.getHistoryIdPrefix());
        }
        String line = jsonObject.toString();
        channel.send(line);
    }

    private void applyChange(ReplicationChange change, ReplicationChannel sender) {
        this.applyChangeLocally(change);
        this.sendNewChange(change);
        for (ReplicationChange newerChange : this.getHistory().getChanges().tailSet(change, false)) {
            this.sendChangeTo(sender, newerChange);
        }
    }

    public void applyNoConflictChange(ReplicationChange change) {
        String key = change.getTargetObjectId() + "|" + change.getTargetProperty();
        Object oldChange = this.getHistory().getChangeMap().get(key);
        if (change.getIsToManyProperty()) {
            this.applyChangeLocally(change);
        } else if (oldChange == null || ((ReplicationChange)oldChange).compareTo(change) < 0) {
            this.applyChangeLocally(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangeLocally(ReplicationChange change) {
        JsonObject jsonUpdate = new JsonObject();
        new JsonTokener().withAllowCRLF(true).withText(change.getChangeMsg()).parseToEntity((SimpleKeyValueList)jsonUpdate);
        for (HookAction r : this.beforeHandleMessageActions) {
            r.run(change);
        }
        try {
            this.setReadMessages(true);
            this.map.executeUpdateMsg(jsonUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setReadMessages(false);
        }
        this.getHistory().addChange(change);
        this.lastChangeId = Math.max(this.lastChangeId, change.getHistoryIdNumber());
        change.withLog("change applied", this.getName());
        for (HookAction r : this.afterHandleMessageActions) {
            r.run(change);
        }
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
        try {
            this.logFileWriter = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeChange(ReplicationChange change) {
        if (this.loadingHistory) {
            return;
        }
        try {
            if (this.logFile == null) {
                boolean result = new File("./SharedSpace/").mkdirs();
                this.logFile = new File("./SharedSpace/" + this.getSpaceId() + "_" + this.getNodeId() + ".json");
                result = this.logFile.createNewFile();
            }
            this.logFileWriter = new FileWriter(this.logFile, true);
            JsonObject jsonObject = this.getChangeMap().toJsonObject((Object)change);
            this.logFileWriter.write(jsonObject.toString() + "\n");
            this.logFileWriter.flush();
            this.logFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadHistoryFromFile() {
        File historyfile;
        File backupFile = new File("./SharedSpace/" + this.getSpaceId() + "_" + this.getNodeId() + ".json.backup");
        if (backupFile.exists()) {
            backupFile.delete();
        }
        if ((historyfile = new File("./SharedSpace/" + this.getSpaceId() + "_" + this.getNodeId() + ".json")).exists()) {
            historyfile.renameTo(backupFile);
            try {
                BufferedReader in = new BufferedReader(new FileReader(backupFile));
                String line = in.readLine();
                while (line != null) {
                    ChannelMsg msg = new ChannelMsg(null, line);
                    this.handleMessage(msg);
                    line = in.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHistoryFromFile(File file) {
        if (file.exists()) {
            try {
                this.loadingHistory = true;
                BufferedReader in = new BufferedReader(new FileReader(file));
                String line = in.readLine();
                while (line != null) {
                    ChannelMsg msg = new ChannelMsg(null, line);
                    this.handleMessage(msg);
                    line = in.readLine();
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.loadingHistory = false;
            }
        }
    }

    public void storeMyHistoryCompressed() {
        String loginName = this.logFile.getName();
        loginName = loginName.split("\\.")[0];
        File backupFile = new File(this.logFile.getAbsolutePath() + ".backup");
        try {
            Files.copy(this.logFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            new RandomAccessFile(this.logFile, "rw").setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ReplicationChange change : this.getHistory().getChanges()) {
            if (!change.getHistoryIdPrefix().equals(loginName)) continue;
            this.writeChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHistoryFromDir(File logDir) {
        if (logDir.exists() && logDir.isDirectory()) {
            ArrayList<ReplicationChange> changeList = new ArrayList<ReplicationChange>();
            for (File file : logDir.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith(JLOG)) continue;
                try {
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    String line = in.readLine();
                    while (line != null) {
                        JsonObject jsonObject = new JsonObject().withValue(new String[]{line});
                        ReplicationChange change = (ReplicationChange)this.getChangeMap().decode(jsonObject);
                        change.setChangeMsg(EntityUtil.unQuote((String)change.getChangeMsg()));
                        changeList.add(change);
                        line = in.readLine();
                    }
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Collections.sort(changeList);
            try {
                this.isApplyingChangeMsg = true;
                this.loadingHistory = true;
                for (ReplicationChange change : changeList) {
                    this.applyChangeLocally(change);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.isApplyingChangeMsg = false;
                this.loadingHistory = false;
            }
        }
    }

    public boolean isApplyingChangeMsg() {
        return this.isApplyingChangeMsg;
    }

    public void setApplyingChangeMsg(boolean isApplyingChangeMsg) {
        this.isApplyingChangeMsg = isApplyingChangeMsg;
    }

    public boolean update(String typ, BaseItem jsonObject, Object target, String property, Object oldValue, Object newValue) {
        Object targetObject;
        SendableEntityCreator creator;
        Object value;
        JsonObject jsonUpdate;
        Iterator iter;
        if (this.isApplyingChangeMsg) {
            return true;
        }
        ReplicationChange change = new ReplicationChange().withHistoryIdPrefix(this.nodeId).withHistoryIdNumber(this.getNewHistoryIdNumber()).withTargetObjectId((String)jsonObject.getValueItem((Object)"id")).withChangeMsg(jsonObject.toString());
        Object object = jsonObject.getValueItem((Object)"upd");
        if (object == null) {
            object = jsonObject.getValueItem((Object)"rem");
        }
        if (object != null && (iter = (jsonUpdate = (JsonObject)object).keyIterator()).hasNext()) {
            String prop = (String)iter.next();
            change.withTargetProperty(prop);
        }
        if ((value = (creator = this.map.getCreatorClass(targetObject = this.map.getObject(change.getTargetObjectId()))).getValue(targetObject, change.getTargetProperty())) != null && value instanceof Collection) {
            change.setIsToManyProperty(true);
        }
        if (this.logLevel >= 1) {
            change.withLog("change recorded", this.getName());
        }
        this.getHistory().addChange(change);
        this.writeChange(change);
        this.sendNewChange(change);
        return true;
    }

    private void sendNewChange(ReplicationChange change) {
        JsonIdMap cmap = this.getChangeMap();
        JsonObject jsonObject = cmap.toJsonObject((Object)change);
        ReplicationChange lower = this.getHistory().getChanges().lower(change);
        if (lower != null) {
            jsonObject.put((Object)LOWER_ID_NUMBER, (Object)lower.getHistoryIdNumber());
            jsonObject.put((Object)LOWER_ID_PREFIX, (Object)lower.getHistoryIdPrefix());
        }
        String line = jsonObject.toString();
        Iterator iterator = this.getChannels().iterator();
        while (iterator.hasNext()) {
            ReplicationChannel channel = (ReplicationChannel)iterator.next();
            channel.send(line);
        }
    }

    public long getNewHistoryIdNumber() {
        ++this.lastChangeId;
        return this.lastChangeId;
    }

    public long getNewHistoryIdNumber(int increment) {
        this.lastChangeId += (long)increment;
        return this.lastChangeId;
    }

    public JsonIdMap getChangeMap() {
        if (this.changeMap == null) {
            this.changeMap = ReplicationNodeCreator.createIdMap(this.nodeId);
        }
        return this.changeMap;
    }

    public Object get(String attrName) {
        if (PROPERTY_SPACEID.equalsIgnoreCase(attrName)) {
            return this.getSpaceId();
        }
        if (PROPERTY_NODE.equalsIgnoreCase(attrName)) {
            return this.getNode();
        }
        if (PROPERTY_CHANNELS.equalsIgnoreCase(attrName)) {
            return this.getChannels();
        }
        if (PROPERTY_HISTORY.equalsIgnoreCase(attrName)) {
            return this.getHistory();
        }
        if (PROPERTY_LASTCHANGEID.equalsIgnoreCase(attrName)) {
            return this.getLastChangeId();
        }
        if (PROPERTY_NODEID.equalsIgnoreCase(attrName)) {
            return this.getNodeId();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_SPACEID.equalsIgnoreCase(attrName)) {
            this.setSpaceId((String)value);
            return true;
        }
        if (PROPERTY_NODE.equalsIgnoreCase(attrName)) {
            this.setNode((ReplicationNode)value);
            return true;
        }
        if (PROPERTY_CHANNELS.equalsIgnoreCase(attrName)) {
            this.addToChannels((ReplicationChannel)value);
            return true;
        }
        if ("channelsrem".equalsIgnoreCase(attrName)) {
            this.removeFromChannels((ReplicationChannel)value);
            return true;
        }
        if (PROPERTY_HISTORY.equalsIgnoreCase(attrName)) {
            this.setHistory((ChangeHistory)value);
            return true;
        }
        if (PROPERTY_LASTCHANGEID.equalsIgnoreCase(attrName)) {
            this.setLastChangeId(Long.parseLong(value.toString()));
            return true;
        }
        if (PROPERTY_NODEID.equalsIgnoreCase(attrName)) {
            this.setNodeId((String)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.setNode(null);
        this.removeAllFromChannels();
        this.withoutChannels((ReplicationChannel[])this.getChannels().toArray(new ReplicationChannel[this.getChannels().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String value) {
        if (!StrUtil.stringEquals(this.spaceId, value)) {
            String oldValue = this.spaceId;
            this.spaceId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SPACEID, oldValue, value);
        }
    }

    public SharedSpace withSpaceId(String value) {
        this.setSpaceId(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(" SharedSpace");
        sb.append(" ").append(this.getSpaceId());
        sb.append(" ").append(this.getNodeId());
        return sb.substring(1);
    }

    public ReplicationNode getNode() {
        return this.node;
    }

    public boolean setNode(ReplicationNode value) {
        boolean changed = false;
        if (this.node != value) {
            ReplicationNode oldValue = this.node;
            if (this.node != null) {
                this.node = null;
                oldValue.withoutSharedSpaces(this);
            }
            this.node = value;
            if (value != null) {
                value.withSharedSpaces(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NODE, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public SharedSpace withNode(ReplicationNode value) {
        this.setNode(value);
        return this;
    }

    public ReplicationNode createNode() {
        ReplicationNode value = new ReplicationNode();
        this.withNode(value);
        return value;
    }

    public JsonIdMap getMap() {
        return this.map;
    }

    public void setMap(JsonIdMap map) {
        this.map = map;
    }

    public ReplicationChannelSet getChannels() {
        if (this.channels == null) {
            return ReplicationChannel.EMPTY_SET;
        }
        return this.channels;
    }

    public boolean addToChannels(ReplicationChannel value) {
        boolean changed = false;
        if (value != null) {
            if (this.channels == null) {
                this.channels = new ReplicationChannelSet();
            }
            if (changed = this.channels.add(value)) {
                value.withSharedSpace(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHANNELS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromChannels(ReplicationChannel value) {
        boolean changed = false;
        if (this.channels != null && value != null && (changed = this.channels.remove(value))) {
            value.setSharedSpace(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHANNELS, value, null);
        }
        return changed;
    }

    public SharedSpace withChannels(ReplicationChannel value) {
        this.addToChannels(value);
        return this;
    }

    public SharedSpace withoutChannels(ReplicationChannel value) {
        this.removeFromChannels(value);
        return this;
    }

    public void removeAllFromChannels() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getChannels());
        for (ReplicationChannel value : tmpSet) {
            this.removeFromChannels(value);
        }
    }

    public ReplicationChannel createChannels() {
        ReplicationChannel value = new ReplicationChannel();
        this.withChannels(value);
        return value;
    }

    public ReplicationChannel createChannels(String hostName, int replicationServerPort) {
        ReplicationChannel channel = this.createChannels();
        channel.setName("ReplicationChannel" + this.getNodeId() + "Server");
        channel.withConnect(hostName, replicationServerPort);
        return channel;
    }

    public void withMap(JsonIdMap map) {
        this.map = map;
        map.withUpdateListenerSend((UpdateListener)this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
    }

    public ChangeHistory getHistory() {
        if (this.history == null) {
            this.history = new ChangeHistory();
        }
        return this.history;
    }

    public void setHistory(ChangeHistory value) {
        if (this.history != value) {
            ChangeHistory oldValue = this.history;
            this.history = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HISTORY, oldValue, value);
        }
    }

    public SharedSpace withHistory(ChangeHistory value) {
        this.setHistory(value);
        return this;
    }

    public long getLastChangeId() {
        return this.lastChangeId;
    }

    public void setLastChangeId(long value) {
        if (this.lastChangeId != value) {
            long oldValue = this.lastChangeId;
            this.lastChangeId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LASTCHANGEID, oldValue, value);
        }
    }

    public SharedSpace withLastChangeId(long value) {
        this.setLastChangeId(value);
        return this;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String value) {
        if (!StrUtil.stringEquals(this.nodeId, value)) {
            String oldValue = this.nodeId;
            this.nodeId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NODEID, oldValue, value);
        }
    }

    public SharedSpace withNodeId(String value) {
        this.setNodeId(value);
        return this;
    }

    public <T> T glueObjectsAtId(String id, T newObj) {
        Object oldObj = this.map.getObject(id);
        if (oldObj == null) {
            this.map.put(id, newObj);
            return newObj;
        }
        String newKey = this.map.getKey(newObj);
        SendableEntityCreator creator = this.map.getCreatorClass(oldObj);
        for (String prop : creator.getProperties()) {
            Object value = creator.getValue(newObj, prop);
            if (value != null && value instanceof Collection) {
                for (Object elem : (Collection)value) {
                    creator.setValue(oldObj, prop, elem, "");
                }
                continue;
            }
            if (value == null) continue;
            creator.setValue(oldObj, prop, value, "");
        }
        return (T)oldObj;
    }

    public RemoteTaskBoard getRemoteTaskBoard() {
        return this.remoteTaskBoard;
    }

    public void setRemoteTaskBoard(RemoteTaskBoard remoteTaskBoard) {
        this.remoteTaskBoard = remoteTaskBoard;
    }

    public void setReadMessages(boolean readMessages) {
        this.readMessages = readMessages;
    }

    public boolean isReadMessages() {
        return this.readMessages;
    }

    public SharedSpace withChannels(ReplicationChannel ... value) {
        for (ReplicationChannel item : value) {
            this.addToChannels(item);
        }
        return this;
    }

    public SharedSpace withoutChannels(ReplicationChannel ... value) {
        for (ReplicationChannel item : value) {
            this.removeFromChannels(item);
        }
        return this;
    }

    public Object getSharedObject(String objectName) {
        ReplicationRoot replicationRoot = (ReplicationRoot)this.map.getObject(REPLICATION_ROOT);
        if (replicationRoot != null) {
            ReplicationRootSet kids = replicationRoot.getKids();
            Iterator iterator = kids.iterator();
            while (iterator.hasNext()) {
                ReplicationRoot kid = (ReplicationRoot)iterator.next();
                if (!StrUtil.stringEquals(kid.getName(), objectName)) continue;
                return kid.getApplicationObject();
            }
        }
        return null;
    }

    public boolean isLoadingHistory() {
        return this.loadingHistory;
    }

    public void setLoadingHistory(boolean loadingHistory) {
        this.loadingHistory = loadingHistory;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket value) {
        if (this.socket != value) {
            Socket oldValue = this.socket;
            this.socket = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SOCKET, oldValue, value);
        }
    }

    public SharedSpace withSocket(Socket value) {
        this.setSocket(value);
        return this;
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String value) {
        if (!StrUtil.stringEquals(this.targetNodeId, value)) {
            String oldValue = this.targetNodeId;
            this.targetNodeId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TARGETNODEID, oldValue, value);
        }
    }

    public SharedSpace withTargetNodeId(String value) {
        this.setTargetNodeId(value);
        return this;
    }

    public SharedSpace withGUIListener(GUIListener listener) {
        this.listener = listener;
        return this;
    }

    public void setMousePositionAndWindowIdForUser(String userId, double x, double y, String windowId) {
        MousePositionInfo info = this.mousePositions.get(userId);
        if (info == null) {
            info = new MousePositionInfo();
            this.mousePositions.put(userId, info);
        }
        info.xPos = x;
        info.yPos = y;
        info.windowId = windowId;
    }

    public MousePositionInfo getMousePositionForUser(String userId, String windowId) {
        MousePositionInfo info = this.mousePositions.get(userId);
        if (info != null && info.windowId.equals(windowId)) {
            return info;
        }
        return null;
    }

    public ReplicationRoot getReplicationRoot() {
        return this.replicationRoot;
    }

    public void setReplicationRoot(ReplicationRoot replicationRoot) {
        this.replicationRoot = replicationRoot;
    }

    public boolean isJavaFXApplication() {
        return this.javaFXApplication;
    }

    public void setJavaFXApplication(boolean value) {
        if (this.javaFXApplication != value) {
            boolean oldValue = this.javaFXApplication;
            this.javaFXApplication = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_JAVAFXAPPLICATION, oldValue, value);
        }
    }

    public SharedSpace withJavaFXApplication(boolean value) {
        this.setJavaFXApplication(value);
        return this;
    }

    public SharedSpace init(JsonIdMap userModelIdMap, boolean javaFXApplication) {
        String userName = userModelIdMap.getCounter().getPrefixId();
        this.withSpaceId(userName + "Space").withNodeId(userName + "Node").withJavaFXApplication(javaFXApplication);
        this.withMap(userModelIdMap);
        userModelIdMap.withCreator((Iterable)SharedSpaceCreator.createIdMap(null));
        return this;
    }

    public void put(String string, Object object) {
        this.getMap().put(string, object);
    }

    public static class MousePositionInfo {
        private double xPos;
        private double yPos;
        private String windowId;

        public double getXPos() {
            return this.xPos;
        }

        public double getYPos() {
            return this.yPos;
        }

        public String getWindowId() {
            return this.windowId;
        }
    }

    public class ChannelMsg {
        public ReplicationChannel channel;
        public String msg;

        public ChannelMsg(ReplicationChannel channel, String msg) {
            this.channel = channel;
            this.msg = msg;
        }
    }

    public static abstract class HookAction {
        public abstract void run(ReplicationChange var1);
    }
}

