/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.sdmlib.replication.ReplicationChannel;
import org.sdmlib.replication.ReplicationNode;
import org.sdmlib.replication.SharedSpace;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ServerSocketAcceptThread
extends Thread
implements PropertyChangeInterface {
    public int port;
    public ReplicationNode replicationNode;
    private SharedSpace sharedSpace;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_PORT = "port";
    public static final String PROPERTY_REPLICATIONNODE = "replicationNode";

    public ServerSocketAcceptThread(ReplicationNode replicationNode, int replicationServerPort) {
        this.replicationNode = replicationNode;
        this.port = replicationServerPort;
    }

    public ServerSocketAcceptThread() {
    }

    public ServerSocketAcceptThread(SharedSpace sharedSpace, int port) {
        this.sharedSpace = sharedSpace;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("SocketAcceptThread");
        ServerSocket serverSocket = null;
        try {
            try {
                serverSocket = new ServerSocket(this.port);
                int i = 1;
                while (true) {
                    Socket connection = serverSocket.accept();
                    ReplicationChannel channel = new ReplicationChannel(this.replicationNode, connection);
                    channel.setName("ReplicationChannel" + i++);
                    channel.setSharedSpace(this.sharedSpace);
                    channel.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            throw throwable;
        }
    }

    public Object get(String attrName) {
        if (PROPERTY_PORT.equalsIgnoreCase(attrName)) {
            return this.getPort();
        }
        if (PROPERTY_REPLICATIONNODE.equalsIgnoreCase(attrName)) {
            return this.getReplicationNode();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_PORT.equalsIgnoreCase(attrName)) {
            this.setPort(Integer.parseInt(value.toString()));
            return true;
        }
        if (PROPERTY_REPLICATIONNODE.equalsIgnoreCase(attrName)) {
            this.setReplicationNode((ReplicationNode)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        if (this.port != value) {
            int oldValue = this.port;
            this.port = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PORT, oldValue, value);
        }
    }

    public ServerSocketAcceptThread withPort(int value) {
        this.setPort(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getPort());
        return s.substring(1);
    }

    public ReplicationNode getReplicationNode() {
        return this.replicationNode;
    }

    public void setReplicationNode(ReplicationNode value) {
        if (this.replicationNode != value) {
            ReplicationNode oldValue = this.replicationNode;
            this.replicationNode = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_REPLICATIONNODE, oldValue, value);
        }
    }

    public ServerSocketAcceptThread withReplicationNode(ReplicationNode value) {
        this.setReplicationNode(value);
        return this;
    }
}

