/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import de.uniks.networkparser.list.SimpleKeyValueList;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.sdmlib.replication.BoardTask;
import org.sdmlib.replication.SeppelBoardTaskAction;
import org.sdmlib.replication.SeppelSpace;

public class SeppelTaskHandler
implements PropertyChangeListener {
    private SeppelSpace seppelSpace;
    SimpleKeyValueList<String, SeppelBoardTaskAction> handlerList = new SimpleKeyValueList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getNewValue() != null) {
            BoardTask task = (BoardTask)evt.getNewValue();
            SeppelBoardTaskAction runnable = (SeppelBoardTaskAction)this.handlerList.get((Object)task.getName());
            boolean oldApplyingChangeMsg = this.seppelSpace.isApplyingChangeMsg();
            try {
                this.seppelSpace.setApplyingChangeMsg(false);
                runnable.run(task);
            }
            catch (Exception e) {
                if (!Exception.class.getName().equals(task.getName())) {
                    BoardTask exceptionTask = new BoardTask().withName(Exception.class.getName());
                    exceptionTask.withTaskObject("failedTask", task).withTaskObject(Exception.class.getName(), e);
                    PropertyChangeEvent newEvt = new PropertyChangeEvent(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), exceptionTask);
                    this.propertyChange(newEvt);
                } else {
                    e.printStackTrace();
                }
            }
            finally {
                this.seppelSpace.setApplyingChangeMsg(oldApplyingChangeMsg);
            }
        }
    }

    public SeppelTaskHandler withSeppelSpace(SeppelSpace seppelSpace) {
        this.seppelSpace = seppelSpace;
        return this;
    }

    public SeppelTaskHandler with(String string, SeppelBoardTaskAction runnable) {
        this.handlerList.put((Object)string, (Object)runnable);
        return this;
    }
}

