/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import de.uniks.networkparser.EntityUtil;
import de.uniks.networkparser.Filter;
import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.json.JsonTokener;
import de.uniks.networkparser.list.SimpleKeyValueList;
import de.uniks.networkparser.logic.Condition;
import de.uniks.networkparser.logic.ConditionMap;
import de.uniks.networkparser.logic.Deep;
import de.uniks.networkparser.logic.ValuesMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;
import org.sdmlib.StrUtil;
import org.sdmlib.replication.ChangeHistory;
import org.sdmlib.replication.ReplicationChange;
import org.sdmlib.replication.SeppelChannel;
import org.sdmlib.replication.SeppelScope;
import org.sdmlib.replication.SeppelSpaceProxy;
import org.sdmlib.replication.SeppelTaskHandler;
import org.sdmlib.replication.util.ObjectSet;
import org.sdmlib.replication.util.ReplicationChangeSet;
import org.sdmlib.replication.util.ReplicationNodeCreator;
import org.sdmlib.replication.util.SeppelScopeSet;
import org.sdmlib.replication.util.SeppelSpaceCreator;
import org.sdmlib.serialization.PropertyChangeInterface;

public class SeppelSpace
extends Thread
implements PropertyChangeInterface,
UpdateListener {
    private LinkedBlockingQueue<ChannelMsg> msgQueue = new LinkedBlockingQueue();
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_SPACEID = "spaceId";
    private String spaceId;
    private SeppelSpaceProxy selfProxy;
    public static final String PROPERTY_HISTORY = "history";
    private ChangeHistory history;
    public static final String PROPERTY_LASTCHANGEID = "lastChangeId";
    private long lastChangeId;
    public static final String PROPERTY_JAVAFXAPPLICATION = "javaFXApplication";
    private boolean javaFXApplication;
    private JsonIdMap map;
    private boolean isApplyingChangeMsg = false;
    private File logFile = null;
    private FileWriter logFileWriter;
    private boolean loadingHistory = false;
    private JsonIdMap changeMap = null;
    private boolean readMessages = false;
    SeppelTaskHandler taskHandler = null;

    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    ChannelMsg msg = this.msgQueue.take();
                    this.handleMessage(msg);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void enqueueMsg(SeppelChannel channel, String msg) {
        try {
            final ChannelMsg channelMsg = new ChannelMsg(channel, msg);
            if (this.isJavaFXApplication()) {
                Platform.runLater((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        try {
                            SeppelSpace.this.handleMessage(channelMsg);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                });
            } else {
                this.msgQueue.put(channelMsg);
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleMessage(ChannelMsg msg) {
        try {
            JsonObject jsonObject = new JsonObject().withValue(new String[]{msg.msg});
            if (msg.channel != null && !msg.channel.isLoginValidated()) {
                try {
                    String spaceId = jsonObject.getString((Object)PROPERTY_SPACEID);
                    String login = jsonObject.getString((Object)"login");
                    String pwd = jsonObject.getString((Object)"pwd");
                    SeppelSpaceProxy theSpace = (SeppelSpaceProxy)this.getSelfProxy().getPartners().hasLoginName(login).hasPassword(pwd).first();
                    theSpace.withChannel(msg.channel);
                    msg.channel.setLoginValidated(true);
                }
                finally {
                    try {
                        msg.channel.getMsgQueue().put("check");
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    this.sendAllChanges(msg.channel);
                }
                return;
            }
            this.isApplyingChangeMsg = true;
            JsonIdMap cmap = this.getChangeMap();
            ReplicationChange change = (ReplicationChange)cmap.decode(jsonObject);
            if (this.getHistory().getChanges().contains(change)) {
                return;
            }
            String key = change.getTargetObjectId() + "|" + change.getTargetProperty();
            Object oldChange = this.getHistory().getChangeMap().get(key);
            if (change.getIsToManyProperty()) {
                if (oldChange == null) {
                    this.applyChange(change, msg.channel);
                } else {
                    ReplicationChangeSet oldChanges = (ReplicationChangeSet)oldChange;
                    ReplicationChange higher = oldChanges.higher(change);
                    if (higher == null) {
                        this.applyChange(change, msg.channel);
                    } else {
                        boolean setOfProps = false;
                        String changeMsg = higher.getChangeMsg();
                        JsonObject higherJson = new JsonObject().withValue(new String[]{changeMsg});
                        String sourceId = higherJson.getString((Object)"id");
                        Object sourceObject = this.map.getObject(sourceId);
                        JsonObject updateJson = (JsonObject)higherJson.get((Object)"upd");
                        if (updateJson == null) {
                            updateJson = (JsonObject)higherJson.get((Object)"rem");
                        }
                        if (updateJson == null && (updateJson = (JsonObject)higherJson.get((Object)"prop")) != null) {
                            setOfProps = true;
                            this.applyChange(change, msg.channel);
                        }
                        if (updateJson == null) {
                            System.out.println("ups");
                        }
                        Iterator keyIter = updateJson.keyIterator();
                        if (!setOfProps && keyIter.hasNext()) {
                            String property = (String)keyIter.next();
                            Object object = updateJson.get((Object)property);
                            if (object == null || !(object instanceof JsonObject)) {
                                System.out.println("Problem at SeppelSpace line 248 ");
                            }
                            JsonObject targetJson = updateJson.getJsonObject(property);
                            String targetId = targetJson.getString((Object)"id");
                            Object targetObj = this.map.getObject(targetId);
                            SendableEntityCreator creatorClass = this.map.getCreatorClass(sourceObject);
                            Collection collection = (Collection)creatorClass.getValue(sourceObject, property);
                            LinkedList higherList = new LinkedList();
                            boolean found = false;
                            for (Object obj : collection) {
                                if (obj == targetObj) {
                                    found = true;
                                }
                                if (!found) continue;
                                higherList.add(obj);
                            }
                            for (Object obj : higherList) {
                                creatorClass.setValue(sourceObject, property + "rem", obj, null);
                            }
                            this.applyChange(change, msg.channel);
                            for (Object obj : higherList) {
                                creatorClass.setValue(sourceObject, property, obj, null);
                            }
                        }
                    }
                }
            } else if (oldChange == null || ((ReplicationChange)oldChange).compareTo(change) < 0) {
                this.applyChange(change, msg.channel);
            } else {
                this.getHistory().addToChanges(change);
                this.getHistory().addToObsoleteChanges(change);
            }
        }
        finally {
            this.isApplyingChangeMsg = false;
        }
    }

    private void applyChange(ReplicationChange change, SeppelChannel sender) {
        this.applyChangeLocally(change);
        this.sendNewChange(change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangeLocally(ReplicationChange change) {
        JsonObject jsonUpdate = new JsonObject();
        try {
            this.setReadMessages(true);
            new JsonTokener().withAllowCRLF(true).withText(change.getChangeMsg()).parseToEntity((SimpleKeyValueList)jsonUpdate);
            this.map.executeUpdateMsg(jsonUpdate);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            this.setReadMessages(false);
        }
        this.getHistory().addChange(change);
        this.writeChange(change);
        this.lastChangeId = Math.max(this.lastChangeId, change.getHistoryIdNumber());
    }

    public boolean update(String typ, BaseItem item, Object target, String property, Object oldValue, Object newValue) {
        Object targetObject;
        SendableEntityCreator creator;
        Object value;
        Iterator iter;
        if (this.isApplyingChangeMsg) {
            return true;
        }
        JsonObject jsonObject = (JsonObject)item;
        ReplicationChange change = new ReplicationChange().withHistoryIdPrefix(this.spaceId).withHistoryIdNumber(this.getNewHistoryIdNumber()).withTargetObjectId(jsonObject.getString((Object)"id")).withChangeMsg(jsonObject.toString());
        Object object = jsonObject.get((Object)"upd");
        if (object == null) {
            object = jsonObject.get((Object)"rem");
        }
        JsonObject valueJsonObject = null;
        JsonObject jsonUpdate = null;
        String prop = null;
        if (object != null && (iter = (jsonUpdate = (JsonObject)object).keyIterator()).hasNext()) {
            prop = (String)iter.next();
            change.withTargetProperty(prop);
            Object obj = jsonUpdate.get((Object)prop);
            if (obj instanceof JsonObject) {
                valueJsonObject = (JsonObject)obj;
            }
        }
        if ((value = (creator = this.map.getCreatorClass(targetObject = this.map.getObject(change.getTargetObjectId()))).getValue(targetObject, change.getTargetProperty())) != null && value instanceof Collection) {
            change.setIsToManyProperty(true);
        }
        if (target instanceof SeppelScope && "observedObjects".equals(change.getTargetProperty()) && valueJsonObject != null) {
            if (valueJsonObject.get((Object)"id") != null && valueJsonObject.size() == 1) {
                String valueObjectId = valueJsonObject.getString((Object)"id");
                Object valueObject = this.map.getObject(valueObjectId);
                ObjectSet explicitElems = ((SeppelScope)target).getObservedObjects();
                JsonObject newValueJsonObject = this.map.toJsonObject(valueObject, new Filter().withPropertyRegard((Condition)new RestrictToFilter(explicitElems)));
                jsonUpdate.put((Object)prop, (Object)newValueJsonObject);
                change.withChangeMsg(jsonObject.toString());
            }
        } else if (target instanceof SeppelScope && "spaces".equals(change.getTargetProperty()) && valueJsonObject != null) {
            JsonObject newValueJsonObject = this.map.toJsonObject(target, new Filter().withConvertable((Condition)new Deep().withDeep(0)));
            JsonArray spaceArray = new JsonArray();
            spaceArray.add((Object)valueJsonObject);
            JsonObject selfProxyId = new JsonObject();
            selfProxyId.put((Object)"id", (Object)this.map.getKey((Object)this.selfProxy));
            spaceArray.add((Object)selfProxyId);
            jsonUpdate.put((Object)"scopeName", (Object)((SeppelScope)target).getScopeName());
            jsonUpdate.put((Object)"spaces", (Object)spaceArray);
            jsonObject.put((Object)"prop", (Object)jsonUpdate);
            jsonObject.remove((Object)"upd");
            change.withChangeMsg(jsonObject.toString());
        }
        this.getHistory().addChange(change);
        this.writeChange(change);
        this.sendNewChange(change);
        return true;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removeYou() {
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String value) {
        if (!StrUtil.stringEquals(this.spaceId, value)) {
            String oldValue = this.spaceId;
            this.spaceId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SPACEID, oldValue, value);
        }
    }

    public SeppelSpace withSpaceId(String value) {
        this.setSpaceId(value);
        return this;
    }

    public SeppelSpaceProxy getSelfProxy() {
        return this.selfProxy;
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(" ").append(this.getSpaceId());
        return result.substring(1);
    }

    public ChangeHistory getHistory() {
        if (this.history == null) {
            this.history = new ChangeHistory();
        }
        return this.history;
    }

    public void setHistory(ChangeHistory value) {
        if (this.history != value) {
            ChangeHistory oldValue = this.history;
            this.history = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HISTORY, oldValue, value);
        }
    }

    public SeppelSpace withHistory(ChangeHistory value) {
        this.setHistory(value);
        return this;
    }

    public long getLastChangeId() {
        return this.lastChangeId;
    }

    public void setLastChangeId(long value) {
        if (this.lastChangeId != value) {
            long oldValue = this.lastChangeId;
            this.lastChangeId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LASTCHANGEID, oldValue, value);
        }
    }

    public SeppelSpace withLastChangeId(long value) {
        this.setLastChangeId(value);
        return this;
    }

    public boolean isJavaFXApplication() {
        return this.javaFXApplication;
    }

    public void setJavaFXApplication(boolean value) {
        if (this.javaFXApplication != value) {
            boolean oldValue = this.javaFXApplication;
            this.javaFXApplication = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_JAVAFXAPPLICATION, oldValue, value);
        }
    }

    public SeppelSpace withJavaFXApplication(boolean value) {
        this.setJavaFXApplication(value);
        return this;
    }

    public JsonIdMap getMap() {
        return this.map;
    }

    public void setMap(JsonIdMap map) {
        this.map = map;
    }

    public void withMap(JsonIdMap map) {
        this.map = map;
        map.withUpdateListenerSend((UpdateListener)this);
    }

    public void put(String string, Object object) {
        this.getMap().put(string, object);
    }

    public Object get(String id) {
        return this.getMap().getObject(id);
    }

    public SeppelSpace init(JsonIdMap userModelIdMap, boolean javaFXApplication, String hostName, int portNo) {
        String userName = userModelIdMap.getCounter().getPrefixId();
        this.setName(userName + "Thread");
        this.withSpaceId(userName + "Space").withJavaFXApplication(javaFXApplication);
        this.withMap(userModelIdMap);
        userModelIdMap.withCreator((Iterable)SeppelSpaceCreator.createIdMap(null));
        this.selfProxy = new SeppelSpaceProxy().withSpaceId(this.getSpaceId()).withLoginName(userName).withHostName(hostName).withPortNo(portNo);
        this.put(this.selfProxy.getLoginName() + "Proxy", this.selfProxy);
        return this;
    }

    public boolean isApplyingChangeMsg() {
        return this.isApplyingChangeMsg;
    }

    public void setApplyingChangeMsg(boolean isApplyingChangeMsg) {
        this.isApplyingChangeMsg = isApplyingChangeMsg;
    }

    public long getNewHistoryIdNumber() {
        ++this.lastChangeId;
        return this.lastChangeId;
    }

    public long getNewHistoryIdNumber(int increment) {
        this.lastChangeId += (long)increment;
        return this.lastChangeId;
    }

    public void setLogFile(File logFile) {
        this.logFile = logFile;
        try {
            this.logFileWriter = new FileWriter(logFile, true);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public JsonIdMap getChangeMap() {
        if (this.changeMap == null) {
            this.changeMap = ReplicationNodeCreator.createIdMap(this.spaceId);
        }
        return this.changeMap;
    }

    private void writeChange(ReplicationChange change) {
        if (this.loadingHistory) {
            return;
        }
        try {
            if (this.logFile == null) {
                boolean result = new File("./SharedSpace/").mkdirs();
                this.logFile = new File("./SharedSpace/" + this.getSpaceId() + ".json");
                result = this.logFile.createNewFile();
            }
            this.logFileWriter = new FileWriter(this.logFile, true);
            JsonObject jsonObject = this.getChangeMap().toJsonObject((Object)change);
            this.logFileWriter.write(jsonObject.toString() + "\n");
            this.logFileWriter.flush();
            this.logFileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void loadHistoryFromFile() {
        File historyfile;
        File backupFile = new File("./SharedSpace/" + this.getSpaceId() + ".json.backup");
        if (backupFile.exists()) {
            backupFile.delete();
        }
        if ((historyfile = new File("./SharedSpace/" + this.getSpaceId() + ".json")).exists()) {
            historyfile.renameTo(backupFile);
            try {
                BufferedReader in = new BufferedReader(new FileReader(backupFile));
                String line = in.readLine();
                while (line != null) {
                    ChannelMsg msg = new ChannelMsg(null, line);
                    this.handleMessage(msg);
                    line = in.readLine();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHistoryFromFile(File file) {
        if (file.exists()) {
            try {
                this.loadingHistory = true;
                BufferedReader in = new BufferedReader(new FileReader(file));
                String line = in.readLine();
                while (line != null) {
                    ChannelMsg msg = new ChannelMsg(null, line);
                    this.handleMessage(msg);
                    line = in.readLine();
                }
                in.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.loadingHistory = false;
            }
        }
    }

    public void storeMyHistoryCompressed() {
        String loginName = this.logFile.getName();
        loginName = loginName.split("\\.")[0];
        File backupFile = new File(this.logFile.getAbsolutePath() + ".backup");
        try {
            Files.copy(this.logFile.toPath(), backupFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            new RandomAccessFile(this.logFile, "rw").setLength(0L);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        for (ReplicationChange change : this.getHistory().getChanges()) {
            if (!change.getHistoryIdPrefix().equals(loginName)) continue;
            this.writeChange(change);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadHistoryFromDir(File logDir) {
        if (logDir.exists() && logDir.isDirectory()) {
            ArrayList<ReplicationChange> changeList = new ArrayList<ReplicationChange>();
            for (File file : logDir.listFiles()) {
                String fileName = file.getName();
                if (!fileName.endsWith(".json")) continue;
                try {
                    BufferedReader in = new BufferedReader(new FileReader(file));
                    String line = in.readLine();
                    while (line != null) {
                        JsonObject jsonObject = new JsonObject().withValue(new String[]{line});
                        ReplicationChange change = (ReplicationChange)this.getChangeMap().decode(jsonObject);
                        change.setChangeMsg(EntityUtil.unQuote((String)change.getChangeMsg()));
                        changeList.add(change);
                        line = in.readLine();
                    }
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            Collections.sort(changeList);
            try {
                this.isApplyingChangeMsg = true;
                this.loadingHistory = true;
                for (ReplicationChange change : changeList) {
                    this.applyChangeLocally(change);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                this.isApplyingChangeMsg = false;
                this.loadingHistory = false;
            }
        }
    }

    public void setReadMessages(boolean readMessages) {
        this.readMessages = readMessages;
    }

    public boolean isReadMessages() {
        return this.readMessages;
    }

    private void sendNewChange(ReplicationChange change) {
        Iterator iterator = this.getSelfProxy().getPartners().getChannel().iterator();
        while (iterator.hasNext()) {
            SeppelChannel channel = (SeppelChannel)iterator.next();
            SeppelScopeSet scopes = channel.getSeppelSpaceProxy().getScopes();
            this.sendChangeToChannel(channel, scopes, change);
        }
    }

    public void sendAllChanges(SeppelChannel channel) {
        if (channel == null || channel.getSeppelSpaceProxy() == null) {
            return;
        }
        SeppelScopeSet scopes = channel.getSeppelSpaceProxy().getScopes();
        SeppelScope s = (SeppelScope)scopes.first();
        if (s == null) {
            return;
        }
        for (ReplicationChange change : this.getHistory().getChanges()) {
            this.sendChangeToChannel(channel, scopes, change);
        }
    }

    private void sendChangeToChannel(SeppelChannel channel, SeppelScopeSet scopes, ReplicationChange change) {
        String targetObjectId = change.getTargetObjectId();
        Object targetObject = this.get(targetObjectId);
        if (targetObject != null && (scopes.containsObservedObjects(targetObject) || channel.getSeppelSpaceProxy() == targetObject || this.selfProxy == targetObject || scopes.contains(targetObject))) {
            String changeMsg = change.getChangeMsg();
            JsonObject jsonObject = new JsonObject();
            jsonObject.withValue(new String[]{changeMsg});
            jsonObject = (JsonObject)jsonObject.get((Object)"upd");
            if (jsonObject == null) {
                jsonObject = new JsonObject();
                jsonObject.withValue(new String[]{changeMsg});
                jsonObject = (JsonObject)jsonObject.get((Object)"prop");
            }
            Object valueObject = null;
            if (jsonObject != null) {
                valueObject = jsonObject.get((Object)change.getTargetProperty());
            }
            if (valueObject != null && valueObject instanceof JsonObject) {
                JsonObject valueJsonObject = (JsonObject)valueObject;
                String valueObjectId = (String)valueJsonObject.get((Object)"id");
                if ((valueObject = this.get(valueObjectId)) != null && (scopes.containsObservedObjects(valueObject) || scopes.contains(valueObject) || channel.getSeppelSpaceProxy() == valueObject)) {
                    JsonIdMap cmap = this.getChangeMap();
                    JsonObject jsonChange = cmap.toJsonObject((Object)change);
                    String line = jsonChange.toString();
                    channel.send(line);
                }
            } else {
                JsonIdMap cmap = this.getChangeMap();
                JsonObject jsonChange = cmap.toJsonObject((Object)change);
                String line = jsonChange.toString();
                channel.send(line);
            }
        }
    }

    public SeppelSpaceProxy connectTo(String serverName, String hostName, int portNo, String loginName, String pwd, SeppelScope commonScope) {
        this.selfProxy.withLoginName(loginName).withPassword(pwd);
        SeppelSpaceProxy serverProxy = (SeppelSpaceProxy)this.selfProxy.getPartners().hasLoginName(serverName).first();
        if (serverProxy == null) {
            serverProxy = new SeppelSpaceProxy();
            this.put(serverName + "Proxy", serverProxy);
            serverProxy.withLoginName(serverName);
            this.selfProxy.withPartners(serverProxy);
        }
        serverProxy.withHostName(hostName).withPortNo(portNo);
        serverProxy.withScopes(commonScope);
        try {
            SeppelChannel channel = serverProxy.getOrCreateChannel();
            channel.setSeppelSpace(this);
            channel.start();
            channel.login();
            this.sendAllChanges(channel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return serverProxy;
    }

    public SeppelSpace withTaskHandler(SeppelTaskHandler handler) {
        this.taskHandler = handler;
        handler.withSeppelSpace(this);
        this.selfProxy.getPropertyChangeSupport().addPropertyChangeListener("tasks", handler);
        return this;
    }

    public static class RestrictToFilter
    extends ConditionMap {
        private ObjectSet explicitElems;

        public RestrictToFilter(ObjectSet explicitElems2) {
            this.explicitElems = explicitElems2;
        }

        public boolean check(ValuesMap values) {
            if (values.value != null) {
                if (values.deep >= 3) {
                    return false;
                }
                if ("Integer Float Double Long Boolean String".indexOf(values.value.getClass().getSimpleName()) >= 0) {
                    return true;
                }
            }
            return this.explicitElems.contains(values.value);
        }
    }

    public class ChannelMsg {
        public SeppelChannel channel;
        public String msg;

        public ChannelMsg(SeppelChannel channel, String msg) {
            this.channel = channel;
            this.msg = msg;
        }
    }
}

