/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.sdmlib.replication.SeppelChannel;
import org.sdmlib.replication.SeppelSpace;
import org.sdmlib.serialization.PropertyChangeInterface;

public class SeppelSocketAcceptThread
extends Thread
implements PropertyChangeInterface {
    public int port;
    private SeppelSpace seppelSpace;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_PORT = "port";

    public SeppelSocketAcceptThread() {
    }

    public SeppelSocketAcceptThread(SeppelSpace seppelSpace, int port) {
        this.seppelSpace = seppelSpace;
        this.port = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.setName("SocketAcceptThread");
        ServerSocket serverSocket = null;
        try {
            try {
                serverSocket = new ServerSocket(this.port);
                int i = 1;
                while (true) {
                    Socket connection = serverSocket.accept();
                    SeppelChannel channel = new SeppelChannel(connection, this.seppelSpace);
                    channel.setName("SeppelChannel" + i++);
                    channel.start();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                if (serverSocket != null) {
                    try {
                        serverSocket.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }
        }
        catch (Throwable throwable) {
            if (serverSocket != null) {
                try {
                    serverSocket.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            throw throwable;
        }
    }

    public Object get(String attrName) {
        if (PROPERTY_PORT.equalsIgnoreCase(attrName)) {
            return this.getPort();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_PORT.equalsIgnoreCase(attrName)) {
            this.setPort(Integer.parseInt(value.toString()));
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        if (this.port != value) {
            int oldValue = this.port;
            this.port = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PORT, oldValue, value);
        }
    }

    public SeppelSocketAcceptThread withPort(int value) {
        this.setPort(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getPort());
        return s.substring(1);
    }
}

