/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import de.uniks.networkparser.json.JsonObject;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.concurrent.LinkedBlockingQueue;
import org.sdmlib.replication.SeppelSpace;
import org.sdmlib.replication.SeppelSpaceProxy;
import org.sdmlib.serialization.PropertyChangeInterface;

public class SeppelChannel
extends Thread
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private SeppelSpace seppelSpace;
    private SeppelSpaceProxy selfProxy;
    private LinkedBlockingQueue<String> msgQueue = new LinkedBlockingQueue();
    public static final String PROPERTY_SOCKET = "socket";
    private Socket socket;
    private OutputStreamWriter out;
    public static final String PROPERTY_LOGINVALIDATED = "loginValidated";
    private boolean loginValidated;
    public static final String PROPERTY_SEPPELSPACEPROXY = "seppelSpaceProxy";
    private SeppelSpaceProxy seppelSpaceProxy = null;

    @Override
    public void run() {
        try {
            InputStream byteIn = this.socket.getInputStream();
            InputStreamReader readerIn = new InputStreamReader(byteIn);
            BufferedReader in = new BufferedReader(readerIn);
            String line = "";
            while (line != null) {
                line = in.readLine();
                if (!this.isLoginValidated()) {
                    JsonObject jsonObject = new JsonObject().withValue(new String[]{line});
                    String spaceId = jsonObject.getString((Object)"spaceId");
                    String login = jsonObject.getString((Object)"login");
                    String pwd = jsonObject.getString((Object)"pwd");
                    this.setName(spaceId + "Channel");
                    this.seppelSpace.enqueueMsg(this, line);
                    String msg = this.msgQueue.take();
                    if (this.isLoginValidated()) continue;
                    this.removeYou();
                    return;
                }
                this.seppelSpace.enqueueMsg(this, line);
            }
        }
        catch (Exception e) {
            System.out.println("Socket has been closed");
            this.removeYou();
        }
    }

    public void send(String line) {
        if (!this.isLoginValidated()) {
            return;
        }
        if (!line.endsWith("\n")) {
            line = line + "\n";
        }
        try {
            if (this.out == null) {
                this.out = new OutputStreamWriter(this.socket.getOutputStream());
            }
            this.out.write(line);
            this.out.flush();
        }
        catch (Exception e) {
            this.removeYou();
        }
    }

    public void login() {
        try {
            this.setLoginValidated(true);
            SeppelSpaceProxy myProxy = this.getSeppelSpaceProxy();
            String hostName = myProxy.getHostName();
            int portNo = myProxy.getPortNo();
            SeppelSpaceProxy selfProxy = (SeppelSpaceProxy)myProxy.getPartners().first();
            JsonObject jsonObject = new JsonObject();
            jsonObject.put((Object)"spaceId", (Object)selfProxy.getSpaceId());
            jsonObject.put((Object)"login", (Object)selfProxy.getLoginName());
            jsonObject.put((Object)"pwd", (Object)selfProxy.getPassword());
            this.send(jsonObject.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSeppelSpace(SeppelSpace seppelSpace) {
        this.seppelSpace = seppelSpace;
    }

    public SeppelChannel(Socket connection, SeppelSpace seppelSpace) {
        this.socket = connection;
        this.seppelSpace = seppelSpace;
        this.selfProxy = seppelSpace.getSelfProxy();
    }

    public SeppelChannel(String host, int port) {
        try {
            this.socket = new Socket(host, port);
        }
        catch (Exception e) {
            this.socket = null;
        }
    }

    public SeppelChannel() {
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removeYou() {
        if (this.socket != null) {
            try {
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.setSeppelSpaceProxy(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public LinkedBlockingQueue<String> getMsgQueue() {
        return this.msgQueue;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket value) {
        if (this.socket != value) {
            Socket oldValue = this.socket;
            this.socket = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SOCKET, oldValue, value);
        }
    }

    public SeppelChannel withSocket(Socket value) {
        this.setSocket(value);
        return this;
    }

    public boolean isLoginValidated() {
        return this.loginValidated;
    }

    public void setLoginValidated(boolean value) {
        if (this.loginValidated != value) {
            boolean oldValue = this.loginValidated;
            this.loginValidated = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LOGINVALIDATED, oldValue, value);
        }
    }

    public SeppelChannel withLoginValidated(boolean value) {
        this.setLoginValidated(value);
        return this;
    }

    public SeppelSpaceProxy getSeppelSpaceProxy() {
        return this.seppelSpaceProxy;
    }

    public boolean setSeppelSpaceProxy(SeppelSpaceProxy value) {
        boolean changed = false;
        if (this.seppelSpaceProxy != value) {
            SeppelSpaceProxy oldValue = this.seppelSpaceProxy;
            if (this.seppelSpaceProxy != null) {
                this.seppelSpaceProxy = null;
                oldValue.setChannel(null);
            }
            this.seppelSpaceProxy = value;
            if (value != null) {
                value.withChannel(this);
            }
            changed = true;
        }
        return changed;
    }

    public SeppelChannel withSeppelSpaceProxy(SeppelSpaceProxy value) {
        this.setSeppelSpaceProxy(value);
        return this;
    }

    public SeppelSpaceProxy createSeppelSpaceProxy() {
        SeppelSpaceProxy value = new SeppelSpaceProxy();
        this.withSeppelSpaceProxy(value);
        return value;
    }

    @Override
    public String toString() {
        if (this.seppelSpaceProxy != null) {
            return "channel to " + this.seppelSpaceProxy.getLoginName();
        }
        return super.toString();
    }
}

