/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonIdMap;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.StrUtil;
import org.sdmlib.replication.ChangeHistory;
import org.sdmlib.replication.RemoteTaskBoard;
import org.sdmlib.replication.ReplicationRoot;
import org.sdmlib.replication.SharedSpace;
import org.sdmlib.replication.util.ReplicationNodeCreator;
import org.sdmlib.replication.util.SharedSpaceSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ReplicationNode
extends Thread
implements PropertyChangeInterface {
    private Collection<SendableEntityCreator> modelCreators = new LinkedHashSet<SendableEntityCreator>();
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_SHAREDSPACES = "sharedSpaces";
    private SharedSpaceSet sharedSpaces = null;
    private PropertyChangeListener remoteTaskListener;
    public static final String PROPERTY_SPACEID = "spaceId";
    private String spaceId;
    public static final String PROPERTY_HISTORY = "history";
    private ChangeHistory history;
    public static final String PROPERTY_LASTCHANGEID = "lastChangeId";
    private long lastChangeId;
    public static final String PROPERTY_NODEID = "nodeId";
    private String nodeId;
    public static final String PROPERTY_JAVAFXAPPLICATION = "javaFXApplication";
    private boolean javaFXApplication;

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.removeAllFromSharedSpaces();
        this.withoutSharedSpaces((SharedSpace[])this.getSharedSpaces().toArray(new SharedSpace[this.getSharedSpaces().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public synchronized SharedSpace getOrCreateSharedSpace(String spaceId) {
        SharedSpace sharedSpace = (SharedSpace)this.getSharedSpaces().hasSpaceId(spaceId).first();
        if (sharedSpace == null) {
            sharedSpace = new SharedSpace().withSpaceId(spaceId);
            this.addToSharedSpaces(sharedSpace);
            sharedSpace.setName("SharedSpace" + this.getSharedSpaces().size());
            JsonIdMap map = ReplicationNodeCreator.createIdMap("s42");
            map.withCreator(this.modelCreators);
            sharedSpace.withMap(map);
            ChangeHistory history = new ChangeHistory();
            sharedSpace.setHistory(history);
            ReplicationRoot replicationRoot = new ReplicationRoot();
            sharedSpace.setReplicationRoot(replicationRoot);
            map.put("replicationRoot", (Object)replicationRoot);
            RemoteTaskBoard remoteTaskBoard = new RemoteTaskBoard();
            sharedSpace.setRemoteTaskBoard(remoteTaskBoard);
            map.put("taskFlowBoardRoot", (Object)remoteTaskBoard);
            if (this.remoteTaskListener != null) {
                replicationRoot.addPropertyChangeListener(this.remoteTaskListener);
                remoteTaskBoard.getPropertyChangeSupport().addPropertyChangeListener(this.remoteTaskListener);
                this.remoteTaskListener.propertyChange(new PropertyChangeEvent(sharedSpace, "NEW", null, remoteTaskBoard));
            }
            sharedSpace.start();
        }
        return sharedSpace;
    }

    public SharedSpaceSet getSharedSpaces() {
        if (this.sharedSpaces == null) {
            return SharedSpace.EMPTY_SET;
        }
        return this.sharedSpaces;
    }

    public boolean addToSharedSpaces(SharedSpace value) {
        SharedSpace oldContent = null;
        if (value != null) {
            if (this.sharedSpaces == null) {
                this.sharedSpaces = new SharedSpaceSet();
            }
            oldContent = (SharedSpace)this.getSharedSpaces().hasSpaceId(value.getSpaceId()).first();
            this.sharedSpaces.add(value);
            if (oldContent != value) {
                value.withNode(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SHAREDSPACES, null, value);
            }
        }
        return oldContent != value;
    }

    public boolean removeFromSharedSpaces(SharedSpace value) {
        boolean flag = false;
        if (this.sharedSpaces != null && value != null && (flag = this.sharedSpaces.remove(value))) {
            value.setNode(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SHAREDSPACES, value, null);
        }
        return flag;
    }

    public ReplicationNode withSharedSpaces(SharedSpace value) {
        this.addToSharedSpaces(value);
        return this;
    }

    public ReplicationNode withoutSharedSpaces(SharedSpace value) {
        this.removeFromSharedSpaces(value);
        return this;
    }

    public void removeAllFromSharedSpaces() {
        SharedSpaceSet tmpSet = new SharedSpaceSet().with(this.getSharedSpaces());
        Iterator iterator = tmpSet.iterator();
        while (iterator.hasNext()) {
            SharedSpace value = (SharedSpace)iterator.next();
            this.removeFromSharedSpaces(value);
        }
    }

    public SharedSpace createSharedSpaces() {
        SharedSpace value = new SharedSpace();
        this.withSharedSpaces(value);
        return value;
    }

    public ReplicationNode withSharedSpaces(SharedSpace ... value) {
        for (SharedSpace item : value) {
            this.addToSharedSpaces(item);
        }
        return this;
    }

    public ReplicationNode withoutSharedSpaces(SharedSpace ... value) {
        for (SharedSpace item : value) {
            this.removeFromSharedSpaces(item);
        }
        return this;
    }

    public ReplicationNode withRemoteTaskListener(PropertyChangeListener remoteTaskListener) {
        this.remoteTaskListener = remoteTaskListener;
        return this;
    }

    public String getSpaceId() {
        return this.spaceId;
    }

    public void setSpaceId(String value) {
        if (!StrUtil.stringEquals(this.spaceId, value)) {
            String oldValue = this.spaceId;
            this.spaceId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SPACEID, oldValue, value);
        }
    }

    public ReplicationNode withSpaceId(String value) {
        this.setSpaceId(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getSpaceId());
        s.append(" ").append(this.getNodeId());
        return s.substring(1);
    }

    public ChangeHistory getHistory() {
        return this.history;
    }

    public void setHistory(ChangeHistory value) {
        if (this.history != value) {
            ChangeHistory oldValue = this.history;
            this.history = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HISTORY, oldValue, value);
        }
    }

    public ReplicationNode withHistory(ChangeHistory value) {
        this.setHistory(value);
        return this;
    }

    public long getLastChangeId() {
        return this.lastChangeId;
    }

    public void setLastChangeId(long value) {
        if (this.lastChangeId != value) {
            long oldValue = this.lastChangeId;
            this.lastChangeId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LASTCHANGEID, oldValue, value);
        }
    }

    public ReplicationNode withLastChangeId(long value) {
        this.setLastChangeId(value);
        return this;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public void setNodeId(String value) {
        if (!StrUtil.stringEquals(this.nodeId, value)) {
            String oldValue = this.nodeId;
            this.nodeId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NODEID, oldValue, value);
        }
    }

    public ReplicationNode withNodeId(String value) {
        this.setNodeId(value);
        return this;
    }

    public boolean isJavaFXApplication() {
        return this.javaFXApplication;
    }

    public void setJavaFXApplication(boolean value) {
        if (this.javaFXApplication != value) {
            boolean oldValue = this.javaFXApplication;
            this.javaFXApplication = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_JAVAFXAPPLICATION, oldValue, value);
        }
    }

    public ReplicationNode withJavaFXApplication(boolean value) {
        this.setJavaFXApplication(value);
        return this;
    }

    public Collection<SendableEntityCreator> getModelCreators() {
        return this.modelCreators;
    }
}

