/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import de.uniks.networkparser.json.JsonObject;
import java.beans.PropertyChangeSupport;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import org.sdmlib.StrUtil;
import org.sdmlib.replication.ReplicationChange;
import org.sdmlib.replication.ReplicationNode;
import org.sdmlib.replication.SharedSpace;
import org.sdmlib.replication.util.ReplicationChannelSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ReplicationChannel
extends Thread
implements PropertyChangeInterface {
    private ReplicationNode replicationNode;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final ReplicationChannelSet EMPTY_SET = new ReplicationChannelSet();
    public static final String PROPERTY_SHAREDSPACE = "sharedSpace";
    private SharedSpace sharedSpace = null;
    public static final String PROPERTY_SOCKET = "socket";
    private Socket socket;
    private OutputStreamWriter out;
    public static final String PROPERTY_TARGETNODEID = "targetNodeId";
    private String targetNodeId;

    @Override
    public void run() {
        try {
            InputStream byteIn = this.socket.getInputStream();
            InputStreamReader readerIn = new InputStreamReader(byteIn);
            BufferedReader in = new BufferedReader(readerIn);
            String line = "";
            while (line != null) {
                line = in.readLine();
                if (this.sharedSpace == null) {
                    JsonObject jsonObject = new JsonObject().withValue(new String[]{line});
                    Object object = jsonObject.get((Object)"spaceId");
                    if (object == null || !(object instanceof String)) continue;
                    String spaceId = (String)object;
                    SharedSpace matchingSharedSpace = this.replicationNode.getOrCreateSharedSpace(spaceId);
                    this.setSharedSpace(matchingSharedSpace);
                    this.sharedSpace.enqueueMsg(this, line);
                    continue;
                }
                if (line.startsWith("hello from")) {
                    String senderNodeId = line.split(" ")[2];
                    this.setTargetNodeId(senderNodeId);
                    for (ReplicationChange change : this.sharedSpace.getHistory().getChanges()) {
                        this.send(this.sharedSpace.getChangeMap().encode((Object)change).toString());
                    }
                    continue;
                }
                if (line.startsWith("mouse")) {
                    String[] data = line.split(" ");
                    this.sharedSpace.setMousePositionAndWindowIdForUser(data[1], Double.parseDouble(data[2]), Double.parseDouble(data[3]), data[4]);
                    continue;
                }
                this.sharedSpace.enqueueMsg(this, line);
            }
        }
        catch (Exception e) {
            System.out.println("Socket has been closed");
            this.removeYou();
        }
    }

    public void send(String line) {
        if (!line.endsWith("\n")) {
            line = line + "\n";
        }
        try {
            if (this.out == null) {
                this.out = new OutputStreamWriter(this.socket.getOutputStream());
            }
            this.out.write(line);
            this.out.flush();
        }
        catch (Exception e) {
            this.removeYou();
        }
    }

    public ReplicationChannel(ReplicationNode replicationNode, Socket connection) {
        this.replicationNode = replicationNode;
        this.setSocket(connection);
    }

    public ReplicationChannel() {
    }

    public Object get(String attrName) {
        if (PROPERTY_SHAREDSPACE.equalsIgnoreCase(attrName)) {
            return this.getSharedSpace();
        }
        if (PROPERTY_SOCKET.equalsIgnoreCase(attrName)) {
            return this.getSocket();
        }
        if (PROPERTY_TARGETNODEID.equalsIgnoreCase(attrName)) {
            return this.getTargetNodeId();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_SHAREDSPACE.equalsIgnoreCase(attrName)) {
            this.setSharedSpace((SharedSpace)value);
            return true;
        }
        if (PROPERTY_SOCKET.equalsIgnoreCase(attrName)) {
            this.setSocket((Socket)value);
            return true;
        }
        if (PROPERTY_TARGETNODEID.equalsIgnoreCase(attrName)) {
            this.setTargetNodeId((String)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.setSharedSpace(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public SharedSpace getSharedSpace() {
        return this.sharedSpace;
    }

    public boolean setSharedSpace(SharedSpace value) {
        boolean changed = false;
        if (this.sharedSpace != value) {
            SharedSpace oldValue = this.sharedSpace;
            if (this.sharedSpace != null) {
                this.sharedSpace = null;
                oldValue.withoutChannels(this);
            }
            this.sharedSpace = value;
            if (value != null) {
                value.withChannels(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SHAREDSPACE, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public ReplicationChannel withSharedSpace(SharedSpace value) {
        this.setSharedSpace(value);
        return this;
    }

    public SharedSpace createSharedSpace() {
        SharedSpace value = new SharedSpace();
        this.withSharedSpace(value);
        return value;
    }

    public Socket getSocket() {
        return this.socket;
    }

    public void setSocket(Socket value) {
        if (this.socket != value) {
            Socket oldValue = this.socket;
            this.socket = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SOCKET, oldValue, value);
        }
    }

    public ReplicationChannel withSocket(Socket value) {
        this.setSocket(value);
        return this;
    }

    public ReplicationChannel withConnect(String ip, int port) {
        if (this.socket == null || !this.socket.isConnected()) {
            try {
                this.socket = new Socket(ip, port);
                this.out = new OutputStreamWriter(this.socket.getOutputStream());
            }
            catch (Exception e) {
                this.removeYou();
            }
        }
        return this;
    }

    public void sendSpaceConnectionRequest(String spaceId) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put((Object)"spaceId", (Object)spaceId);
        String line = jsonObject.toString() + "\n";
        this.send(line);
    }

    public String getTargetNodeId() {
        return this.targetNodeId;
    }

    public void setTargetNodeId(String value) {
        if (!StrUtil.stringEquals(this.targetNodeId, value)) {
            String oldValue = this.targetNodeId;
            this.targetNodeId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TARGETNODEID, oldValue, value);
        }
    }

    public ReplicationChannel withTargetNodeId(String value) {
        this.setTargetNodeId(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTargetNodeId());
        return s.substring(1);
    }

    public void loadHistory() {
        JsonObject jsonObject = new JsonObject();
        jsonObject.put((Object)"resendIdHistoryNumber", (Object)0);
        jsonObject.put((Object)"resendIdHistoryPrefix", (Object)"");
        String line = jsonObject.toString();
        this.send(line);
    }
}

