/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import de.uniks.networkparser.json.JsonObject;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import org.sdmlib.StrUtil;
import org.sdmlib.replication.ChangeHistory;
import org.sdmlib.replication.LogEntry;
import org.sdmlib.replication.Task;
import org.sdmlib.replication.util.ReplicationChangeSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ReplicationChange
extends Task
implements PropertyChangeInterface,
Comparable<ReplicationChange> {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_TARGETOBJECTID = "targetObjectId";
    private String targetObjectId;
    public static final String PROPERTY_TARGETPROPERTY = "targetProperty";
    private String targetProperty;
    public static final String PROPERTY_CHANGEMSG = "changeMsg";
    private String changeMsg = "{}";
    public static final ReplicationChangeSet EMPTY_SET = new ReplicationChangeSet();
    public static final String PROPERTY_HISTORY = "history";
    private ChangeHistory history = null;
    public static final String PROPERTY_ISTOMANYPROPERTY = "isToManyProperty";
    private boolean isToManyProperty = false;
    public static final String PROPERTY_HISTORYIDPREFIX = "historyIdPrefix";
    private String historyIdPrefix = "42";
    public static final String PROPERTY_HISTORYIDNUMBER = "historyIdNumber";
    private long historyIdNumber;

    @Override
    public Object get(String attrName) {
        if (PROPERTY_TARGETOBJECTID.equalsIgnoreCase(attrName)) {
            return this.getTargetObjectId();
        }
        if (PROPERTY_TARGETPROPERTY.equalsIgnoreCase(attrName)) {
            return this.getTargetProperty();
        }
        if (PROPERTY_CHANGEMSG.equalsIgnoreCase(attrName)) {
            return this.getChangeMsg();
        }
        if (PROPERTY_HISTORY.equalsIgnoreCase(attrName)) {
            return this.getHistory();
        }
        if (PROPERTY_ISTOMANYPROPERTY.equalsIgnoreCase(attrName)) {
            return this.getIsToManyProperty();
        }
        if (PROPERTY_HISTORYIDPREFIX.equalsIgnoreCase(attrName)) {
            return this.getHistoryIdPrefix();
        }
        if (PROPERTY_HISTORYIDNUMBER.equalsIgnoreCase(attrName)) {
            return this.getHistoryIdNumber();
        }
        if ("logEntries".equalsIgnoreCase(attrName)) {
            return this.getLogEntries();
        }
        return null;
    }

    @Override
    public boolean set(String attrName, Object value) {
        if (PROPERTY_TARGETOBJECTID.equalsIgnoreCase(attrName)) {
            this.setTargetObjectId((String)value);
            return true;
        }
        if (PROPERTY_TARGETPROPERTY.equalsIgnoreCase(attrName)) {
            this.setTargetProperty((String)value);
            return true;
        }
        if (PROPERTY_CHANGEMSG.equalsIgnoreCase(attrName)) {
            this.setChangeMsg((String)value);
            return true;
        }
        if (PROPERTY_HISTORY.equalsIgnoreCase(attrName)) {
            this.setHistory((ChangeHistory)value);
            return true;
        }
        if (PROPERTY_ISTOMANYPROPERTY.equalsIgnoreCase(attrName)) {
            this.setIsToManyProperty((Boolean)value);
            return true;
        }
        if (PROPERTY_HISTORYIDPREFIX.equalsIgnoreCase(attrName)) {
            this.setHistoryIdPrefix((String)value);
            return true;
        }
        if (PROPERTY_HISTORYIDNUMBER.equalsIgnoreCase(attrName)) {
            this.setHistoryIdNumber(Long.parseLong(value.toString()));
            return true;
        }
        if ("logEntries".equalsIgnoreCase(attrName)) {
            this.addToLogEntries((LogEntry)value);
            return true;
        }
        if ("logEntriesrem".equalsIgnoreCase(attrName)) {
            this.removeFromLogEntries((LogEntry)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    @Override
    public void removeYou() {
        this.setHistory(null);
        this.removeAllFromLogEntries();
        this.withoutLogEntries((LogEntry[])this.getLogEntries().toArray(new LogEntry[this.getLogEntries().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String toString() {
        String changeMsg = new JsonObject().withValue(new String[]{this.getChangeMsg()}).toString(3);
        StringBuilder buf = new StringBuilder();
        buf.append(" ").append(this.getHistoryIdPrefix());
        buf.append(" ").append(this.getHistoryIdNumber());
        buf.append(" ").append(this.getTargetObjectId());
        buf.append(" ").append(this.getTargetProperty());
        buf.append("\n").append(changeMsg);
        Iterator iterator = this.getLogEntries().iterator();
        while (iterator.hasNext()) {
            LogEntry entry = (LogEntry)iterator.next();
            buf.append("\n").append(entry);
        }
        return buf.substring(1);
    }

    public String getTargetObjectId() {
        return this.targetObjectId;
    }

    public void setTargetObjectId(String value) {
        if (!StrUtil.stringEquals(this.targetObjectId, value)) {
            String oldValue = this.targetObjectId;
            this.targetObjectId = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TARGETOBJECTID, oldValue, value);
        }
    }

    public ReplicationChange withTargetObjectId(String value) {
        this.setTargetObjectId(value);
        return this;
    }

    public String getTargetProperty() {
        return this.targetProperty;
    }

    public void setTargetProperty(String value) {
        if (!StrUtil.stringEquals(this.targetProperty, value)) {
            String oldValue = this.targetProperty;
            this.targetProperty = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TARGETPROPERTY, oldValue, value);
        }
    }

    public ReplicationChange withTargetProperty(String value) {
        this.setTargetProperty(value);
        return this;
    }

    public String getChangeMsg() {
        return this.changeMsg;
    }

    public void setChangeMsg(String value) {
        if (!StrUtil.stringEquals(this.changeMsg, value)) {
            String oldValue = this.changeMsg;
            this.changeMsg = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHANGEMSG, oldValue, value);
        }
    }

    public ReplicationChange withChangeMsg(String value) {
        this.setChangeMsg(value);
        return this;
    }

    public ChangeHistory getHistory() {
        return this.history;
    }

    public boolean setHistory(ChangeHistory value) {
        boolean changed = false;
        if (this.history != value) {
            ChangeHistory oldValue = this.history;
            if (this.history != null) {
                this.history = null;
                oldValue.withoutChanges(this);
            }
            this.history = value;
            if (value != null) {
                value.withChanges(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HISTORY, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public ReplicationChange withHistory(ChangeHistory value) {
        this.setHistory(value);
        return this;
    }

    public ChangeHistory createHistory() {
        ChangeHistory value = new ChangeHistory();
        this.withHistory(value);
        return value;
    }

    @Override
    public int compareTo(ReplicationChange o) {
        if (this.getHistoryIdNumber() < o.getHistoryIdNumber()) {
            return -1;
        }
        if (this.getHistoryIdNumber() > o.getHistoryIdNumber()) {
            return 1;
        }
        return this.getHistoryIdPrefix().compareTo(o.getHistoryIdPrefix());
    }

    public boolean getIsToManyProperty() {
        return this.isToManyProperty;
    }

    public void setIsToManyProperty(boolean value) {
        if (this.isToManyProperty != value) {
            boolean oldValue = this.isToManyProperty;
            this.isToManyProperty = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ISTOMANYPROPERTY, oldValue, value);
        }
    }

    public ReplicationChange withIsToManyProperty(boolean value) {
        this.setIsToManyProperty(value);
        return this;
    }

    public String getHistoryIdPrefix() {
        return this.historyIdPrefix;
    }

    public void setHistoryIdPrefix(String value) {
        if (!StrUtil.stringEquals(this.historyIdPrefix, value)) {
            String oldValue = this.historyIdPrefix;
            this.historyIdPrefix = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HISTORYIDPREFIX, oldValue, value);
        }
    }

    public ReplicationChange withHistoryIdPrefix(String value) {
        this.setHistoryIdPrefix(value);
        return this;
    }

    public long getHistoryIdNumber() {
        return this.historyIdNumber;
    }

    public void setHistoryIdNumber(long value) {
        if (this.historyIdNumber != value) {
            long oldValue = this.historyIdNumber;
            this.historyIdNumber = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HISTORYIDNUMBER, oldValue, value);
        }
    }

    public ReplicationChange withHistoryIdNumber(long value) {
        this.setHistoryIdNumber(value);
        return this;
    }

    public void withLog(String string, String name) {
        this.createLogEntries().withStepName(string).withExecutedBy(name).withTimeStamp(System.currentTimeMillis());
    }
}

