/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.sdmlib.replication.BoardTask;
import org.sdmlib.replication.Lane;
import org.sdmlib.replication.RemoteTask;
import org.sdmlib.replication.RemoteTaskBoard;
import org.sdmlib.replication.SharedSpace;

public abstract class RemoteTaskListener
implements PropertyChangeListener {
    public static final String NEW = "NEW";
    private SharedSpace sharedSpace;
    private RemoteTaskBoard remoteTaskBoard;
    private HashMap<String, RemoteTask> tasks = new HashMap();
    private Lane lane;
    private boolean isInit;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isInit) {
            this.isInit = this.init(evt);
            if (!this.isInit) throw new RuntimeException("Initialization failure!");
            this.handleEvent(evt);
            return;
        } else {
            this.handleEvent(evt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void handleEvent(PropertyChangeEvent evt) {
        boolean oldIsApplyingChangeFlag = this.getSharedSpace().isApplyingChangeMsg();
        this.getSharedSpace().setApplyingChangeMsg(false);
        try {
            String propertyName;
            switch (propertyName = evt.getPropertyName()) {
                case "applicationObject": {
                    this.handleReplicationRootChange(evt);
                    return;
                }
                case "NEW": {
                    this.createLane();
                    return;
                }
                case "tasks": {
                    this.handleTasks(evt);
                    return;
                }
            }
            return;
        }
        finally {
            this.getSharedSpace().setApplyingChangeMsg(oldIsApplyingChangeFlag);
        }
    }

    protected void handleTasks(PropertyChangeEvent evt) {
        if (evt.getNewValue() != null) {
            BoardTask task = (BoardTask)evt.getNewValue();
            this.runTask(task);
        }
    }

    public RemoteTaskListener withTask(String name, RemoteTask task) {
        this.tasks.put(name, task);
        return this;
    }

    public void runTask(BoardTask boardTask) {
        RemoteTask task = this.tasks.get(boardTask.getName());
        if (task == null) {
            throw new RuntimeException("No such task: " + boardTask.getName() + " on " + this.getName());
        }
        task.withBoardTask(boardTask);
        task.run();
    }

    public SharedSpace getSharedSpace() {
        return this.sharedSpace;
    }

    protected abstract void createLane();

    protected abstract boolean init(PropertyChangeEvent var1);

    protected abstract void handleReplicationRootChange(PropertyChangeEvent var1);

    protected abstract String getName();

    public RemoteTaskBoard getRemoteTaskBoard() {
        return this.remoteTaskBoard;
    }

    public void setRemoteTaskBoard(RemoteTaskBoard remoteTaskBoard) {
        this.remoteTaskBoard = remoteTaskBoard;
    }

    public Lane getLane() {
        return this.lane;
    }

    public void setLane(Lane lane) {
        this.lane = lane;
    }

    protected void setSharedSpace(SharedSpace sharedSpace) {
        this.sharedSpace = sharedSpace;
    }
}

