/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.replication.BoardTask;
import org.sdmlib.replication.Lane;
import org.sdmlib.replication.util.LaneSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class RemoteTaskBoard
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_LANES = "lanes";
    private LaneSet lanes = null;

    public Object get(String attrName) {
        if (PROPERTY_LANES.equalsIgnoreCase(attrName)) {
            return this.getLanes();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_LANES.equalsIgnoreCase(attrName)) {
            this.addToLanes((Lane)value);
            return true;
        }
        if ("lanesrem".equalsIgnoreCase(attrName)) {
            this.removeFromLanes((Lane)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.removeAllFromLanes();
        this.withoutLanes((Lane[])this.getLanes().toArray(new Lane[this.getLanes().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public LaneSet getLanes() {
        if (this.lanes == null) {
            return Lane.EMPTY_SET;
        }
        return this.lanes;
    }

    public boolean addToLanes(Lane value) {
        boolean changed = false;
        if (value != null) {
            if (this.lanes == null) {
                this.lanes = new LaneSet();
            }
            if (changed = this.lanes.add(value)) {
                value.withBoard(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LANES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromLanes(Lane value) {
        boolean changed = false;
        if (this.lanes != null && value != null && (changed = this.lanes.remove(value))) {
            value.setBoard(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LANES, value, null);
        }
        return changed;
    }

    public RemoteTaskBoard withLanes(Lane value) {
        this.addToLanes(value);
        return this;
    }

    public RemoteTaskBoard withoutLanes(Lane value) {
        this.removeFromLanes(value);
        return this;
    }

    public void removeAllFromLanes() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getLanes());
        for (Lane value : tmpSet) {
            this.removeFromLanes(value);
        }
    }

    public Lane createLanes() {
        Lane value = new Lane();
        this.withLanes(value);
        return value;
    }

    public Lane getLanes(String name) {
        Iterator iterator = this.getLanes().iterator();
        while (iterator.hasNext()) {
            Lane l = (Lane)iterator.next();
            if (!name.equals(l.getName())) continue;
            return l;
        }
        return null;
    }

    public BoardTask createTask(String laneName, String taskName) {
        Lane lane = this.getLanes(laneName);
        return lane.createTask(taskName);
    }

    public void startTask(String laneName, String taskName) {
        Lane lane = this.getLanes(laneName);
        lane.startTask(taskName);
    }

    public Lane createLanes(String name) {
        Lane lane = new Lane().withName(name);
        this.addToLanes(lane);
        return lane;
    }

    public RemoteTaskBoard withLanes(Lane ... value) {
        for (Lane item : value) {
            this.addToLanes(item);
        }
        return this;
    }

    public RemoteTaskBoard withoutLanes(Lane ... value) {
        for (Lane item : value) {
            this.removeFromLanes(item);
        }
        return this;
    }
}

