/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeSupport;
import java.util.LinkedHashSet;
import org.sdmlib.StrUtil;
import org.sdmlib.replication.BoardTask;
import org.sdmlib.replication.RemoteTaskBoard;
import org.sdmlib.replication.util.BoardTaskSet;
import org.sdmlib.replication.util.LaneSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class Lane
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_NAME = "name";
    private String name;
    public static final LaneSet EMPTY_SET = new LaneSet();
    public static final String PROPERTY_BOARD = "board";
    private RemoteTaskBoard board = null;
    public static final String PROPERTY_TASKS = "tasks";
    private BoardTaskSet tasks = null;

    public Object get(String attrName) {
        if (PROPERTY_NAME.equalsIgnoreCase(attrName)) {
            return this.getName();
        }
        if (PROPERTY_BOARD.equalsIgnoreCase(attrName)) {
            return this.getBoard();
        }
        if (PROPERTY_TASKS.equalsIgnoreCase(attrName)) {
            return this.getTasks();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_NAME.equalsIgnoreCase(attrName)) {
            this.setName((String)value);
            return true;
        }
        if (PROPERTY_BOARD.equalsIgnoreCase(attrName)) {
            this.setBoard((RemoteTaskBoard)value);
            return true;
        }
        if (PROPERTY_TASKS.equalsIgnoreCase(attrName)) {
            this.addToTasks((BoardTask)value);
            return true;
        }
        if ("tasksrem".equalsIgnoreCase(attrName)) {
            this.removeFromTasks((BoardTask)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.setBoard(null);
        this.removeAllFromTasks();
        this.withoutTasks((BoardTask[])this.getTasks().toArray(new BoardTask[this.getTasks().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (!StrUtil.stringEquals(this.name, value)) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    public Lane withName(String value) {
        this.setName(value);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getName());
        return s.substring(1);
    }

    public RemoteTaskBoard getBoard() {
        return this.board;
    }

    public boolean setBoard(RemoteTaskBoard value) {
        boolean changed = false;
        if (this.board != value) {
            RemoteTaskBoard oldValue = this.board;
            if (this.board != null) {
                this.board = null;
                oldValue.withoutLanes(this);
            }
            this.board = value;
            if (value != null) {
                value.withLanes(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_BOARD, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Lane withBoard(RemoteTaskBoard value) {
        this.setBoard(value);
        return this;
    }

    public RemoteTaskBoard createBoard() {
        RemoteTaskBoard value = new RemoteTaskBoard();
        this.withBoard(value);
        return value;
    }

    public BoardTaskSet getTasks() {
        if (this.tasks == null) {
            return BoardTask.EMPTY_SET;
        }
        return this.tasks;
    }

    public boolean addToTasks(BoardTask value) {
        boolean changed = false;
        if (value != null) {
            if (this.tasks == null) {
                this.tasks = new BoardTaskSet();
            }
            if (changed = this.tasks.add(value)) {
                value.withLane(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TASKS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromTasks(BoardTask value) {
        boolean changed = false;
        if (this.tasks != null && value != null && (changed = this.tasks.remove(value))) {
            value.setLane(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TASKS, value, null);
        }
        return changed;
    }

    public Lane withTasks(BoardTask value) {
        this.addToTasks(value);
        return this;
    }

    public Lane withoutTasks(BoardTask value) {
        this.removeFromTasks(value);
        return this;
    }

    public void removeAllFromTasks() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getTasks());
        for (BoardTask value : tmpSet) {
            this.removeFromTasks(value);
        }
    }

    public BoardTask createTasks() {
        BoardTask value = new BoardTask();
        this.withTasks(value);
        return value;
    }

    public BoardTask createTask(String taskName) {
        BoardTask task = new BoardTask().withName(taskName);
        this.addToTasks(task);
        return task;
    }

    public void startTask(String taskName) {
        BoardTask task = new BoardTask().withName(taskName);
        this.addToTasks(task);
        task.setStatus("start");
    }

    public Lane withTasks(BoardTask ... value) {
        for (BoardTask item : value) {
            this.addToTasks(item);
        }
        return this;
    }

    public Lane withoutTasks(BoardTask ... value) {
        for (BoardTask item : value) {
            this.removeFromTasks(item);
        }
        return this;
    }
}

