/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeSupport;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.sdmlib.replication.ReplicationChange;
import org.sdmlib.replication.util.ReplicationChangeSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ChangeHistory
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    private LinkedHashMap<String, Object> changeMap = new LinkedHashMap();
    public static final String PROPERTY_CHANGES = "changes";
    private ReplicationChangeSet changes = null;
    private LinkedHashMap<String, ReplicationChange> obsoleteChanges;

    public Object get(String attrName) {
        if (PROPERTY_CHANGES.equalsIgnoreCase(attrName)) {
            return this.getChanges();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_CHANGES.equalsIgnoreCase(attrName)) {
            this.addToChanges((ReplicationChange)value);
            return true;
        }
        if ("changesrem".equalsIgnoreCase(attrName)) {
            this.removeFromChanges((ReplicationChange)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.removeAllFromChanges();
        this.withoutChanges(this.getChanges().toArray(new ReplicationChange[this.getChanges().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public LinkedHashMap<String, Object> getChangeMap() {
        return this.changeMap;
    }

    public ReplicationChangeSet getChanges() {
        if (this.changes == null) {
            return ReplicationChange.EMPTY_SET;
        }
        return this.changes;
    }

    public boolean addToChanges(ReplicationChange value) {
        boolean changed = false;
        if (value != null) {
            if (this.changes == null) {
                this.changes = new ReplicationChangeSet();
            }
            if (changed = this.changes.add(value)) {
                value.withHistory(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHANGES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromChanges(ReplicationChange value) {
        boolean changed = false;
        if (this.changes != null && value != null && (changed = this.changes.remove(value))) {
            value.setHistory(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHANGES, value, null);
        }
        return changed;
    }

    public ChangeHistory withChanges(ReplicationChange value) {
        this.addToChanges(value);
        return this;
    }

    public ChangeHistory withoutChanges(ReplicationChange value) {
        this.removeFromChanges(value);
        return this;
    }

    public void removeAllFromChanges() {
        LinkedHashSet<ReplicationChange> tmpSet = new LinkedHashSet<ReplicationChange>(this.getChanges());
        for (ReplicationChange value : tmpSet) {
            this.removeFromChanges(value);
        }
    }

    public ReplicationChange createChanges() {
        ReplicationChange value = new ReplicationChange();
        this.withChanges(value);
        return value;
    }

    public void addChange(ReplicationChange change) {
        ReplicationChange obsoleteChange;
        this.addToChanges(change);
        if (this.obsoleteChanges == null) {
            this.obsoleteChanges = new LinkedHashMap();
        }
        if ((obsoleteChange = this.obsoleteChanges.get(change.getHistoryIdPrefix())) != null) {
            this.obsoleteChanges.remove(change.getHistoryIdPrefix());
            this.changes.remove(obsoleteChange);
        }
        String fullKey = change.getTargetObjectId() + "|" + change.getTargetProperty();
        if (change.getIsToManyProperty()) {
            ReplicationChangeSet changeList = (ReplicationChangeSet)this.changeMap.get(fullKey);
            if (changeList == null) {
                changeList = new ReplicationChangeSet();
                this.changeMap.put(fullKey, changeList);
            }
            changeList.add(change);
        } else {
            ReplicationChange oldChange = (ReplicationChange)this.changeMap.get(fullKey);
            if (oldChange != null) {
                this.removeFromChanges(oldChange);
            }
            this.changeMap.put(fullKey, change);
        }
    }

    public void addToObsoleteChanges(ReplicationChange change) {
        ReplicationChange oldChange;
        if (this.obsoleteChanges == null) {
            this.obsoleteChanges = new LinkedHashMap();
        }
        if ((oldChange = this.obsoleteChanges.get(change.getHistoryIdPrefix())) != null) {
            this.changeMap.remove(oldChange);
            this.obsoleteChanges.remove(change.getHistoryIdPrefix());
        }
        this.obsoleteChanges.put(change.getHistoryIdPrefix(), change);
    }

    public ChangeHistory withChanges(ReplicationChange ... value) {
        for (ReplicationChange item : value) {
            this.addToChanges(item);
        }
        return this;
    }

    public ChangeHistory withoutChanges(ReplicationChange ... value) {
        for (ReplicationChange item : value) {
            this.removeFromChanges(item);
        }
        return this;
    }
}

