/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.replication;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeSupport;
import java.util.HashMap;
import java.util.LinkedHashSet;
import org.sdmlib.StrUtil;
import org.sdmlib.replication.Lane;
import org.sdmlib.replication.LogEntry;
import org.sdmlib.replication.SeppelSpaceProxy;
import org.sdmlib.replication.Task;
import org.sdmlib.replication.util.BoardTaskSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class BoardTask
extends Task
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_NAME = "name";
    private String name;
    public static final BoardTaskSet EMPTY_SET = new BoardTaskSet();
    public static final String PROPERTY_LANE = "lane";
    private Lane lane = null;
    public static final String PROPERTY_STATUS = "status";
    private String status;
    public static final String PROPERTY_NEXT = "next";
    private BoardTaskSet next = null;
    public static final String PROPERTY_PREV = "prev";
    private BoardTaskSet prev = null;
    public static final String START = "start";
    public static final String PROPERTY_TASKOBJECTS = "taskObjects";
    private HashMap<String, Object> taskObjects = new HashMap();
    public static final String PROPERTY_PROXY = "proxy";
    private SeppelSpaceProxy proxy = null;
    public static final String PROPERTY_MANUALEXECUTION = "manualExecution";
    private boolean manualExecution;
    public static final String PROPERTY_STASHEDPROPERTYCHANGEEVENT = "stashedPropertyChangeEvent";
    private PropertyChangeEvent stashedPropertyChangeEvent;

    public BoardTask() {
        this(false);
    }

    public BoardTask(boolean manualExecution) {
        this(null, manualExecution);
    }

    public BoardTask(String name) {
        this(name, false);
    }

    public BoardTask(String name, boolean manualExecution) {
        this.setName(name);
        this.setManualExecution(manualExecution);
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    @Override
    public void removeYou() {
        this.removeAllFromLogEntries();
        this.setLane(null);
        this.removeAllFromNext();
        this.removeAllFromPrev();
        this.withoutLogEntries((LogEntry[])this.getLogEntries().toArray(new LogEntry[this.getLogEntries().size()]));
        this.withoutNext((BoardTask[])this.getNext().toArray(new BoardTask[this.getNext().size()]));
        this.withoutPrev((BoardTask[])this.getPrev().toArray(new BoardTask[this.getPrev().size()]));
        this.setProxy(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
        super.removeYou();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (!StrUtil.stringEquals(this.name, value)) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    public BoardTask withName(String value) {
        this.setName(value);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getName());
        s.append(" ").append(this.getStatus());
        return s.substring(1);
    }

    public Lane getLane() {
        return this.lane;
    }

    public boolean setLane(Lane value) {
        boolean changed = false;
        if (this.lane != value) {
            Lane oldValue = this.lane;
            if (this.lane != null) {
                this.lane = null;
                oldValue.withoutTasks(this);
            }
            this.lane = value;
            if (value != null) {
                value.withTasks(this);
            }
            this.stashedPropertyChangeEvent = new PropertyChangeEvent(this, PROPERTY_LANE, oldValue, value);
            if (!this.isManualExecution()) {
                this.execute();
            }
            changed = true;
        }
        return changed;
    }

    public BoardTask withLane(Lane value) {
        this.setLane(value);
        return this;
    }

    public Lane createLane() {
        Lane value = new Lane();
        this.withLane(value);
        return value;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String value) {
        if (!StrUtil.stringEquals(this.status, value)) {
            String oldValue = this.status;
            this.status = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STATUS, oldValue, value);
        }
    }

    public BoardTask withStatus(String value) {
        this.setStatus(value);
        return this;
    }

    public BoardTaskSet getNext() {
        if (this.next == null) {
            return EMPTY_SET;
        }
        return this.next;
    }

    public boolean addToNext(BoardTask value) {
        boolean changed = false;
        if (value != null) {
            if (this.next == null) {
                this.next = new BoardTaskSet();
            }
            if (changed = this.next.add(value)) {
                value.withPrev(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NEXT, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromNext(BoardTask value) {
        boolean changed = false;
        if (this.next != null && value != null && (changed = this.next.remove(value))) {
            value.withoutPrev(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NEXT, value, null);
        }
        return changed;
    }

    public BoardTask withNext(BoardTask ... value) {
        for (BoardTask item : value) {
            this.addToNext(item);
        }
        return this;
    }

    public BoardTask withoutNext(BoardTask ... value) {
        for (BoardTask item : value) {
            this.removeFromNext(item);
        }
        return this;
    }

    public void removeAllFromNext() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getNext());
        for (BoardTask value : tmpSet) {
            this.removeFromNext(value);
        }
    }

    public BoardTask createNext() {
        BoardTask value = new BoardTask();
        this.withNext(value);
        return value;
    }

    public BoardTaskSet getPrev() {
        if (this.prev == null) {
            return EMPTY_SET;
        }
        return this.prev;
    }

    public boolean addToPrev(BoardTask value) {
        boolean changed = false;
        if (value != null) {
            if (this.prev == null) {
                this.prev = new BoardTaskSet();
            }
            if (changed = this.prev.add(value)) {
                value.withNext(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PREV, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromPrev(BoardTask value) {
        boolean changed = false;
        if (this.prev != null && value != null && (changed = this.prev.remove(value))) {
            value.withoutNext(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PREV, value, null);
        }
        return changed;
    }

    public BoardTask withPrev(BoardTask ... value) {
        for (BoardTask item : value) {
            this.addToPrev(item);
        }
        return this;
    }

    public BoardTask withoutPrev(BoardTask ... value) {
        for (BoardTask item : value) {
            this.removeFromPrev(item);
        }
        return this;
    }

    public void removeAllFromPrev() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getPrev());
        for (BoardTask value : tmpSet) {
            this.removeFromPrev(value);
        }
    }

    public BoardTask createPrev() {
        BoardTask value = new BoardTask();
        this.withPrev(value);
        return value;
    }

    public void start() {
        this.setStatus(START);
    }

    public BoardTaskSet getNextTransitive() {
        BoardTaskSet result = new BoardTaskSet().with(this);
        return result.getNextTransitive();
    }

    public BoardTaskSet getPrevTransitive() {
        BoardTaskSet result = new BoardTaskSet().with(this);
        return result.getPrevTransitive();
    }

    public Object putTaskObject(String name, Object o) {
        return this.getTaskObjects().put(name, o);
    }

    public HashMap<String, Object> getTaskObjects() {
        return this.taskObjects;
    }

    public void setTaskObjects(HashMap<String, Object> taskObjects) {
        this.taskObjects = taskObjects;
    }

    public BoardTask withTaskObjects(HashMap<String, Object> taskObjects) {
        this.setTaskObjects(taskObjects);
        return this;
    }

    public BoardTask withTaskObject(String name, Object o) {
        this.getTaskObjects().put(name, o);
        return this;
    }

    public SeppelSpaceProxy getProxy() {
        return this.proxy;
    }

    public boolean setProxy(SeppelSpaceProxy value) {
        boolean changed = false;
        if (this.proxy != value) {
            SeppelSpaceProxy oldValue = this.proxy;
            if (this.proxy != null) {
                this.proxy = null;
                oldValue.withoutTasks(this);
            }
            this.proxy = value;
            if (value != null) {
                value.withTasks(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PROXY, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public BoardTask withProxy(SeppelSpaceProxy value) {
        this.setProxy(value);
        return this;
    }

    public SeppelSpaceProxy createProxy() {
        SeppelSpaceProxy value = new SeppelSpaceProxy();
        this.withProxy(value);
        return value;
    }

    public Object getFromTaskObjects(String key) {
        return this.taskObjects.get(key);
    }

    public boolean isManualExecution() {
        return this.manualExecution;
    }

    public void setManualExecution(boolean value) {
        if (this.manualExecution != value) {
            boolean oldValue = this.manualExecution;
            this.manualExecution = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MANUALEXECUTION, oldValue, value);
        }
    }

    public BoardTask withManualExecution(boolean value) {
        this.setManualExecution(value);
        return this;
    }

    public void execute() {
        this.getPropertyChangeSupport().firePropertyChange(this.stashedPropertyChangeEvent);
    }

    public PropertyChangeEvent getStashedPropertyChangeEvent() {
        return this.stashedPropertyChangeEvent;
    }

    public void setStashedPropertyChangeEvent(PropertyChangeEvent value) {
        if (this.stashedPropertyChangeEvent != value) {
            PropertyChangeEvent oldValue = this.stashedPropertyChangeEvent;
            this.stashedPropertyChangeEvent = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STASHEDPROPERTYCHANGEEVENT, oldValue, value);
        }
    }

    public BoardTask withStashedPropertyChangeEvent(PropertyChangeEvent value) {
        this.setStashedPropertyChangeEvent(value);
        return this;
    }
}

