/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.transformations.util;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.sdmlib.models.modelsets.ObjectSet;
import org.sdmlib.models.modelsets.SDMSet;
import org.sdmlib.models.modelsets.StringList;
import org.sdmlib.models.modelsets.intList;
import org.sdmlib.models.transformations.Match;
import org.sdmlib.models.transformations.PlaceHolderDescription;
import org.sdmlib.models.transformations.Template;
import org.sdmlib.models.transformations.util.MatchPO;
import org.sdmlib.models.transformations.util.PlaceHolderDescriptionSet;
import org.sdmlib.models.transformations.util.TemplateSet;

public class MatchSet
extends SDMSet<Match> {
    public static final MatchSet EMPTY_SET = (MatchSet)new MatchSet().withReadOnly(true);

    public MatchPO hasMatchPO() {
        return new MatchPO((Match[])this.toArray(new Match[this.size()]));
    }

    @Override
    public String getEntryType() {
        return "org.sdmlib.models.transformations.Match";
    }

    public MatchSet with(Object value) {
        if (value instanceof Collection) {
            this.addAll((Collection)value);
        } else if (value != null) {
            this.add((Match)value);
        }
        return this;
    }

    public MatchSet without(Match value) {
        this.remove(value);
        return this;
    }

    public intList getStartPos() {
        intList result = new intList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getStartPos());
        }
        return result;
    }

    public MatchSet hasStartPos(int value) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (value != obj.getStartPos()) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet hasStartPos(int lower, int upper) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (lower > obj.getStartPos() || obj.getStartPos() > upper) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet withStartPos(int value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.setStartPos(value);
        }
        return this;
    }

    public intList getEndPos() {
        intList result = new intList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getEndPos());
        }
        return result;
    }

    public MatchSet hasEndPos(int value) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (value != obj.getEndPos()) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet hasEndPos(int lower, int upper) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (lower > obj.getEndPos() || obj.getEndPos() > upper) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet withEndPos(int value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.setEndPos(value);
        }
        return this;
    }

    public StringList getFullText() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getFullText());
        }
        return result;
    }

    public MatchSet hasFullText(String value) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (!value.equals(obj.getFullText())) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet hasFullText(String lower, String upper) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (lower.compareTo(obj.getFullText()) > 0 || obj.getFullText().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet withFullText(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.setFullText(value);
        }
        return this;
    }

    public StringList getMatchText() {
        StringList result = new StringList();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getMatchText());
        }
        return result;
    }

    public MatchSet hasMatchText(String value) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (!value.equals(obj.getMatchText())) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet hasMatchText(String lower, String upper) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (lower.compareTo(obj.getMatchText()) > 0 || obj.getMatchText().compareTo(upper) > 0) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet withMatchText(String value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.setMatchText(value);
        }
        return this;
    }

    public ObjectSet getModelObject() {
        ObjectSet result = new ObjectSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getModelObject());
        }
        return result;
    }

    public MatchSet hasModelObject(Object value) {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (value != obj.getModelObject()) continue;
            result.add(obj);
        }
        return result;
    }

    public MatchSet withModelObject(Object value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.setModelObject(value);
        }
        return this;
    }

    public TemplateSet getTemplate() {
        TemplateSet result = new TemplateSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getTemplate());
        }
        return result;
    }

    public MatchSet hasTemplate(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        MatchSet answer = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (!neighbors.contains(obj.getTemplate())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public MatchSet withTemplate(Template value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.withTemplate(value);
        }
        return this;
    }

    public PlaceHolderDescriptionSet getPlaceholder() {
        PlaceHolderDescriptionSet result = new PlaceHolderDescriptionSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getPlaceholder());
        }
        return result;
    }

    public MatchSet hasPlaceholder(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        MatchSet answer = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (!neighbors.contains(obj.getPlaceholder())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public MatchSet withPlaceholder(PlaceHolderDescription value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.withPlaceholder(value);
        }
        return this;
    }

    public MatchSet getSubMatches() {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.addAll((Collection)((Object)obj.getSubMatches()));
        }
        return result;
    }

    public MatchSet hasSubMatches(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        MatchSet answer = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (Collections.disjoint(neighbors, obj.getSubMatches())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public MatchSet getSubMatchesTransitive() {
        MatchSet todo = new MatchSet().with(this);
        MatchSet result = new MatchSet();
        while (!todo.isEmpty()) {
            Match current = (Match)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            todo.with(current.getSubMatches().minus(result));
        }
        return result;
    }

    public MatchSet withSubMatches(Match value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.withSubMatches(value);
        }
        return this;
    }

    public MatchSet withoutSubMatches(Match value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.withoutSubMatches(value);
        }
        return this;
    }

    public MatchSet getParentMatch() {
        MatchSet result = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            result.add(obj.getParentMatch());
        }
        return result;
    }

    public MatchSet hasParentMatch(Object value) {
        ObjectSet neighbors = new ObjectSet();
        if (value instanceof Collection) {
            neighbors.addAll((Collection)value);
        } else {
            neighbors.add(value);
        }
        MatchSet answer = new MatchSet();
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            if (!neighbors.contains(obj.getParentMatch())) continue;
            answer.add(obj);
        }
        return answer;
    }

    public MatchSet getParentMatchTransitive() {
        MatchSet todo = new MatchSet().with(this);
        MatchSet result = new MatchSet();
        while (!todo.isEmpty()) {
            Match current = (Match)todo.first();
            todo.remove(current);
            if (result.contains(current)) continue;
            result.add(current);
            if (result.contains(current.getParentMatch())) continue;
            todo.with(current.getParentMatch());
        }
        return result;
    }

    public MatchSet withParentMatch(Match value) {
        Iterator iterator = this.iterator();
        while (iterator.hasNext()) {
            Match obj = (Match)iterator.next();
            obj.withParentMatch(value);
        }
        return this;
    }
}

