/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.transformations;

import de.uniks.networkparser.IdMap;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonIdMap;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.models.transformations.ChoiceTemplate;
import org.sdmlib.models.transformations.Match;
import org.sdmlib.models.transformations.PlaceHolderDescription;
import org.sdmlib.models.transformations.util.MatchSet;
import org.sdmlib.models.transformations.util.PlaceHolderDescriptionSet;
import org.sdmlib.models.transformations.util.TemplateSet;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.storyboards.GenericCreator;
import org.sdmlib.storyboards.GenericIdMap;

public class Template
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_TEMPLATETEXT = "templateText";
    private String templateText = "";
    public static final String PROPERTY_MODELOBJECT = "modelObject";
    private Object modelObject;
    public static final String PROPERTY_MODELCLASSNAME = "modelClassName";
    private String modelClassName;
    public static final String PROPERTY_EXPANDEDTEXT = "expandedText";
    private String expandedText;
    protected JsonIdMap idMap;
    protected int currentPosInExpandedText = 0;
    protected String constFragmentFollowingAfterList;
    public static int logStartPos = 8331;
    private int startOfMatch = -1;
    public static int expansionStep = 0;
    public static int logStartStep = 453;
    public static final String PROPERTY_LISTSTART = "listStart";
    private String listStart = "";
    public static final String PROPERTY_LISTSEPARATOR = "listSeparator";
    private String listSeparator = "";
    public static final String PROPERTY_LISTEND = "listEnd";
    private String listEnd = "";
    public static final TemplateSet EMPTY_SET = new TemplateSet();
    public static final String PROPERTY_PLACEHOLDERS = "placeholders";
    private PlaceHolderDescriptionSet placeholders = null;
    public static final String PROPERTY_CHOOSER = "chooser";
    private ChoiceTemplate chooser = null;
    public static final String PROPERTY_MATCHES = "matches";
    private MatchSet matches = null;
    public static final String PROPERTY_PARENTS = "parents";
    private PlaceHolderDescriptionSet parents = null;
    public static final String PROPERTY_REFERENCELOOKUP = "referenceLookup";
    private boolean referenceLookup = false;
    public static final String PROPERTY_NAME = "name";
    private String name;

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removeYou() {
        this.setChooser(null);
        this.withoutPlaceholders((PlaceHolderDescription[])this.getPlaceholders().toArray(new PlaceHolderDescription[this.getPlaceholders().size()]));
        this.withoutMatches((Match[])this.getMatches().toArray(new Match[this.getMatches().size()]));
        this.withoutParents((PlaceHolderDescription[])this.getParents().toArray(new PlaceHolderDescription[this.getParents().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getTemplateText() {
        return this.templateText;
    }

    public void setTemplateText(String value) {
        if (!StrUtil.stringEquals(this.templateText, value)) {
            String oldValue = this.templateText;
            this.templateText = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TEMPLATETEXT, oldValue, value);
        }
    }

    public Template withTemplateText(String value) {
        this.setTemplateText(value);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTemplateText());
        s.append(" ").append(this.getModelClassName());
        s.append(" ").append(this.getExpandedText());
        s.append(" ").append(this.getListStart());
        s.append(" ").append(this.getListSeparator());
        s.append(" ").append(this.getListEnd());
        s.append(" ").append(this.getName());
        return s.substring(1);
    }

    public Template withSimple(String propertyName) {
        return this.with("_", "_", propertyName);
    }

    public Template withReplacements(String ... placeholderAttrNamePairs) {
        int i = 0;
        while (i + 2 <= placeholderAttrNamePairs.length) {
            this.createPlaceholders().withTextFragment(placeholderAttrNamePairs[i]).withAttrName(placeholderAttrNamePairs[i + 1]);
            i += 2;
        }
        return this;
    }

    public Template with(String templateText, String ... placeholderAttrNamePairs) {
        this.setTemplateText(templateText);
        this.withReplacements(placeholderAttrNamePairs);
        return this;
    }

    public Template withList(String start, String separator, String end) {
        this.setListStart(start);
        this.setListSeparator(separator);
        this.setListEnd(end);
        return this;
    }

    public Object getModelObject() {
        return this.modelObject;
    }

    public void setModelObject(Object value) {
        if (this.modelObject != value) {
            Object oldValue = this.modelObject;
            this.modelObject = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MODELOBJECT, oldValue, value);
        }
    }

    public Template withModelObject(Object value) {
        this.setModelObject(value);
        return this;
    }

    public String getModelClassName() {
        return this.modelClassName;
    }

    public void setModelClassName(String value) {
        if (!StrUtil.stringEquals(this.modelClassName, value)) {
            String oldValue = this.modelClassName;
            this.modelClassName = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MODELCLASSNAME, oldValue, value);
        }
    }

    public Template withModelClassName(String value) {
        this.setModelClassName(value);
        return this;
    }

    public Template createPlaceHolderAndSubTemplate() {
        PlaceHolderDescription placeholder = this.createPlaceholders();
        Template subTemplate = placeholder.createSubTemplate();
        return subTemplate;
    }

    public String getExpandedText() {
        return this.expandedText;
    }

    public void setExpandedText(String value) {
        if (!StrUtil.stringEquals(this.expandedText, value)) {
            String oldValue = this.expandedText;
            this.expandedText = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_EXPANDEDTEXT, oldValue, value);
        }
    }

    public Template withExpandedText(String value) {
        this.setExpandedText(value);
        return this;
    }

    public int getValueStartPos() {
        return this.currentPosInExpandedText;
    }

    public Template withValueStartPos(int valueStartPos) {
        this.currentPosInExpandedText = valueStartPos;
        return this;
    }

    public Match parseOnceNew() {
        this.currentPosInExpandedText = 0;
        return this.parseOnce();
    }

    public MatchSet parse() {
        MatchSet result = new MatchSet();
        if (!this.isList()) {
            Match subMatch = this.parseOnce();
            if (subMatch != null) {
                result.add(subMatch);
            }
        } else {
            int oldValueStartPos = 0;
            int listStartPos = this.getExpandedText().indexOf(this.getListStart(), this.currentPosInExpandedText);
            if (listStartPos >= 0) {
                this.currentPosInExpandedText += this.getListStart().length();
                LinkedHashSet<Object> modelObjectSet = new LinkedHashSet<Object>();
                oldValueStartPos = this.currentPosInExpandedText;
                Match subMatch = this.parseOnce();
                while (subMatch != null) {
                    boolean found;
                    modelObjectSet.add(this.getModelObject());
                    result.add(subMatch);
                    int listSeperatorPos = this.getExpandedText().indexOf(this.getListSeparator(), this.currentPosInExpandedText);
                    int behindListSeparatorPos = listSeperatorPos + this.getListSeparator().length();
                    int listEndPos = this.getExpandedText().indexOf(this.getListEnd(), this.currentPosInExpandedText);
                    if (" ".equals(this.getListSeparator())) {
                        int length = this.getExpandedText().length();
                        boolean startFound = false;
                        for (int i = this.currentPosInExpandedText; i < length; ++i) {
                            char charAt = this.expandedText.charAt(i);
                            if (!startFound && Character.isWhitespace(charAt)) {
                                startFound = true;
                                listSeperatorPos = i;
                                behindListSeparatorPos = i + 1;
                                continue;
                            }
                            if (!startFound) continue;
                            if (!Character.isWhitespace(charAt)) break;
                            behindListSeparatorPos = i + 1;
                        }
                    }
                    if ("".equals(this.getListEnd())) {
                        listEndPos = this.getExpandedText().indexOf(this.constFragmentFollowingAfterList, this.currentPosInExpandedText);
                    }
                    boolean bl = found = listSeperatorPos == this.currentPosInExpandedText && listSeperatorPos <= listEndPos;
                    if (found) {
                        oldValueStartPos = this.currentPosInExpandedText;
                        this.currentPosInExpandedText = behindListSeparatorPos;
                        subMatch = this.parseOnce();
                        continue;
                    }
                    subMatch = null;
                    oldValueStartPos = this.currentPosInExpandedText;
                }
                this.currentPosInExpandedText = oldValueStartPos;
                int listEndPos = this.getExpandedText().indexOf(this.getListEnd(), this.currentPosInExpandedText);
                if (listEndPos == this.currentPosInExpandedText) {
                    this.currentPosInExpandedText += this.getListEnd().length();
                }
                this.setModelObject(modelObjectSet);
            }
        }
        return result;
    }

    public Match parseOnce() {
        int placeHolderPosInTemplateText = 0;
        int currentPosInTemplateText = 0;
        int matchStartPos = this.currentPosInExpandedText;
        Match templateMatch = new Match().withFullText(this.getExpandedText()).withStartPos(matchStartPos);
        Iterator iterator = this.getPlaceholders().iterator();
        if (iterator.hasNext()) {
            PlaceHolderDescription placeholder = (PlaceHolderDescription)iterator.next();
            placeHolderPosInTemplateText = this.getTemplateText().indexOf(placeholder.getTextFragment(), currentPosInTemplateText);
            String constfragment = this.getTemplateText().substring(currentPosInTemplateText, placeHolderPosInTemplateText);
            currentPosInTemplateText = placeHolderPosInTemplateText + placeholder.getTextFragment().length();
            int endOfMatchInExpandedText = this.matchConstantFragmentToExpandedText(constfragment, this.currentPosInExpandedText);
            if (this.startOfMatch != this.currentPosInExpandedText || endOfMatchInExpandedText < this.currentPosInExpandedText) {
                return null;
            }
            this.currentPosInExpandedText = endOfMatchInExpandedText;
            SendableEntityCreator creator = this.getIdMap().getCreator(this.getModelClassName(), true);
            boolean first = true;
            do {
                Template subTemplate;
                if (this.currentPosInExpandedText >= logStartPos) {
                    System.out.print("Parsing at " + this.currentPosInExpandedText + ": " + this.getExpandedText().substring(this.currentPosInExpandedText, Math.min(this.currentPosInExpandedText + 50, this.getExpandedText().length())));
                    System.out.println();
                }
                PlaceHolderDescription previousPlaceHolder = placeholder;
                placeholder = iterator.hasNext() ? (PlaceHolderDescription)iterator.next() : null;
                placeHolderPosInTemplateText = placeholder != null ? this.getTemplateText().indexOf(placeholder.getTextFragment(), currentPosInTemplateText) : this.getTemplateText().length();
                constfragment = this.getTemplateText().substring(currentPosInTemplateText, placeHolderPosInTemplateText);
                if (placeholder != null) {
                    currentPosInTemplateText = placeHolderPosInTemplateText + placeholder.getTextFragment().length();
                }
                if ((subTemplate = previousPlaceHolder.getSubTemplate()) != null) {
                    MatchSet subMatches = subTemplate.withExpandedText(this.getExpandedText()).withValueStartPos(this.currentPosInExpandedText).withIdMap(this.idMap).withConstFragmentFollowingAfterList(constfragment).parse();
                    if (!subMatches.isEmpty()) {
                        Match placeholderMatch = new Match().withPlaceholder(previousPlaceHolder).withModelObject(this.getModelObject()).withFullText(this.getExpandedText()).withStartPos(this.currentPosInExpandedText).withEndPos(subTemplate.getValueStartPos() - 1).withParentMatch(templateMatch).withSubMatches((Match[])subMatches.toArray(new Match[0]));
                    }
                    this.currentPosInExpandedText = subTemplate.getValueStartPos();
                    endOfMatchInExpandedText = this.matchConstantFragmentToExpandedText(constfragment, this.currentPosInExpandedText);
                    if (endOfMatchInExpandedText < 0) {
                        return null;
                    }
                    this.currentPosInExpandedText = endOfMatchInExpandedText;
                    continue;
                }
                endOfMatchInExpandedText = this.matchConstantFragmentToExpandedText(constfragment, this.currentPosInExpandedText);
                if (endOfMatchInExpandedText < 0) {
                    return null;
                }
                if (constfragment.equals("")) {
                    int listSeparatorPos = this.getExpandedText().indexOf(this.getListSeparator(), this.currentPosInExpandedText);
                    int listEndPos = this.getExpandedText().indexOf(this.getListEnd(), this.currentPosInExpandedText);
                    if ("".equals(this.getListEnd())) {
                        listEndPos = this.getExpandedText().indexOf(this.constFragmentFollowingAfterList, this.currentPosInExpandedText);
                    }
                    if (!"".equals(this.getListSeparator()) && listSeparatorPos >= 0 && listSeparatorPos < listEndPos) {
                        this.startOfMatch = listSeparatorPos;
                        endOfMatchInExpandedText = listSeparatorPos;
                    } else if (listEndPos >= 0) {
                        this.startOfMatch = listEndPos;
                        endOfMatchInExpandedText = listEndPos;
                    } else {
                        return null;
                    }
                }
                String value = this.getExpandedText().substring(this.currentPosInExpandedText, this.startOfMatch);
                int valueStartPos = this.currentPosInExpandedText;
                this.currentPosInExpandedText = endOfMatchInExpandedText;
                if (first) {
                    first = false;
                    String key = this.getModelClassName() + "_" + value;
                    Object object = this.idMap.getObject(key);
                    if (object != null && !this.referenceLookup) {
                        System.out.println("Warning: two objects with id: " + key);
                    }
                    if (object == null || !this.referenceLookup) {
                        object = creator.getSendableInstance(false);
                    }
                    this.idMap.put(key, object);
                    this.setModelObject(object);
                }
                creator.setValue(this.getModelObject(), previousPlaceHolder.getAttrName(), (Object)value, "update");
                Match placeholderMatch = new Match().withPlaceholder(previousPlaceHolder).withModelObject(this.getModelObject()).withFullText(this.getExpandedText()).withStartPos(valueStartPos).withEndPos(endOfMatchInExpandedText - 1).withParentMatch(templateMatch);
            } while (placeholder != null);
        }
        templateMatch.withEndPos(this.currentPosInExpandedText - 1).withTemplate(this).withModelObject(this.getModelObject());
        return templateMatch;
    }

    private int matchConstantFragmentToExpandedText(String constfragment, int currentPosInExpandedText) {
        int currentPosInConstFragment = 0;
        int blankPos = constfragment.indexOf(32);
        if (blankPos <= 0) {
            blankPos = constfragment.length();
        }
        if ((currentPosInExpandedText = this.expandedText.indexOf(constfragment.substring(0, blankPos), currentPosInExpandedText)) < 0) {
            return -1;
        }
        this.startOfMatch = currentPosInExpandedText;
        while (currentPosInConstFragment < constfragment.length()) {
            char constFragmentChar = constfragment.charAt(currentPosInConstFragment);
            if (constFragmentChar == ' ') {
                char nextFragmentChar = '\u0000';
                if (currentPosInConstFragment + 1 < constfragment.length()) {
                    nextFragmentChar = constfragment.charAt(currentPosInConstFragment + 1);
                }
                while (currentPosInExpandedText < this.expandedText.length() && Character.isWhitespace(this.expandedText.charAt(currentPosInExpandedText)) && this.expandedText.charAt(currentPosInExpandedText) != nextFragmentChar) {
                    ++currentPosInExpandedText;
                }
                ++currentPosInConstFragment;
                continue;
            }
            if (this.expandedText.charAt(currentPosInExpandedText) != constFragmentChar) {
                return -1;
            }
            ++currentPosInConstFragment;
            ++currentPosInExpandedText;
        }
        return currentPosInExpandedText;
    }

    protected Template withConstFragmentFollowingAfterList(String constfragment) {
        this.constFragmentFollowingAfterList = constfragment;
        return this;
    }

    private IdMap getIdMap() {
        if (this.idMap == null) {
            this.idMap = new GenericIdMap();
        }
        return this.idMap;
    }

    private boolean isList() {
        return !"".equals(this.getListStart() + this.getListSeparator() + this.getListEnd());
    }

    protected Template withIdMap(JsonIdMap idMap2) {
        this.idMap = idMap2;
        return this;
    }

    public void generate() {
        StringBuilder result = new StringBuilder();
        this.provideIdMap();
        LinkedHashSet<Object> rootObjects = new LinkedHashSet<Object>();
        if (this.modelObject == null) {
            this.setExpandedText("");
            return;
        }
        if (this.modelObject instanceof Collection) {
            Collection collection = (Collection)this.modelObject;
            if (!collection.isEmpty()) {
                Object elem = collection.iterator().next();
                if ("Double Integer String".indexOf(CGUtil.shortClassName(elem.getClass().getName())) >= 0) {
                    rootObjects.add(this.modelObject);
                } else {
                    rootObjects.addAll((Collection)this.modelObject);
                }
            }
        } else {
            rootObjects.add(this.modelObject);
        }
        result.append(this.getListStart());
        boolean first = true;
        for (Object e : rootObjects) {
            if (first) {
                first = false;
                this.setModelClassName(e.getClass().getName());
            } else {
                result.append(this.getListSeparator());
            }
            int searchPos = 0;
            Iterator iterator = this.getPlaceholders().iterator();
            while (iterator.hasNext()) {
                PlaceHolderDescription placeholder = (PlaceHolderDescription)iterator.next();
                int foundPos = this.getTemplateText().indexOf(placeholder.getTextFragment(), searchPos);
                if (foundPos < 0) continue;
                result.append(this.getTemplateText().substring(searchPos, foundPos));
                Object attrValue = this.getValue(placeholder, e);
                Template subTemplate = placeholder.getSubTemplate();
                if (subTemplate == null) {
                    if (++expansionStep >= logStartStep) {
                        System.out.print("Expansion step " + expansionStep + ": " + this + " " + attrValue);
                        System.out.println();
                    }
                    result.append(attrValue);
                } else {
                    if (++expansionStep >= logStartStep) {
                        System.out.print("Expansion step " + expansionStep + ": " + subTemplate + " " + attrValue);
                        System.out.println();
                    }
                    subTemplate.withModelObject(attrValue).generate();
                    result.append(subTemplate.getExpandedText());
                }
                searchPos = foundPos + placeholder.getTextFragment().length();
            }
            result.append(this.getTemplateText().substring(searchPos));
        }
        result.append(this.getListEnd());
        this.setExpandedText(result.toString());
    }

    private Object getValue(PlaceHolderDescription placeholder, Object root) {
        String[] split = placeholder.getAttrName().split("\\.");
        Object currentObject = root;
        for (String attrName : split) {
            Integer index = null;
            try {
                index = Integer.valueOf(attrName);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            if (index != null) {
                Object[] array = ((Collection)currentObject).toArray(new Object[((Collection)currentObject).size()]);
                currentObject = array[index];
                continue;
            }
            if (currentObject instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)currentObject;
                currentObject = arrayList.get(Integer.valueOf(attrName));
                continue;
            }
            SendableEntityCreator creator = this.idMap.getCreatorClass(currentObject);
            if (creator == null) {
                creator = new GenericCreator().withClassName(currentObject.getClass().getName());
            }
            currentObject = creator.getValue(currentObject, attrName);
        }
        return currentObject;
    }

    private void provideIdMap() {
        try {
            if (this.idMap == null) {
                String className = this.modelObject.getClass().getName();
                String packageName = CGUtil.packageName(className) + ".util";
                className = packageName + "." + CGUtil.shortClassName(className) + "Creator";
                this.idMap = new GenericIdMap();
                Class<?> creatorClass = Class.forName(className);
                Method method = creatorClass.getDeclaredMethod("createIdMap", String.class);
                JsonIdMap newIdMap = (JsonIdMap)method.invoke(null, "debug");
                this.idMap.withCreator((Iterable)newIdMap);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String getListStart() {
        return this.listStart;
    }

    public void setListStart(String value) {
        if (!StrUtil.stringEquals(this.listStart, value)) {
            String oldValue = this.listStart;
            this.listStart = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LISTSTART, oldValue, value);
        }
    }

    public Template withListStart(String value) {
        this.setListStart(value);
        return this;
    }

    public String getListSeparator() {
        return this.listSeparator;
    }

    public void setListSeparator(String value) {
        if (!StrUtil.stringEquals(this.listSeparator, value)) {
            String oldValue = this.listSeparator;
            this.listSeparator = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LISTSEPARATOR, oldValue, value);
        }
    }

    public Template withListSeparator(String value) {
        this.setListSeparator(value);
        return this;
    }

    public String getListEnd() {
        return this.listEnd;
    }

    public void setListEnd(String value) {
        if (!StrUtil.stringEquals(this.listEnd, value)) {
            String oldValue = this.listEnd;
            this.listEnd = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LISTEND, oldValue, value);
        }
    }

    public Template withListEnd(String value) {
        this.setListEnd(value);
        return this;
    }

    public Template withParent(String textFragment, String attrName) {
        ((PlaceHolderDescription)this.getParents().first()).withTextFragment(textFragment).withAttrName(attrName);
        return this;
    }

    public PlaceHolderDescriptionSet getPlaceholders() {
        if (this.placeholders == null) {
            return PlaceHolderDescription.EMPTY_SET;
        }
        return this.placeholders;
    }

    public boolean addToPlaceholders(PlaceHolderDescription value) {
        boolean changed = false;
        if (value != null) {
            if (this.placeholders == null) {
                this.placeholders = new PlaceHolderDescriptionSet();
            }
            if (changed = this.placeholders.add(value)) {
                value.withOwners(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PLACEHOLDERS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromPlaceholders(PlaceHolderDescription value) {
        boolean changed = false;
        if (this.placeholders != null && value != null && (changed = this.placeholders.remove(value))) {
            value.withoutOwners(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PLACEHOLDERS, value, null);
        }
        return changed;
    }

    public Template withPlaceholders(PlaceHolderDescription ... value) {
        for (PlaceHolderDescription item : value) {
            this.addToPlaceholders(item);
        }
        return this;
    }

    public Template withoutPlaceholders(PlaceHolderDescription ... value) {
        for (PlaceHolderDescription item : value) {
            this.removeFromPlaceholders(item);
        }
        return this;
    }

    public void removeAllFromPlaceholders() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getPlaceholders());
        for (PlaceHolderDescription value : tmpSet) {
            this.removeFromPlaceholders(value);
        }
    }

    public PlaceHolderDescription createPlaceholders() {
        PlaceHolderDescription value = new PlaceHolderDescription();
        this.withPlaceholders(value);
        return value;
    }

    public ChoiceTemplate getChooser() {
        return this.chooser;
    }

    public boolean setChooser(ChoiceTemplate value) {
        boolean changed = false;
        if (this.chooser != value) {
            ChoiceTemplate oldValue = this.chooser;
            if (this.chooser != null) {
                this.chooser = null;
                oldValue.withoutChoices(this);
            }
            this.chooser = value;
            if (value != null) {
                value.withChoices(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHOOSER, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Template withChooser(ChoiceTemplate value) {
        this.setChooser(value);
        return this;
    }

    public ChoiceTemplate createChooser() {
        ChoiceTemplate value = new ChoiceTemplate();
        this.withChooser(value);
        return value;
    }

    public MatchSet getMatches() {
        if (this.matches == null) {
            return Match.EMPTY_SET;
        }
        return this.matches;
    }

    public boolean addToMatches(Match value) {
        boolean changed = false;
        if (value != null) {
            if (this.matches == null) {
                this.matches = new MatchSet();
            }
            if (changed = this.matches.add(value)) {
                value.withTemplate(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MATCHES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromMatches(Match value) {
        boolean changed = false;
        if (this.matches != null && value != null && (changed = this.matches.remove(value))) {
            value.setTemplate(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MATCHES, value, null);
        }
        return changed;
    }

    public Template withMatches(Match ... value) {
        for (Match item : value) {
            this.addToMatches(item);
        }
        return this;
    }

    public Template withoutMatches(Match ... value) {
        for (Match item : value) {
            this.removeFromMatches(item);
        }
        return this;
    }

    public void removeAllFromMatches() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getMatches());
        for (Match value : tmpSet) {
            this.removeFromMatches(value);
        }
    }

    public Match createMatches() {
        Match value = new Match();
        this.withMatches(value);
        return value;
    }

    public PlaceHolderDescriptionSet getParents() {
        if (this.parents == null) {
            return PlaceHolderDescription.EMPTY_SET;
        }
        return this.parents;
    }

    public boolean addToParents(PlaceHolderDescription value) {
        boolean changed = false;
        if (value != null) {
            if (this.parents == null) {
                this.parents = new PlaceHolderDescriptionSet();
            }
            if (changed = this.parents.add(value)) {
                value.withSubTemplate(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARENTS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromParents(PlaceHolderDescription value) {
        boolean changed = false;
        if (this.parents != null && value != null && (changed = this.parents.remove(value))) {
            value.setSubTemplate(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARENTS, value, null);
        }
        return changed;
    }

    public Template withParents(PlaceHolderDescription ... value) {
        for (PlaceHolderDescription item : value) {
            this.addToParents(item);
        }
        return this;
    }

    public Template withoutParents(PlaceHolderDescription ... value) {
        for (PlaceHolderDescription item : value) {
            this.removeFromParents(item);
        }
        return this;
    }

    public void removeAllFromParents() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getParents());
        for (PlaceHolderDescription value : tmpSet) {
            this.removeFromParents(value);
        }
    }

    public PlaceHolderDescription createParents() {
        PlaceHolderDescription value = new PlaceHolderDescription();
        this.withParents(value);
        return value;
    }

    public Template createPlaceHolderAndSubTemplate(String textFragment, String attrName, String templateText, String listStart, String listSeparator, String listEnd) {
        Template subTemplate = this.createPlaceHolderAndSubTemplate(textFragment, attrName, templateText).withList(listStart, listSeparator, listEnd);
        return subTemplate;
    }

    public Template createPlaceHolderAndSubTemplate(String textFragment, String attrName, String templateText) {
        Template subTemplate = this.createPlaceHolderAndSubTemplate().withParent(textFragment, attrName).withTemplateText(templateText);
        return subTemplate;
    }

    public Template withMultiStep(String textFragment, String ... properties) {
        Template subTemplate = this.createPlaceHolderAndSubTemplate().withParent(textFragment, properties[0]);
        for (int i = 1; i < properties.length - 1; ++i) {
            subTemplate = subTemplate.createPlaceHolderAndSubTemplate("_", properties[i], "_");
        }
        subTemplate.withSimple(properties[properties.length - 1]);
        return this;
    }

    public Template withSeparatedMultiStep(String textFragment, String listSeperator, String ... properties) {
        Template subTemplate = this.createPlaceHolderAndSubTemplate().withParent(textFragment, properties[0]).withListSeparator(listSeperator);
        for (int i = 1; i < properties.length - 1; ++i) {
            subTemplate = subTemplate.createPlaceHolderAndSubTemplate("_", properties[i], "_");
        }
        subTemplate.withSimple(properties[properties.length - 1]);
        return this;
    }

    public boolean getReferenceLookup() {
        return this.referenceLookup;
    }

    public void setReferenceLookup(boolean value) {
        if (this.referenceLookup != value) {
            boolean oldValue = this.referenceLookup;
            this.referenceLookup = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_REFERENCELOOKUP, oldValue, value);
        }
    }

    public Template withReferenceLookup(boolean value) {
        this.setReferenceLookup(value);
        return this;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (!StrUtil.stringEquals(this.name, value)) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    public Template withName(String value) {
        this.setName(value);
        return this;
    }
}

