/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.transformations;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.LinkedHashSet;
import org.sdmlib.StrUtil;
import org.sdmlib.models.transformations.PlaceHolderDescription;
import org.sdmlib.models.transformations.Template;
import org.sdmlib.models.transformations.util.MatchSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class Match
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_STARTPOS = "startPos";
    private int startPos;
    public static final String PROPERTY_ENDPOS = "endPos";
    private int endPos;
    public static final String PROPERTY_FULLTEXT = "fullText";
    private String fullText = "";
    public static final String PROPERTY_MATCHTEXT = "matchText";
    private String matchText;
    public static final String PROPERTY_MODELOBJECT = "modelObject";
    private Object modelObject;
    public static final String PROPERTY_TEMPLATE = "template";
    private Template template = null;
    public static final MatchSet EMPTY_SET = new MatchSet();
    public static final String PROPERTY_PLACEHOLDER = "placeholder";
    private PlaceHolderDescription placeholder = null;
    public static final String PROPERTY_SUBMATCHES = "subMatches";
    private MatchSet subMatches = null;
    public static final String PROPERTY_PARENTMATCH = "parentMatch";
    private Match parentMatch = null;

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    public void removeYou() {
        this.setTemplate(null);
        this.setPlaceholder(null);
        this.setParentMatch(null);
        this.withoutSubMatches((Match[])this.getSubMatches().toArray(new Match[this.getSubMatches().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public int getStartPos() {
        return this.startPos;
    }

    public void setStartPos(int value) {
        if (this.startPos != value) {
            int oldValue = this.startPos;
            this.startPos = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STARTPOS, oldValue, value);
        }
    }

    public Match withStartPos(int value) {
        this.setStartPos(value);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getStartPos());
        s.append(" ").append(this.getEndPos());
        s.append(" ").append(this.getMatchText());
        return s.substring(1);
    }

    public int getEndPos() {
        return this.endPos;
    }

    public void setEndPos(int value) {
        if (this.endPos != value) {
            int oldValue = this.endPos;
            this.endPos = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENDPOS, oldValue, value);
        }
    }

    public Match withEndPos(int value) {
        this.setEndPos(value);
        return this;
    }

    public String getFullText() {
        return this.fullText;
    }

    public void setFullText(String value) {
        if (!StrUtil.stringEquals(this.fullText, value)) {
            String oldValue = this.fullText;
            this.fullText = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FULLTEXT, oldValue, value);
        }
    }

    public Match withFullText(String value) {
        this.setFullText(value);
        return this;
    }

    public String getMatchText() {
        if (this.matchText == null) {
            this.matchText = this.fullText.substring(this.startPos, Math.max(this.startPos, Math.min(this.endPos + 1, this.fullText.length())));
        }
        return this.matchText;
    }

    public void setMatchText(String value) {
        if (!StrUtil.stringEquals(this.matchText, value)) {
            String oldValue = this.matchText;
            this.matchText = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MATCHTEXT, oldValue, value);
        }
    }

    public Match withMatchText(String value) {
        this.setMatchText(value);
        return this;
    }

    public Object getModelObject() {
        return this.modelObject;
    }

    public void setModelObject(Object value) {
        if (this.modelObject != value) {
            Object oldValue = this.modelObject;
            this.modelObject = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MODELOBJECT, oldValue, value);
        }
    }

    public Match withModelObject(Object value) {
        this.setModelObject(value);
        return this;
    }

    public Template getTemplate() {
        return this.template;
    }

    public boolean setTemplate(Template value) {
        boolean changed = false;
        if (this.template != value) {
            Template oldValue = this.template;
            if (this.template != null) {
                this.template = null;
                oldValue.withoutMatches(this);
            }
            this.template = value;
            if (value != null) {
                value.withMatches(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TEMPLATE, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Match withTemplate(Template value) {
        this.setTemplate(value);
        return this;
    }

    public Template createTemplate() {
        Template value = new Template();
        this.withTemplate(value);
        return value;
    }

    public PlaceHolderDescription getPlaceholder() {
        return this.placeholder;
    }

    public boolean setPlaceholder(PlaceHolderDescription value) {
        boolean changed = false;
        if (this.placeholder != value) {
            PlaceHolderDescription oldValue = this.placeholder;
            if (this.placeholder != null) {
                this.placeholder = null;
                oldValue.withoutMatches(this);
            }
            this.placeholder = value;
            if (value != null) {
                value.withMatches(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PLACEHOLDER, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Match withPlaceholder(PlaceHolderDescription value) {
        this.setPlaceholder(value);
        return this;
    }

    public PlaceHolderDescription createPlaceholder() {
        PlaceHolderDescription value = new PlaceHolderDescription();
        this.withPlaceholder(value);
        return value;
    }

    public MatchSet getSubMatches() {
        if (this.subMatches == null) {
            return EMPTY_SET;
        }
        return this.subMatches;
    }

    public boolean addToSubMatches(Match value) {
        boolean changed = false;
        if (value != null) {
            if (this.subMatches == null) {
                this.subMatches = new MatchSet();
            }
            if (changed = this.subMatches.add(value)) {
                value.withParentMatch(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SUBMATCHES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromSubMatches(Match value) {
        boolean changed = false;
        if (this.subMatches != null && value != null && (changed = this.subMatches.remove(value))) {
            value.setParentMatch(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SUBMATCHES, value, null);
        }
        return changed;
    }

    public Match withSubMatches(Match ... value) {
        for (Match item : value) {
            this.addToSubMatches(item);
        }
        return this;
    }

    public Match withoutSubMatches(Match ... value) {
        for (Match item : value) {
            this.removeFromSubMatches(item);
        }
        return this;
    }

    public void removeAllFromSubMatches() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getSubMatches());
        for (Match value : tmpSet) {
            this.removeFromSubMatches(value);
        }
    }

    public Match createSubMatches() {
        Match value = new Match();
        this.withSubMatches(value);
        return value;
    }

    public Match getParentMatch() {
        return this.parentMatch;
    }

    public boolean setParentMatch(Match value) {
        boolean changed = false;
        if (this.parentMatch != value) {
            Match oldValue = this.parentMatch;
            if (this.parentMatch != null) {
                this.parentMatch = null;
                oldValue.withoutSubMatches(this);
            }
            this.parentMatch = value;
            if (value != null) {
                value.withSubMatches(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARENTMATCH, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Match withParentMatch(Match value) {
        this.setParentMatch(value);
        return this;
    }

    public Match createParentMatch() {
        Match value = new Match();
        this.withParentMatch(value);
        return value;
    }

    public MatchSet getSubMatchesTransitive() {
        MatchSet result = new MatchSet().with(this);
        return result.getSubMatchesTransitive();
    }

    public MatchSet getParentMatchTransitive() {
        MatchSet result = new MatchSet().with(this);
        return result.getParentMatchTransitive();
    }
}

