/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.transformations;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.models.transformations.Match;
import org.sdmlib.models.transformations.PlaceHolderDescription;
import org.sdmlib.models.transformations.Template;
import org.sdmlib.models.transformations.util.TemplateSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ChoiceTemplate
extends Template
implements PropertyChangeInterface {
    public static final String PROPERTY_CHOICES = "choices";
    private TemplateSet choices = null;

    @Override
    public Match parseOnce() {
        Iterator iterator = this.getChoices().iterator();
        while (iterator.hasNext()) {
            Template altTemplate = (Template)iterator.next();
            Match match = altTemplate.withExpandedText(this.getExpandedText()).withValueStartPos(this.currentPosInExpandedText).withIdMap(this.idMap).withConstFragmentFollowingAfterList(this.constFragmentFollowingAfterList).withList(this.getListStart(), this.getListSeparator(), this.getListEnd()).parseOnce();
            if (match == null) continue;
            this.currentPosInExpandedText = altTemplate.currentPosInExpandedText;
            this.setModelObject(altTemplate.getModelObject());
            return match;
        }
        return null;
    }

    @Override
    public void removeYou() {
        this.setChooser(null);
        this.withoutPlaceholders((PlaceHolderDescription[])this.getPlaceholders().toArray(new PlaceHolderDescription[this.getPlaceholders().size()]));
        this.withoutChoices((Template[])this.getChoices().toArray(new Template[this.getChoices().size()]));
        this.withoutMatches((Match[])this.getMatches().toArray(new Match[this.getMatches().size()]));
        this.withoutParents((PlaceHolderDescription[])this.getParents().toArray(new PlaceHolderDescription[this.getParents().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
        super.removeYou();
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTemplateText());
        s.append(" ").append(this.getExpandedText());
        s.append(" ").append(this.getModelClassName());
        s.append(" ").append(this.getListStart());
        s.append(" ").append(this.getListSeparator());
        s.append(" ").append(this.getListEnd());
        s.append(" ").append(this.getName());
        return s.substring(1);
    }

    public TemplateSet getChoices() {
        if (this.choices == null) {
            return Template.EMPTY_SET;
        }
        return this.choices;
    }

    public boolean addToChoices(Template value) {
        boolean changed = false;
        if (value != null) {
            if (this.choices == null) {
                this.choices = new TemplateSet();
            }
            if (changed = this.choices.add(value)) {
                value.withChooser(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHOICES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromChoices(Template value) {
        boolean changed = false;
        if (this.choices != null && value != null && (changed = this.choices.remove(value))) {
            value.setChooser(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CHOICES, value, null);
        }
        return changed;
    }

    public ChoiceTemplate withChoices(Template ... value) {
        for (Template item : value) {
            this.addToChoices(item);
        }
        return this;
    }

    public ChoiceTemplate withoutChoices(Template ... value) {
        for (Template item : value) {
            this.removeFromChoices(item);
        }
        return this;
    }

    public void removeAllFromChoices() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getChoices());
        for (Template value : tmpSet) {
            this.removeFromChoices(value);
        }
    }

    public Template createChoices() {
        Template value = new Template();
        this.withChoices(value);
        return value;
    }

    public Template createChoicesChoiceTemplate() {
        ChoiceTemplate value = new ChoiceTemplate();
        this.withChoices(value);
        return value;
    }

    public ChoiceTemplate createChoiceTemplate() {
        ChoiceTemplate value = new ChoiceTemplate();
        this.withChoices(value);
        return value;
    }
}

