/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.taskflows;

import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeSet;
import org.sdmlib.models.taskflows.PeerProxy;
import org.sdmlib.models.taskflows.util.PeerProxySet;
import org.sdmlib.models.taskflows.util.TaskFlowSet;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.serialization.SDMLibJsonIdMap;

public abstract class TaskFlow
extends TimerTask
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_IDMAP = "idMap";
    protected SDMLibJsonIdMap idMap;
    public static final String PROPERTY_TASKNO = "taskNo";
    protected int taskNo;
    public static final String PROPERTY_SUBFLOW = "subFlow";
    private TaskFlow subFlow = null;
    public static final String PROPERTY_PARENT = "parent";
    private TaskFlow parent = null;

    public abstract Object[] getTaskNames();

    public void switchTo(PeerProxy fileServer) {
        ++this.taskNo;
        fileServer.transferTaskFlow(this.getRootParent());
    }

    public void switchToThisAnd(PeerProxy peer) {
        ++this.taskNo;
        peer.transferTaskFlow(this.getRootParent());
        this.run();
    }

    public void switchTo(PeerProxySet peers) {
        ++this.taskNo;
        Iterator iterator = peers.iterator();
        while (iterator.hasNext()) {
            PeerProxy peer = (PeerProxy)iterator.next();
            peer.transferTaskFlow(this.getRootParent());
        }
    }

    public void switchTo(Timer timer) {
        ++this.taskNo;
        timer.schedule((TimerTask)this, 0L);
    }

    public void switchTo(int targetAction, PeerProxy peer, TreeSet<PeerProxy> proxies) {
        this.taskNo = targetAction;
        int i = 0;
        for (PeerProxy peerProxy : proxies) {
            if (peerProxy.equals(peer)) break;
            ++i;
        }
        if (i == proxies.size()) {
            throw new RuntimeException("no good, I should be in that list");
        }
        PeerProxy[] peerArray = proxies.toArray(new PeerProxy[0]);
        int tgt = (3 * i + 1) % proxies.size();
        peerArray[tgt].transferTaskFlow(this.getRootParent());
        tgt = (tgt + 1) % proxies.size();
        peerArray[tgt].transferTaskFlow(this.getRootParent());
        tgt = (tgt + 1) % proxies.size();
        peerArray[tgt].transferTaskFlow(this.getRootParent());
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.setSubFlow(null);
        this.setParent(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public SDMLibJsonIdMap getIdMap() {
        return this.idMap;
    }

    public void setIdMap(SDMLibJsonIdMap value) {
        if (this.idMap != value) {
            SDMLibJsonIdMap oldValue = this.idMap;
            this.idMap = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_IDMAP, oldValue, value);
        }
    }

    public TaskFlow withIdMap(SDMLibJsonIdMap value) {
        this.setIdMap(value);
        return this;
    }

    public int getTaskNo() {
        return this.taskNo;
    }

    public void setTaskNo(int value) {
        if (this.taskNo != value) {
            int oldValue = this.taskNo;
            this.taskNo = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TASKNO, oldValue, value);
        }
    }

    public TaskFlow withTaskNo(int value) {
        this.setTaskNo(value);
        return this;
    }

    public TaskFlow getSubFlow() {
        return this.subFlow;
    }

    public boolean setSubFlow(TaskFlow value) {
        boolean changed = false;
        if (this.subFlow != value) {
            TaskFlow oldValue = this.subFlow;
            if (this.subFlow != null) {
                this.subFlow = null;
                oldValue.setParent(null);
            }
            this.subFlow = value;
            if (value != null) {
                value.withParent(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SUBFLOW, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public TaskFlow withSubFlow(TaskFlow value) {
        this.setSubFlow(value);
        return this;
    }

    public TaskFlow createSubFlow() {
        return null;
    }

    public TaskFlow getRootParent() {
        TaskFlow root = this;
        while (root.getParent() != null) {
            root = root.getParent();
        }
        return root;
    }

    public TaskFlow getParent() {
        return this.parent;
    }

    public boolean setParent(TaskFlow value) {
        boolean changed = false;
        if (this.parent != value) {
            TaskFlow oldValue = this.parent;
            if (this.parent != null) {
                this.parent = null;
                oldValue.setSubFlow(null);
            }
            this.parent = value;
            if (value != null) {
                value.withSubFlow(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARENT, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public TaskFlow withParent(TaskFlow value) {
        this.setParent(value);
        return this;
    }

    public TaskFlow createParent() {
        return null;
    }

    public boolean isDone() {
        return false;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTaskNo());
        return s.substring(1);
    }

    public TaskFlowSet getSubFlowTransitive() {
        TaskFlowSet result = new TaskFlowSet().with(this);
        return result.getSubFlowTransitive();
    }

    public TaskFlowSet getParentTransitive() {
        TaskFlowSet result = new TaskFlowSet().with(this);
        return result.getParentTransitive();
    }
}

