/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.taskflows;

import de.uniks.networkparser.json.JsonArray;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.sdmlib.StrUtil;
import org.sdmlib.models.taskflows.TaskFlow;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.serialization.SDMLibJsonIdMap;

public class PeerProxy
implements PropertyChangeInterface,
Comparable<PeerProxy> {
    private Socket socket = null;
    private OutputStreamWriter out = null;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_IP = "ip";
    private String ip;
    public static final String PROPERTY_PORT = "port";
    private int port;
    public static final String PROPERTY_IDMAP = "idMap";
    private SDMLibJsonIdMap idMap;

    public PeerProxy() {
    }

    public PeerProxy(String ip, int port, SDMLibJsonIdMap map) {
        this.withIp(ip).withPort(port).withIdMap(map);
        map.put(ip + "." + port, this);
    }

    public void transferTaskFlow(TaskFlow taskFlow) {
        try {
            if (this.socket == null || !this.socket.isConnected()) {
                this.socket = new Socket(this.ip, this.port);
                this.out = new OutputStreamWriter(this.socket.getOutputStream());
            }
            JsonArray jsonArray = this.idMap.toJsonArray(taskFlow);
            this.out.write(jsonArray.toString() + "\n");
            this.out.flush();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public Socket getSocket() {
        return this.socket;
    }

    public Object get(String attrName) {
        int pos = attrName.indexOf(46);
        String attribute = attrName;
        if (pos > 0) {
            attribute = attrName.substring(0, pos);
        }
        if (PROPERTY_IP.equalsIgnoreCase(attribute)) {
            return this.getIp();
        }
        if (PROPERTY_PORT.equalsIgnoreCase(attribute)) {
            return this.getPort();
        }
        if (PROPERTY_IDMAP.equalsIgnoreCase(attribute)) {
            return this.getIdMap();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_IP.equalsIgnoreCase(attrName)) {
            this.setIp((String)value);
            return true;
        }
        if (PROPERTY_PORT.equalsIgnoreCase(attrName)) {
            this.setPort(Integer.parseInt(value.toString()));
            return true;
        }
        if (PROPERTY_IDMAP.equalsIgnoreCase(attrName)) {
            this.setIdMap((SDMLibJsonIdMap)value);
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getIp() {
        return this.ip;
    }

    public void setIp(String value) {
        if (!StrUtil.stringEquals(this.ip, value)) {
            String oldValue = this.ip;
            this.ip = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_IP, oldValue, value);
        }
    }

    public PeerProxy withIp(String value) {
        this.setIp(value);
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int value) {
        if (this.port != value) {
            int oldValue = this.port;
            this.port = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PORT, oldValue, value);
        }
    }

    public PeerProxy withPort(int value) {
        this.setPort(value);
        return this;
    }

    public SDMLibJsonIdMap getIdMap() {
        return this.idMap;
    }

    public void setIdMap(SDMLibJsonIdMap value) {
        if (this.idMap != value) {
            SDMLibJsonIdMap oldValue = this.idMap;
            this.idMap = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_IDMAP, oldValue, value);
        }
    }

    public PeerProxy withIdMap(SDMLibJsonIdMap value) {
        this.setIdMap(value);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getIp());
        s.append(" ").append(this.getPort());
        return "" + this.ip + ":" + this.port;
    }

    @Override
    public int compareTo(PeerProxy o) {
        int result = this.getIp().compareTo(o.getIp());
        if (result == 0) {
            if (this.getPort() > o.getPort()) {
                return 1;
            }
            if (this.getPort() < o.getPort()) {
                return -1;
            }
            return 0;
        }
        return result;
    }
}

