/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.taskflows;

import de.uniks.networkparser.json.JsonArray;
import java.io.File;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.doc.GraphFactory;
import org.sdmlib.models.taskflows.LogEntry;
import org.sdmlib.models.taskflows.PeerProxy;
import org.sdmlib.models.taskflows.TaskFlow;
import org.sdmlib.models.taskflows.util.LogEntrySet;
import org.sdmlib.models.taskflows.util.LoggerSet;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.storyboards.StoryboardManager;

public class Logger
extends TaskFlow
implements PropertyChangeInterface {
    public static final String PROPERTY_ENTRIES = "entries";
    private LogEntrySet entries = null;
    public static final LoggerSet EMPTY_SET = new LoggerSet();
    public static final String PROPERTY_STARTPEER = "startPeer";
    private PeerProxy startPeer;

    @Override
    public Object[] getTaskNames() {
        return TaskNames.values();
    }

    @Override
    public void run() {
        switch (TaskNames.values()[this.taskNo]) {
            case Start: {
                LogEntry previousEntry = null;
                if (!this.getEntries().isEmpty()) {
                    Iterator entryIt = this.getEntries().iterator();
                    while (entryIt.hasNext()) {
                        previousEntry = (LogEntry)entryIt.next();
                    }
                }
                LogEntry newEntry = this.createEntries().withNodeName(this.getSubFlow().getIdMap().getCounter().getPrefixId()).withTaskName(this.getSubFlow().getTaskNames()[this.getSubFlow().getTaskNo()].toString());
                if (previousEntry != null) {
                    newEntry.withParent(previousEntry);
                }
                boolean lastAction = this.getSubFlow().getTaskNo() + 1 >= this.getSubFlow().getTaskNames().length;
                this.getSubFlow().run();
                if (!lastAction) break;
                this.switchTo(this.startPeer);
                break;
            }
            case Collect: {
                JsonArray jsonArray = this.getSubFlow().getIdMap().toJsonArray(this);
                StoryboardManager.printFile(new File("doc/Logger.json"), jsonArray.toString(3));
                this.dumpDiagram();
                break;
            }
        }
    }

    private void dumpDiagram() {
        GraphFactory.getAdapter().dumpSwimlanes(this.getSubFlow().getClass().getSimpleName(), this.getEntries());
    }

    @Override
    public void removeYou() {
        this.removeAllFromEntries();
        this.setSubFlow(null);
        this.setParent(null);
        this.withoutEntries((LogEntry[])this.getEntries().toArray(new LogEntry[this.getEntries().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
        super.removeYou();
    }

    public LogEntrySet getEntries() {
        if (this.entries == null) {
            return new LogEntrySet();
        }
        return this.entries;
    }

    public boolean addToEntries(LogEntry value) {
        boolean changed = false;
        if (value != null) {
            if (this.entries == null) {
                this.entries = new LogEntrySet();
            }
            if (changed = this.entries.add(value)) {
                value.withLogger(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENTRIES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromEntries(LogEntry value) {
        boolean changed = false;
        if (this.entries != null && value != null && (changed = this.entries.remove(value))) {
            value.setLogger(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENTRIES, value, null);
        }
        return changed;
    }

    public Logger withEntries(LogEntry value) {
        this.addToEntries(value);
        return this;
    }

    public Logger withoutEntries(LogEntry value) {
        this.removeFromEntries(value);
        return this;
    }

    public void removeAllFromEntries() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getEntries());
        for (LogEntry value : tmpSet) {
            this.removeFromEntries(value);
        }
    }

    public LogEntry createEntries() {
        LogEntry value = new LogEntry();
        this.withEntries(value);
        return value;
    }

    public PeerProxy getStartPeer() {
        return this.startPeer;
    }

    public void setStartPeer(PeerProxy value) {
        if (this.startPeer != value) {
            PeerProxy oldValue = this.startPeer;
            this.startPeer = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STARTPEER, oldValue, value);
        }
    }

    public Logger withStartPeer(PeerProxy value) {
        this.setStartPeer(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTaskNo());
        return s.substring(1);
    }

    public Logger withEntries(LogEntry ... value) {
        if (value == null) {
            return this;
        }
        for (LogEntry item : value) {
            boolean changed;
            if (item == null) continue;
            if (this.entries == null) {
                this.entries = new LogEntrySet();
            }
            if (!(changed = this.entries.add(item))) continue;
            item.withLogger(this);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENTRIES, null, item);
        }
        return this;
    }

    public Logger withoutEntries(LogEntry ... value) {
        for (LogEntry item : value) {
            if (this.entries == null || item == null || !this.entries.remove(item)) continue;
            item.setLogger(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ENTRIES, item, null);
        }
        return this;
    }

    static enum TaskNames {
        Start,
        Collect;

    }
}

