/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.taskflows;

import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.sdmlib.StrUtil;
import org.sdmlib.models.taskflows.PeerProxy;
import org.sdmlib.models.taskflows.TaskFlow;
import org.sdmlib.serialization.PropertyChangeInterface;
import org.sdmlib.serialization.SDMLibJsonIdMap;

public class FetchFileFlow
extends TaskFlow
implements PropertyChangeInterface {
    private OutputStream out = null;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_FILESERVER = "fileServer";
    private PeerProxy fileServer;
    public static final String PROPERTY_FILENAME = "fileName";
    private String fileName;

    @Override
    public Object[] getTaskNames() {
        return TaskNames.values();
    }

    @Override
    public void run() {
        switch (TaskNames.values()[this.taskNo]) {
            case StartAtClient: {
                this.switchTo(this.fileServer);
                try {
                    InputStream socketIn = this.fileServer.getSocket().getInputStream();
                    byte[] buffer = new byte[4096];
                    FileOutputStream fileOut = new FileOutputStream(this.fileName + ".received");
                    int socketRead = 0;
                    while ((socketRead = socketIn.read(buffer)) >= 0) {
                        fileOut.write(buffer, 0, socketRead);
                    }
                    fileOut.close();
                    System.out.println("removing file: " + new File(this.fileName).getAbsolutePath());
                    new File(this.fileName).renameTo(new File(this.fileName + ".old"));
                    new File(this.fileName + ".old").delete();
                    new File(this.fileName + ".received").renameTo(new File(this.fileName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
            case StartAtFileServer: {
                try {
                    FileInputStream fileIn = new FileInputStream(this.fileName);
                    byte[] buffer = new byte[4096];
                    int bytesRead = 0;
                    while ((bytesRead = fileIn.read(buffer)) >= 0) {
                        this.out.write(buffer, 0, bytesRead);
                    }
                    this.out.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                break;
            }
        }
    }

    public OutputStream getOut() {
        return this.out;
    }

    public void setOut(OutputStream out) {
        this.out = out;
    }

    public Object get(String attrName) {
        int pos = attrName.indexOf(46);
        String attribute = attrName;
        if (pos > 0) {
            attribute = attrName.substring(0, pos);
        }
        if (PROPERTY_FILESERVER.equalsIgnoreCase(attribute)) {
            return this.getFileServer();
        }
        if ("idMap".equalsIgnoreCase(attribute)) {
            return this.getIdMap();
        }
        if (PROPERTY_FILENAME.equalsIgnoreCase(attribute)) {
            return this.getFileName();
        }
        if ("taskNo".equalsIgnoreCase(attribute)) {
            return this.getTaskNo();
        }
        return null;
    }

    public boolean set(String attrName, Object value) {
        if (PROPERTY_FILESERVER.equalsIgnoreCase(attrName)) {
            this.setFileServer((PeerProxy)value);
            return true;
        }
        if ("idMap".equalsIgnoreCase(attrName)) {
            this.setIdMap((SDMLibJsonIdMap)value);
            return true;
        }
        if (PROPERTY_FILENAME.equalsIgnoreCase(attrName)) {
            this.setFileName((String)value);
            return true;
        }
        if ("taskNo".equalsIgnoreCase(attrName)) {
            this.setTaskNo(Integer.parseInt(value.toString()));
            return true;
        }
        return false;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    @Override
    public void removeYou() {
        this.setSubFlow(null);
        this.setParent(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
        super.removeYou();
    }

    public PeerProxy getFileServer() {
        return this.fileServer;
    }

    public void setFileServer(PeerProxy value) {
        if (this.fileServer != value) {
            PeerProxy oldValue = this.fileServer;
            this.fileServer = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FILESERVER, oldValue, value);
        }
    }

    public FetchFileFlow withFileServer(PeerProxy value) {
        this.setFileServer(value);
        return this;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String value) {
        if (!StrUtil.stringEquals(this.fileName, value)) {
            String oldValue = this.fileName;
            this.fileName = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_FILENAME, oldValue, value);
        }
    }

    public FetchFileFlow withFileName(String value) {
        this.setFileName(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getFileName());
        s.append(" ").append(this.getTaskNo());
        return s.substring(1);
    }

    static enum TaskNames {
        StartAtClient,
        StartAtFileServer;

    }
}

