/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import java.beans.PropertyChangeSupport;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.TreeMap;
import org.sdmlib.models.pattern.ReachabilityGraph;
import org.sdmlib.models.pattern.RuleApplication;
import org.sdmlib.models.pattern.util.ReachableStateSet;
import org.sdmlib.models.pattern.util.RuleApplicationSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ReachableState
implements PropertyChangeInterface {
    private String certificate = null;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final ReachableStateSet EMPTY_SET = new ReachableStateSet();
    public static final String PROPERTY_PARENT = "parent";
    private ReachabilityGraph parent = null;
    public static final String PROPERTY_MASTER = "master";
    private ReachabilityGraph master = null;
    private TreeMap<String, String> certificates2nodes;
    private HashMap<String, String> node2certificates;
    public static final String PROPERTY_GRAPHROOT = "graphRoot";
    private Object graphRoot;
    public static final String PROPERTY_NUMBER = "number";
    private long number;
    public static final String PROPERTY_RULEAPPLICATIONS = "ruleapplications";
    private RuleApplicationSet ruleapplications = null;
    public static final String PROPERTY_RESULTOF = "resultOf";
    private RuleApplicationSet resultOf = null;

    public String getCertificate() {
        return this.certificate;
    }

    public void setCertificate(String certificate) {
        this.certificate = certificate;
    }

    public String computeCertificate(JsonIdMap map) {
        StringBuffer buf;
        this.certificate = null;
        long category = 1L;
        HashMap<Object, Object> oldnode2certificates = new HashMap<String, String>();
        long oldNumOfCertificates = 0L;
        this.node2certificates = new HashMap();
        JsonArray jsonArray = map.toJsonArray(this.getGraphRoot());
        for (Object o : jsonArray) {
            JsonObject jsonObj = (JsonObject)o;
            String string = jsonObj.getString((Object)"id");
            oldnode2certificates.put(string, "#" + string.charAt(2));
        }
        boolean stopNextRound = false;
        while (true) {
            String certificate;
            for (Object o : jsonArray) {
                JsonObject jsonObject = (JsonObject)o;
                String id = jsonObject.getString((Object)"id");
                jsonObject.remove((Object)"id");
                JsonObject propObj = jsonObject.getJsonObject("prop");
                Iterator iter = propObj.keyIterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Object value = propObj.get((Object)key);
                    if (value instanceof JsonObject) {
                        JsonObject ref = (JsonObject)value;
                        if (ref.get((Object)"id") == null) continue;
                        ref.withValue(new String[]{"id", (String)oldnode2certificates.get(ref.getString((Object)"id"))});
                        continue;
                    }
                    if (!(value instanceof JsonArray)) continue;
                    JsonArray refArray = (JsonArray)value;
                    for (Object ao : refArray) {
                        JsonObject ref = (JsonObject)ao;
                        if (ref.get((Object)"id") == null) continue;
                        ref.withValue(new String[]{"id", (String)oldnode2certificates.get(ref.getString((Object)"id"))});
                    }
                    Collections.sort(refArray, new JsonIdCompare());
                }
                this.node2certificates.put(id, jsonObject.toString(2));
            }
            this.certificates2nodes = new TreeMap();
            for (Map.Entry<String, String> e : this.node2certificates.entrySet()) {
                String string = (String)e.getKey();
                certificate = (String)e.getValue();
                String oldNodeList = this.certificates2nodes.get(certificate);
                oldNodeList = oldNodeList != null ? oldNodeList + " " + string : string;
                this.certificates2nodes.put(certificate, oldNodeList);
            }
            if (stopNextRound || (long)this.certificates2nodes.size() <= oldNumOfCertificates || this.certificates2nodes.size() == jsonArray.size()) {
                if (stopNextRound) {
                    buf = new StringBuffer();
                    for (Map.Entry entry : this.certificates2nodes.entrySet()) {
                        certificate = (String)entry.getKey();
                        String nodeList = (String)entry.getValue();
                        long noOfNodes = this.countBlanks(nodeList) + 1L;
                        buf.append(certificate).append('*').append(noOfNodes).append('\n');
                    }
                    break;
                }
                stopNextRound = true;
            }
            for (Map.Entry<String, String> e : this.certificates2nodes.entrySet()) {
                String string = e.getValue();
                String[] split = string.split(" ");
                String catString = "#" + category;
                for (String n : split) {
                    this.node2certificates.put(n, catString);
                }
                ++category;
            }
            oldNumOfCertificates = this.certificates2nodes.size();
            oldnode2certificates = this.node2certificates;
            jsonArray = map.toJsonArray(this.getGraphRoot());
            this.node2certificates = new LinkedHashMap<String, String>();
        }
        this.certificate = buf.toString();
        return this.certificate;
    }

    private long countBlanks(String str) {
        long num = 0L;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) != ' ') continue;
            ++num;
        }
        return num;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.setParent(null);
        this.removeAllFromRuleapplications();
        this.removeAllFromResultOf();
        this.setMaster(null);
        this.withoutRuleapplications((RuleApplication[])this.getRuleapplications().toArray(new RuleApplication[this.getRuleapplications().size()]));
        this.withoutResultOf((RuleApplication[])this.getResultOf().toArray(new RuleApplication[this.getResultOf().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public ReachabilityGraph getParent() {
        return this.parent;
    }

    public boolean setParent(ReachabilityGraph value) {
        boolean changed = false;
        if (this.parent != value) {
            ReachabilityGraph oldValue = this.parent;
            if (this.parent != null) {
                this.parent = null;
                oldValue.withoutStates(this);
            }
            this.parent = value;
            if (value != null) {
                value.withStates(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PARENT, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public ReachableState withParent(ReachabilityGraph value) {
        this.setParent(value);
        return this;
    }

    public ReachabilityGraph createParent() {
        ReachabilityGraph value = new ReachabilityGraph();
        this.withParent(value);
        return value;
    }

    public HashMap<String, String> getNode2certificates() {
        return this.node2certificates;
    }

    public ReachabilityGraph getMaster() {
        return this.master;
    }

    public boolean setMaster(ReachabilityGraph value) {
        boolean changed = false;
        if (this.master != value) {
            ReachabilityGraph oldValue = this.master;
            if (this.master != null) {
                this.master = null;
                oldValue.withoutTodo(this);
            }
            this.master = value;
            if (value != null) {
                value.withTodo(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MASTER, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public ReachableState withMaster(ReachabilityGraph value) {
        this.setMaster(value);
        return this;
    }

    public ReachabilityGraph createMaster() {
        ReachabilityGraph value = new ReachabilityGraph();
        this.withMaster(value);
        return value;
    }

    public Object getGraphRoot() {
        return this.graphRoot;
    }

    public void setGraphRoot(Object value) {
        if (this.graphRoot != value) {
            Object oldValue = this.graphRoot;
            this.graphRoot = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_GRAPHROOT, oldValue, value);
        }
    }

    public ReachableState withGraphRoot(Object value) {
        this.setGraphRoot(value);
        return this;
    }

    public long getNumber() {
        return this.number;
    }

    public void setNumber(long value) {
        if (this.number != value) {
            long oldValue = this.number;
            this.number = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NUMBER, oldValue, value);
        }
    }

    public ReachableState withNumber(long value) {
        this.setNumber(value);
        return this;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getNumber());
        return s.substring(1);
    }

    public RuleApplicationSet getRuleapplications() {
        if (this.ruleapplications == null) {
            return RuleApplication.EMPTY_SET;
        }
        return this.ruleapplications;
    }

    public boolean addToRuleapplications(RuleApplication value) {
        boolean changed = false;
        if (value != null) {
            if (this.ruleapplications == null) {
                this.ruleapplications = new RuleApplicationSet();
            }
            if (changed = this.ruleapplications.add(value)) {
                value.withSrc(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RULEAPPLICATIONS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromRuleapplications(RuleApplication value) {
        boolean changed = false;
        if (this.ruleapplications != null && value != null && (changed = this.ruleapplications.remove(value))) {
            value.setSrc(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RULEAPPLICATIONS, value, null);
        }
        return changed;
    }

    public ReachableState withRuleapplications(RuleApplication value) {
        this.addToRuleapplications(value);
        return this;
    }

    public ReachableState withoutRuleapplications(RuleApplication value) {
        this.removeFromRuleapplications(value);
        return this;
    }

    public void removeAllFromRuleapplications() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getRuleapplications());
        for (RuleApplication value : tmpSet) {
            this.removeFromRuleapplications(value);
        }
    }

    public RuleApplication createRuleapplications() {
        RuleApplication value = new RuleApplication();
        this.withRuleapplications(value);
        return value;
    }

    public RuleApplicationSet getResultOf() {
        if (this.resultOf == null) {
            return RuleApplication.EMPTY_SET;
        }
        return this.resultOf;
    }

    public boolean addToResultOf(RuleApplication value) {
        boolean changed = false;
        if (value != null) {
            if (this.resultOf == null) {
                this.resultOf = new RuleApplicationSet();
            }
            if (changed = this.resultOf.add(value)) {
                value.withTgt(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RESULTOF, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromResultOf(RuleApplication value) {
        boolean changed = false;
        if (this.resultOf != null && value != null && (changed = this.resultOf.remove(value))) {
            value.setTgt(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RESULTOF, value, null);
        }
        return changed;
    }

    public ReachableState withResultOf(RuleApplication value) {
        this.addToResultOf(value);
        return this;
    }

    public ReachableState withoutResultOf(RuleApplication value) {
        this.removeFromResultOf(value);
        return this;
    }

    public void removeAllFromResultOf() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getResultOf());
        for (RuleApplication value : tmpSet) {
            this.removeFromResultOf(value);
        }
    }

    public RuleApplication createResultOf() {
        RuleApplication value = new RuleApplication();
        this.withResultOf(value);
        return value;
    }

    public ReachableState withRuleapplications(RuleApplication ... value) {
        if (value == null) {
            return this;
        }
        for (RuleApplication item : value) {
            this.addToRuleapplications(item);
        }
        return this;
    }

    public ReachableState withoutRuleapplications(RuleApplication ... value) {
        for (RuleApplication item : value) {
            this.removeFromRuleapplications(item);
        }
        return this;
    }

    public ReachableState withResultOf(RuleApplication ... value) {
        if (value == null) {
            return this;
        }
        for (RuleApplication item : value) {
            this.addToResultOf(item);
        }
        return this;
    }

    public ReachableState withoutResultOf(RuleApplication ... value) {
        for (RuleApplication item : value) {
            this.removeFromResultOf(item);
        }
        return this;
    }

    private class JsonIdCompare
    implements Comparator<Object> {
        private JsonIdCompare() {
        }

        @Override
        public int compare(Object o1, Object o2) {
            JsonObject jo1 = (JsonObject)o1;
            JsonObject jo2 = (JsonObject)o2;
            return jo1.getString((Object)"id").compareTo(jo2.getString((Object)"id"));
        }
    }
}

