/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.Filter;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import de.uniks.networkparser.logic.Condition;
import de.uniks.networkparser.logic.ConditionMap;
import de.uniks.networkparser.logic.ValuesMap;
import java.beans.PropertyChangeSupport;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.TreeMap;
import org.sdmlib.doc.GraphFactory;
import org.sdmlib.doc.interfaze.Adapter.GuiAdapter;
import org.sdmlib.models.pattern.NegativeApplicationCondition;
import org.sdmlib.models.pattern.OptionalSubPattern;
import org.sdmlib.models.pattern.Pattern;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.models.pattern.ReachableState;
import org.sdmlib.models.pattern.util.PatternSet;
import org.sdmlib.models.pattern.util.ReachableStateSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class ReachabilityGraph
implements PropertyChangeInterface {
    private GuiAdapter adapter;
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_STATES = "states";
    private TreeMap<String, Object> stateMap = new TreeMap();
    private static ReachableStateSet emptyStatesSet = new ReachableStateSet();
    private ReachableStateSet oneElemSet = new ReachableStateSet();
    private ReachableStateSet states = null;
    public static final String PROPERTY_TODO = "todo";
    private ReachableStateSet todo = null;
    public static final String PROPERTY_RULES = "rules";
    private PatternSet rules = null;
    private long noOfNewStates;
    private JsonIdMap masterMap = null;

    public String dumpDiagram(String name) {
        OmitRootCondition conditionMap = new OmitRootCondition(this);
        Filter filter = new Filter().withFull(true).withPropertyRegard((Condition)conditionMap);
        JsonArray jsonArray = this.masterMap.toJsonArray((Object)this, filter);
        String imgLink = this.getAdapter().toImg(name, jsonArray);
        Iterator iterator = this.getStates().getGraphRoot().iterator();
        while (iterator.hasNext()) {
            Object graphRoot = iterator.next();
            JsonArray graphRootArray = this.masterMap.toJsonArray(graphRoot);
            String rootId = this.masterMap.getId(graphRoot);
            String imgName = name + "/" + rootId;
            String subLink = this.getAdapter().toImg(imgName, graphRootArray);
        }
        return imgLink;
    }

    public GuiAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = GraphFactory.getAdapter();
        }
        return this.adapter;
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.removeAllFromStates();
        this.removeAllFromTodo();
        this.removeAllFromRules();
        this.withoutStates((ReachableState[])this.getStates().toArray(new ReachableState[this.getStates().size()]));
        this.withoutTodo((ReachableState[])this.getTodo().toArray(new ReachableState[this.getTodo().size()]));
        this.withoutRules((Pattern[])this.getRules().toArray(new Pattern[this.getRules().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public ReachabilityGraph withStateMap(String certificate, ReachableState newState) {
        Object oldEntry = this.stateMap.get(certificate);
        if (oldEntry == null) {
            this.stateMap.put(certificate, newState);
        } else if (oldEntry instanceof ReachableState && oldEntry != newState) {
            ReachableStateSet newStateSet = new ReachableStateSet().with((ReachableState)oldEntry).with(newState);
            this.stateMap.put(certificate, newStateSet);
        } else {
            ReachableStateSet oldStateSet = (ReachableStateSet)oldEntry;
            oldStateSet.with(newState);
        }
        return this;
    }

    public ReachableStateSet getStateMap(String certificate) {
        Object oldEntry = this.stateMap.get(certificate);
        if (oldEntry == null) {
            return emptyStatesSet;
        }
        if (oldEntry instanceof ReachableState) {
            this.oneElemSet.clear();
            this.oneElemSet.add((ReachableState)oldEntry);
            return this.oneElemSet;
        }
        return (ReachableStateSet)oldEntry;
    }

    public ReachableStateSet getStates() {
        if (this.states == null) {
            return ReachableState.EMPTY_SET;
        }
        return this.states;
    }

    public boolean addToStates(ReachableState value) {
        boolean changed = false;
        if (value != null) {
            if (this.states == null) {
                this.states = new ReachableStateSet();
            }
            if (changed = this.states.add(value)) {
                value.withParent(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STATES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromStates(ReachableState value) {
        boolean changed = false;
        if (this.states != null && value != null && (changed = this.states.remove(value))) {
            value.setParent(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_STATES, value, null);
        }
        return changed;
    }

    public ReachabilityGraph withStates(ReachableState value) {
        this.addToStates(value);
        return this;
    }

    public ReachabilityGraph withoutStates(ReachableState value) {
        this.removeFromStates(value);
        return this;
    }

    public void removeAllFromStates() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getStates());
        for (ReachableState value : tmpSet) {
            this.removeFromStates(value);
        }
    }

    public ReachableState createStates() {
        ReachableState value = new ReachableState();
        this.withStates(value);
        return value;
    }

    public ReachableStateSet getTodo() {
        if (this.todo == null) {
            return ReachableState.EMPTY_SET;
        }
        return this.todo;
    }

    public boolean addToTodo(ReachableState value) {
        boolean changed = false;
        if (value != null) {
            if (this.todo == null) {
                this.todo = new ReachableStateSet();
            }
            if (changed = this.todo.add(value)) {
                value.withMaster(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TODO, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromTodo(ReachableState value) {
        boolean changed = false;
        if (this.todo != null && value != null && (changed = this.todo.remove(value))) {
            value.setMaster(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TODO, value, null);
        }
        return changed;
    }

    public ReachabilityGraph withTodo(ReachableState value) {
        this.addToTodo(value);
        return this;
    }

    public ReachabilityGraph withoutTodo(ReachableState value) {
        this.removeFromTodo(value);
        return this;
    }

    public void removeAllFromTodo() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getTodo());
        for (ReachableState value : tmpSet) {
            this.removeFromTodo(value);
        }
    }

    public ReachableState createTodo() {
        ReachableState value = new ReachableState();
        this.withTodo(value);
        return value;
    }

    public PatternSet getRules() {
        if (this.rules == null) {
            return Pattern.EMPTY_SET;
        }
        return this.rules;
    }

    public boolean addToRules(Pattern value) {
        boolean changed = false;
        if (value != null) {
            if (this.rules == null) {
                this.rules = new PatternSet();
            }
            if (changed = this.rules.add(value)) {
                value.withRgraph(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RULES, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromRules(Pattern value) {
        boolean changed = false;
        if (this.rules != null && value != null && (changed = this.rules.remove(value))) {
            value.setRgraph(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RULES, value, null);
        }
        return changed;
    }

    public ReachabilityGraph withRules(Pattern value) {
        this.addToRules(value);
        return this;
    }

    public ReachabilityGraph withoutRules(Pattern value) {
        this.removeFromRules(value);
        return this;
    }

    public void removeAllFromRules() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getRules());
        for (Pattern value : tmpSet) {
            this.removeFromRules(value);
        }
    }

    public Pattern createRules() {
        Pattern value = new Pattern();
        this.withRules(value);
        return value;
    }

    public long explore() {
        return this.explore(Long.MAX_VALUE);
    }

    public long explore(long maxNoOfNewStates) {
        long currentStateNum = 1L;
        this.noOfNewStates = 0L;
        while (!this.getTodo().isEmpty() && this.noOfNewStates < maxNoOfNewStates) {
            ReachableState first = this.getTodo().first();
            first.withNumber((int)currentStateNum);
            ++currentStateNum;
            this.withoutTodo(first);
            Iterator iterator = this.getRules().iterator();
            while (iterator.hasNext()) {
                Pattern rule = (Pattern)iterator.next();
                PatternObject firstPO = (PatternObject)rule.getElements().first();
                rule.resetSearch();
                ((PatternObject)firstPO.withModifier("bound")).setCurrentMatch(first.getGraphRoot());
                while (rule.findMatch()) {
                    Object newGraphRoot = firstPO.getCurrentMatch();
                    ReachableState newReachableState = new ReachableState().withGraphRoot(newGraphRoot);
                    JsonIdMap newJsonIdMap = (JsonIdMap)new JsonIdMap().withCreator((Iterable)rule.getJsonIdMap());
                    newJsonIdMap.withSessionId("s");
                    String newCertificate = newReachableState.computeCertificate(newJsonIdMap);
                    ReachableStateSet candidateStates = this.getStateMap(newCertificate);
                    LinkedHashMap<String, String> match = null;
                    Iterator iterator2 = candidateStates.iterator();
                    while (iterator2.hasNext()) {
                        ReachableState oldState = (ReachableState)iterator2.next();
                        match = this.match(oldState, newReachableState);
                        if (match == null) continue;
                        first.createRuleapplications().withDescription("" + rule.getName()).withTgt(oldState);
                        break;
                    }
                    if (match != null) continue;
                    this.withStates(newReachableState).withTodo(newReachableState).withStateMap(newCertificate, newReachableState);
                    first.createRuleapplications().withDescription("" + rule.getName()).withTgt(newReachableState);
                }
            }
        }
        return currentStateNum;
    }

    public LinkedHashMap<String, String> match(ReachableState s1, ReachableState s2) {
        String key;
        JsonObject jo;
        JsonIdMap map1 = (JsonIdMap)new JsonIdMap().withCreator((Iterable)this.masterMap);
        JsonIdMap map2 = (JsonIdMap)new JsonIdMap().withCreator((Iterable)this.masterMap);
        map1.withSessionId("s");
        map2.withSessionId("s");
        LinkedHashMap<String, String> fwdmapping = new LinkedHashMap<String, String>();
        LinkedHashMap<String, String> bwdmapping = new LinkedHashMap<String, String>();
        String key1 = map1.getId(s1.getGraphRoot());
        String key2 = map2.getId(s2.getGraphRoot());
        fwdmapping.put(key1, key2);
        bwdmapping.put(key2, key1);
        JsonArray ja1 = map1.toJsonArray(s1.getGraphRoot());
        JsonArray ja2 = map2.toJsonArray(s2.getGraphRoot());
        LinkedHashMap<String, JsonObject> joMap1 = null;
        LinkedHashMap<String, JsonObject> joMap2 = null;
        joMap1 = new LinkedHashMap<String, JsonObject>();
        for (Object object : ja1) {
            jo = (JsonObject)object;
            key = jo.getString((Object)"id");
            joMap1.put(key, jo);
        }
        joMap2 = new LinkedHashMap<String, JsonObject>();
        for (Object object : ja2) {
            jo = (JsonObject)object;
            key = jo.getString((Object)"id");
            joMap2.put(key, jo);
        }
        boolean match = this.match(s1, ja1, joMap1, s2, ja2, joMap2, key1, fwdmapping, bwdmapping);
        return match ? fwdmapping : null;
    }

    public boolean match(ReachableState s1, JsonArray ja1, LinkedHashMap<String, JsonObject> joMap1, ReachableState s2, JsonArray ja2, LinkedHashMap<String, JsonObject> joMap2, String cn1, LinkedHashMap<String, String> fwdmapping, LinkedHashMap<String, String> bwdmapping) {
        String cn2 = fwdmapping.get(cn1);
        JsonObject currentJo1 = joMap1.get(cn1);
        JsonObject currentJo2 = joMap2.get(cn2);
        JsonObject currentProps1 = currentJo1.getJsonObject("prop");
        JsonObject currentProps2 = currentJo2.getJsonObject("prop");
        Iterator iter = currentProps1.keyIterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            Object value = currentProps1.get((Object)key);
            if (value instanceof JsonObject) {
                JsonObject ref = (JsonObject)value;
                String tgt1 = ref.getString((Object)"id");
                String tgt2 = currentProps2.getJsonObject(key).getString((Object)"id");
                String mappingOfTgt1 = fwdmapping.get(tgt1);
                if (mappingOfTgt1 != null) {
                    if (tgt2.equals(mappingOfTgt1)) continue;
                    return false;
                }
                fwdmapping.put(tgt1, tgt2);
                bwdmapping.put(tgt2, tgt1);
                boolean match = this.match(s1, ja1, joMap1, s2, ja2, joMap2, tgt1, fwdmapping, bwdmapping);
                if (match) continue;
                fwdmapping.remove(tgt1);
                bwdmapping.remove(tgt2);
                continue;
            }
            if (!(value instanceof JsonArray)) continue;
            block1: for (Object object : (JsonArray)value) {
                String tgt2;
                JsonObject ref = (JsonObject)object;
                String tgt1 = ref.getString((Object)"id");
                String tgt1Map = fwdmapping.get(tgt1);
                if (tgt1Map != null) {
                    for (Object o : currentProps2.getJsonArray(key)) {
                        ref = (JsonObject)o;
                        tgt2 = ref.getString((Object)"id");
                        if (!tgt2.equals(tgt1Map)) continue;
                        continue block1;
                    }
                    return false;
                }
                for (Object o : currentProps2.getJsonArray(key)) {
                    String cert2;
                    String cert1;
                    ref = (JsonObject)o;
                    tgt2 = ref.getString((Object)"id");
                    if (bwdmapping.get(tgt2) != null || !(cert1 = s1.getNode2certificates().get(tgt1)).equals(cert2 = s2.getNode2certificates().get(tgt2))) continue;
                    fwdmapping.put(tgt1, tgt2);
                    bwdmapping.put(tgt2, tgt1);
                    boolean match = this.match(s1, ja1, joMap1, s2, ja2, joMap2, tgt1, fwdmapping, bwdmapping);
                    if (match) continue block1;
                    fwdmapping.remove(tgt1);
                    bwdmapping.remove(tgt2);
                }
                return false;
            }
        }
        return true;
    }

    public JsonIdMap getMasterMap() {
        return this.masterMap;
    }

    public void setMasterMap(JsonIdMap newMasterMap) {
        this.masterMap = newMasterMap;
    }

    public ReachabilityGraph withMasterMap(JsonIdMap map) {
        this.setMasterMap(map);
        return this;
    }

    public ReachabilityGraph withStates(ReachableState ... value) {
        if (value == null) {
            return this;
        }
        for (ReachableState item : value) {
            this.addToStates(item);
        }
        return this;
    }

    public ReachabilityGraph withoutStates(ReachableState ... value) {
        for (ReachableState item : value) {
            this.removeFromStates(item);
        }
        return this;
    }

    public ReachabilityGraph withTodo(ReachableState ... value) {
        if (value == null) {
            return this;
        }
        for (ReachableState item : value) {
            this.addToTodo(item);
        }
        return this;
    }

    public ReachabilityGraph withoutTodo(ReachableState ... value) {
        for (ReachableState item : value) {
            this.removeFromTodo(item);
        }
        return this;
    }

    public ReachabilityGraph withRules(Pattern ... value) {
        if (value == null) {
            return this;
        }
        for (Pattern item : value) {
            this.addToRules(item);
        }
        return this;
    }

    public ReachabilityGraph withoutRules(Pattern ... value) {
        for (Pattern item : value) {
            this.removeFromRules(item);
        }
        return this;
    }

    public Pattern createRulesNegativeApplicationCondition() {
        NegativeApplicationCondition value = new NegativeApplicationCondition();
        this.withRules((Pattern)value);
        return value;
    }

    public Pattern createRulesOptionalSubPattern() {
        OptionalSubPattern value = new OptionalSubPattern();
        this.withRules((Pattern)value);
        return value;
    }

    public NegativeApplicationCondition createNegativeApplicationCondition() {
        NegativeApplicationCondition value = new NegativeApplicationCondition();
        this.withRules((Pattern)value);
        return value;
    }

    public OptionalSubPattern createOptionalSubPattern() {
        OptionalSubPattern value = new OptionalSubPattern();
        this.withRules((Pattern)value);
        return value;
    }

    private final class OmitRootCondition
    extends ConditionMap {
        private Object root;

        public OmitRootCondition(Object root) {
            this.root = root;
        }

        public boolean check(ValuesMap values) {
            return values.value != this.root;
        }
    }
}

