/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.logic.Condition;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.CGUtil;
import org.sdmlib.models.pattern.AttributeConstraint;
import org.sdmlib.models.pattern.CardinalityConstraint;
import org.sdmlib.models.pattern.DestroyObjectElem;
import org.sdmlib.models.pattern.GenericConstraint;
import org.sdmlib.models.pattern.LinkConstraint;
import org.sdmlib.models.pattern.MatchOtherThen;
import org.sdmlib.models.pattern.NegativeApplicationCondition;
import org.sdmlib.models.pattern.OptionalSubPattern;
import org.sdmlib.models.pattern.Pattern;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternLink;
import org.sdmlib.models.pattern.util.AttributeConstraintSet;
import org.sdmlib.models.pattern.util.CardinalityConstraintSet;
import org.sdmlib.models.pattern.util.MatchOtherThenSet;
import org.sdmlib.models.pattern.util.PatternLinkSet;
import org.sdmlib.serialization.EntityFactory;

public class PatternObject<POC, MC>
extends PatternElement<POC> {
    public static final String PROPERTY_ATTRCONSTRAINTS = "attrConstraints";
    public static final String PROPERTY_CANDIDATES = "candidates";
    public static final String PROPERTY_CARDCONSTRAINTS = "cardConstraints";
    public static final String PROPERTY_CURRENTMATCH = "currentMatch";
    public static final String PROPERTY_DESTROYELEM = "destroyElem";
    public static final String PROPERTY_EXCLUDERS = "excluders";
    public static final String PROPERTY_INCOMMING = "incomming";
    public static final String PROPERTY_MATCHOTHERTHEN = "matchOtherThen";
    public static final String PROPERTY_OUTGOING = "outgoing";
    private PatternLinkSet outgoing = null;
    private MatchOtherThenSet matchOtherThen = null;
    private PatternLinkSet incomming = null;
    private MatchOtherThenSet excluders = null;
    private DestroyObjectElem destroyElem = null;
    private Object currentMatch;
    private CardinalityConstraintSet cardConstraints = null;
    private Object candidates;
    private AttributeConstraintSet attrConstraints = null;
    private boolean matchAsSet = false;
    private Iterator<Object> candidatesIterator;

    protected void newInstance(JsonIdMap map) {
        Pattern pattern = new Pattern(map);
        pattern.addToElements(this);
    }

    protected void newInstance(JsonIdMap map, Object[] hostGraphObject) {
        Pattern pattern = new Pattern(map);
        pattern.addToElements(this);
        if (hostGraphObject.length > 1) {
            this.withCandidates(Arrays.asList(hostGraphObject));
        } else {
            this.withCurrentMatch(hostGraphObject[0]);
            this.withModifier("bound");
        }
        pattern.findMatch();
    }

    public <POSC extends PatternObject> POSC instanceOf(POSC subclassPO) {
        this.hasLink("instanceof", subclassPO);
        return subclassPO;
    }

    public boolean rebind(MC o) {
        return this.getPattern().rebind(this, o);
    }

    public POC nextMatch() {
        this.getPattern().findNextMatch();
        return (POC)this;
    }

    public POC matchAsSet() {
        this.matchAsSet = true;
        this.setCurrentMatch(this.getCandidates());
        this.setCandidates(null);
        return (POC)this;
    }

    @Override
    public boolean findNextMatch() {
        if ("create".equals(this.getModifier())) {
            if (!this.getPattern().getHasMatch()) {
                return false;
            }
            if (this.getHasMatch()) {
                this.setHasMatch(false);
                return false;
            }
            String className = this.getClass().getName();
            className = className.replace(".util.", ".");
            className = className.substring(0, className.length() - 2);
            SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreator(className, true);
            if (creatorClass == null) {
                className = CGUtil.packageName(className) + ".impl." + CGUtil.shortClassName(className) + "Impl";
                creatorClass = this.getPattern().getJsonIdMap().getCreator(className, true);
            }
            Object sendableInstance = creatorClass.getSendableInstance(false);
            this.setCurrentMatch(sendableInstance);
            this.setHasMatch(true);
            if (this.getTopPattern().getDebugMode() >= 1) {
                String shortClassName = CGUtil.shortClassName(className);
                this.getTopPattern().addLogMsg("" + this.getLHSPatternObjectName() + " = new " + shortClassName + "(); // " + this.getPattern().getJsonIdMap().getId(sendableInstance));
            }
            return true;
        }
        if ("bound".equals(this.getModifier())) {
            if (!this.getPattern().getHasMatch()) {
                return false;
            }
            if (this.getHasMatch()) {
                this.setHasMatch(false);
                return false;
            }
            this.setHasMatch(this.getCurrentMatch() != null);
            return this.getHasMatch();
        }
        if (!this.getPattern().getHasMatch()) {
            return false;
        }
        if (this.getCandidates() == null || this.getCandidates() instanceof Collection && ((Collection)this.getCandidates()).isEmpty()) {
            this.setHasMatch(false);
            return false;
        }
        boolean resultStat = false;
        if (this.getCandidates() instanceof Collection && !this.matchAsSet) {
            if (this.candidatesIterator == null) {
                this.candidatesIterator = ((Collection)this.getCandidates()).iterator();
            }
            if (this.candidatesIterator.hasNext()) {
                Object obj = this.candidatesIterator.next();
                this.setCurrentMatch(obj);
                this.setHasMatch(true);
                resultStat = true;
                if (this.getTopPattern().getDebugMode() >= 1) {
                    String tgtVar = this.getLHSPatternObjectName();
                    this.getTopPattern().addLogMsg(tgtVar + " = " + this.getPatternObjectName() + "Candidates.removeFirst(); // " + this.getTopPattern().getJsonIdMap().getId(obj) + " " + obj + " <- " + this.valueSetString(this.getCandidates()));
                }
            } else {
                this.setCurrentMatch(null);
                this.setHasMatch(false);
                resultStat = false;
            }
        } else {
            this.setCurrentMatch(this.getCandidates());
            this.setCandidates(null);
            this.setHasMatch(true);
            resultStat = true;
        }
        if ("destroy".equals(this.getModifier()) && this.getCurrentMatch() != null) {
            MC currentMatch = this.getCurrentMatch();
            EntityFactory creatorClass = (EntityFactory)this.getPattern().getJsonIdMap().getCreatorClass(currentMatch);
            creatorClass.removeObject(currentMatch);
        }
        return resultStat;
    }

    public String getLHSPatternObjectName() {
        LinkedHashSet<String> variablesAlreadyInTrace;
        String lhsName = this.getPatternObjectName();
        if (this.getPattern() != null && !(variablesAlreadyInTrace = this.getTopPattern().getVariablesAlreadyInTrace()).contains(lhsName)) {
            variablesAlreadyInTrace.add(lhsName);
            lhsName = this.getCurrentMatch().getClass().getSimpleName() + " " + lhsName;
        }
        return lhsName;
    }

    @Override
    public void resetSearch() {
        if (!"bound".equals(this.getModifier())) {
            this.setCandidates(null);
            this.setCurrentMatch(null);
        }
        this.candidatesIterator = null;
        this.setHasMatch(false);
    }

    public POC startCreate() {
        this.getPattern().startCreate();
        return (POC)this;
    }

    public POC endCreate() {
        this.getPattern().endCreate();
        return (POC)this;
    }

    public POC startDestroy() {
        this.getPattern().startDestroy();
        return (POC)this;
    }

    public POC endDestroy() {
        this.getPattern().endCreate();
        return (POC)this;
    }

    public POC startNAC() {
        NegativeApplicationCondition nac = new NegativeApplicationCondition();
        this.getPattern().addToElements(nac);
        if (this.getTopPattern().getDebugMode() >= 1) {
            nac.setPatternObjectName("n" + this.getTopPattern().getPatternObjectCount());
        }
        return (POC)this;
    }

    public POC endNAC() {
        Pattern<PatternElement<?>> directPattern = this.getPattern();
        while (directPattern.getCurrentSubPattern() != null) {
            directPattern = directPattern.getCurrentSubPattern();
        }
        if (directPattern instanceof NegativeApplicationCondition) {
            directPattern = directPattern.getPattern();
        }
        directPattern.setCurrentSubPattern(null);
        directPattern.findMatch();
        return (POC)this;
    }

    public POC startSubPattern() {
        OptionalSubPattern optionalSubPattern = new OptionalSubPattern();
        this.getPattern().addToElements(optionalSubPattern);
        if (this.getTopPattern().getDebugMode() >= 1) {
            optionalSubPattern.setPatternObjectName("o" + this.getTopPattern().getPatternObjectCount());
            this.getTopPattern().addLogMsg("// start subpattern " + optionalSubPattern.getPatternObjectName());
        }
        return (POC)this;
    }

    public POC endSubPattern() {
        Pattern<PatternElement<?>> directPattern = this.getPattern();
        while (directPattern.getCurrentSubPattern() != null) {
            directPattern = directPattern.getCurrentSubPattern();
        }
        if (directPattern instanceof OptionalSubPattern) {
            directPattern = directPattern.getPattern();
        }
        directPattern.setCurrentSubPattern(null);
        return (POC)this;
    }

    public POC doAllMatches() {
        this.getPattern().setDoAllMatches(true);
        this.setDoAllMatches(true);
        while (this.getPattern().getHasMatch()) {
            if (this.getTopPattern().getDebugMode() >= 1) {
                this.getTopPattern().addLogMsg("// " + this.getPattern().getPatternObjectName() + " allMatches?");
            }
            this.getPattern().findMatch();
        }
        return (POC)this;
    }

    public POC destroy() {
        DestroyObjectElem destroyObjectElem = (DestroyObjectElem)new DestroyObjectElem().withPatternObject(this).withPattern(this.getPattern());
        this.getPattern().findMatch();
        return (POC)this;
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.removeAllFromIncomming();
        this.removeAllFromOutgoing();
        this.removeAllFromAttrConstraints();
        this.setDestroyElem(null);
        this.setPattern(null);
        this.removeAllFromCardConstraints();
        this.removeAllFromMatchOtherThen();
        this.removeAllFromExcluders();
        this.withoutAttrConstraints((AttributeConstraint[])this.getAttrConstraints().toArray(new AttributeConstraint[this.getAttrConstraints().size()]));
        this.withoutCardConstraints((CardinalityConstraint[])this.getCardConstraints().toArray(new CardinalityConstraint[this.getCardConstraints().size()]));
        this.withoutMatchOtherThen((MatchOtherThen[])this.getMatchOtherThen().toArray(new MatchOtherThen[this.getMatchOtherThen().size()]));
        this.withoutExcluders((MatchOtherThen[])this.getExcluders().toArray(new MatchOtherThen[this.getExcluders().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public MC getCurrentMatch() {
        return (MC)this.currentMatch;
    }

    public void setCurrentMatch(Object value) {
        if (this.currentMatch != value) {
            Object oldValue = this.currentMatch;
            this.currentMatch = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CURRENTMATCH, oldValue, value);
        }
    }

    public PatternObject withCurrentMatch(Object value) {
        this.setCurrentMatch(value);
        return this;
    }

    public PatternLinkSet getIncomming() {
        if (this.incomming == null) {
            return PatternLink.EMPTY_SET;
        }
        return this.incomming;
    }

    public boolean addToIncomming(PatternLink value) {
        boolean changed = false;
        if (value != null) {
            if (this.incomming == null) {
                this.incomming = new PatternLinkSet();
            }
            if (changed = this.incomming.add(value)) {
                value.withTgt(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INCOMMING, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromIncomming(PatternLink value) {
        boolean changed = false;
        if (this.incomming != null && value != null && (changed = this.incomming.remove(value))) {
            value.setTgt(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INCOMMING, value, null);
        }
        return changed;
    }

    public PatternObject withIncomming(PatternLink value) {
        this.addToIncomming(value);
        return this;
    }

    public PatternObject withoutIncomming(PatternLink value) {
        this.removeFromIncomming(value);
        return this;
    }

    public void removeAllFromIncomming() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getIncomming());
        for (PatternLink value : tmpSet) {
            this.removeFromIncomming(value);
        }
    }

    public PatternLinkSet getOutgoing() {
        if (this.outgoing == null) {
            return PatternLink.EMPTY_SET;
        }
        return this.outgoing;
    }

    public boolean addToOutgoing(PatternLink value) {
        boolean changed = false;
        if (value != null) {
            if (this.outgoing == null) {
                this.outgoing = new PatternLinkSet();
            }
            if (changed = this.outgoing.add(value)) {
                value.withSrc(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OUTGOING, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromOutgoing(PatternLink value) {
        boolean changed = false;
        if (this.outgoing != null && value != null && (changed = this.outgoing.remove(value))) {
            value.setSrc(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OUTGOING, value, null);
        }
        return changed;
    }

    public PatternObject withOutgoing(PatternLink value) {
        this.addToOutgoing(value);
        return this;
    }

    public PatternObject withoutOutgoing(PatternLink value) {
        this.removeFromOutgoing(value);
        return this;
    }

    public void removeAllFromOutgoing() {
    }

    public Object getCandidates() {
        return this.candidates;
    }

    public void setCandidates(Object value) {
        if (this.candidates != value) {
            Object oldValue = this.candidates;
            this.candidates = value;
            this.candidatesIterator = null;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CANDIDATES, oldValue, value);
        }
    }

    public PatternObject withCandidates(Object value) {
        this.setCandidates(value);
        return this;
    }

    public AttributeConstraintSet getAttrConstraints() {
        if (this.attrConstraints == null) {
            return AttributeConstraint.EMPTY_SET;
        }
        return this.attrConstraints;
    }

    public boolean addToAttrConstraints(AttributeConstraint value) {
        boolean changed = false;
        if (value != null) {
            if (this.attrConstraints == null) {
                this.attrConstraints = new AttributeConstraintSet();
            }
            if (changed = this.attrConstraints.add(value)) {
                value.withSrc(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRCONSTRAINTS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromAttrConstraints(AttributeConstraint value) {
        boolean changed = false;
        if (this.attrConstraints != null && value != null && (changed = this.attrConstraints.remove(value))) {
            value.setSrc(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRCONSTRAINTS, value, null);
        }
        return changed;
    }

    public PatternObject withAttrConstraints(AttributeConstraint value) {
        this.addToAttrConstraints(value);
        return this;
    }

    public PatternObject withoutAttrConstraints(AttributeConstraint value) {
        this.removeFromAttrConstraints(value);
        return this;
    }

    public void removeAllFromAttrConstraints() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getAttrConstraints());
        for (AttributeConstraint value : tmpSet) {
            this.removeFromAttrConstraints(value);
        }
    }

    public void hasLink(String roleName, PatternObject result) {
        if ("create".equals(this.getPattern().getModifier())) {
            this.getPattern().addToElements(result);
            this.getPattern().findMatch();
            LinkConstraint patternLink = (LinkConstraint)new LinkConstraint().withTgt(result).withTgtRoleName(roleName).withSrc(this).withModifier(this.getPattern().getModifier());
            this.getPattern().addToElements(patternLink);
            patternLink.getPattern().findMatch();
        } else {
            PatternLink patternLink = new PatternLink().withTgt(result).withTgtRoleName(roleName).withSrc(this);
            patternLink.setModifier(this.getPattern().getModifier());
            this.getPattern().addToElements(patternLink);
            this.getPattern().addToElements(result);
            result.getPattern().findMatch();
        }
    }

    protected void hasAttr() {
        if (!this.getPattern().findMatch()) {
            this.setCurrentMatch(null);
        }
    }

    public POC has(Condition<Object> condition, String text) {
        GenericConstraint genericConstraint = (GenericConstraint)((GenericConstraint)new GenericConstraint().withText(text).withSrc(this).withCondition(condition).withModifier(this.getPattern().getModifier())).withPattern(this.getPattern());
        this.getPattern().findMatch();
        return (POC)this;
    }

    public POC has(Condition<Object> condition) {
        GenericConstraint genericConstraint = (GenericConstraint)((GenericConstraint)new GenericConstraint().withCondition(condition).withSrc(this).withModifier(this.getPattern().getModifier())).withPattern(this.getPattern());
        this.getPattern().findMatch();
        return (POC)this;
    }

    public DestroyObjectElem getDestroyElem() {
        return this.destroyElem;
    }

    public boolean setDestroyElem(DestroyObjectElem value) {
        boolean changed = false;
        if (this.destroyElem != value) {
            DestroyObjectElem oldValue = this.destroyElem;
            if (this.destroyElem != null) {
                this.destroyElem = null;
                oldValue.setPatternObject(null);
            }
            this.destroyElem = value;
            if (value != null) {
                value.withPatternObject(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_DESTROYELEM, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public PatternObject withDestroyElem(DestroyObjectElem value) {
        this.setDestroyElem(value);
        return this;
    }

    DestroyObjectElem createDestroyElem() {
        DestroyObjectElem value = new DestroyObjectElem();
        this.withDestroyElem(value);
        return value;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        return s.substring(1);
    }

    public CardinalityConstraintSet getCardConstraints() {
        if (this.cardConstraints == null) {
            return CardinalityConstraint.EMPTY_SET;
        }
        return this.cardConstraints;
    }

    public boolean addToCardConstraints(CardinalityConstraint value) {
        boolean changed = false;
        if (value != null) {
            if (this.cardConstraints == null) {
                this.cardConstraints = new CardinalityConstraintSet();
            }
            if (changed = this.cardConstraints.add(value)) {
                value.withSrc(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CARDCONSTRAINTS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromCardConstraints(CardinalityConstraint value) {
        boolean changed = false;
        if (this.cardConstraints != null && value != null && (changed = this.cardConstraints.remove(value))) {
            value.setSrc(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CARDCONSTRAINTS, value, null);
        }
        return changed;
    }

    public PatternObject withCardConstraints(CardinalityConstraint value) {
        this.addToCardConstraints(value);
        return this;
    }

    public PatternObject withoutCardConstraints(CardinalityConstraint value) {
        this.removeFromCardConstraints(value);
        return this;
    }

    public void removeAllFromCardConstraints() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getCardConstraints());
        for (CardinalityConstraint value : tmpSet) {
            this.removeFromCardConstraints(value);
        }
    }

    CardinalityConstraint createCardConstraints() {
        CardinalityConstraint value = new CardinalityConstraint();
        this.withCardConstraints(value);
        return value;
    }

    public POC hasLinkConstraint(PatternObject tgt, String roleName) {
        if (tgt == null) {
            this.startNAC();
            PatternObject<POC, MC> result = new PatternObject<POC, MC>();
            result.setModifier(this.getPattern().getModifier());
            this.hasLink(roleName, result);
            this.endNAC();
        } else {
            LinkConstraint patternLink = (LinkConstraint)new LinkConstraint().withTgt(tgt).withTgtRoleName(roleName).withSrc(this).withModifier(this.getPattern().getModifier());
            this.getPattern().addToElements(patternLink);
            this.getPattern().findMatch();
        }
        return (POC)this;
    }

    public MatchOtherThenSet getMatchOtherThen() {
        if (this.matchOtherThen == null) {
            return MatchOtherThen.EMPTY_SET;
        }
        return this.matchOtherThen;
    }

    public boolean addToMatchOtherThen(MatchOtherThen value) {
        boolean changed = false;
        if (value != null) {
            if (this.matchOtherThen == null) {
                this.matchOtherThen = new MatchOtherThenSet();
            }
            if (changed = this.matchOtherThen.add(value)) {
                value.withSrc(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MATCHOTHERTHEN, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromMatchOtherThen(MatchOtherThen value) {
        boolean changed = false;
        if (this.matchOtherThen != null && value != null && (changed = this.matchOtherThen.remove(value))) {
            value.setSrc(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MATCHOTHERTHEN, value, null);
        }
        return changed;
    }

    public PatternObject withMatchOtherThen(MatchOtherThen value) {
        this.addToMatchOtherThen(value);
        return this;
    }

    public PatternObject withoutMatchOtherThen(MatchOtherThen value) {
        this.removeFromMatchOtherThen(value);
        return this;
    }

    public void removeAllFromMatchOtherThen() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getMatchOtherThen());
        for (MatchOtherThen value : tmpSet) {
            this.removeFromMatchOtherThen(value);
        }
    }

    MatchOtherThen createMatchOtherThen() {
        MatchOtherThen value = new MatchOtherThen();
        this.withMatchOtherThen(value);
        return value;
    }

    public POC hasMatchOtherThen(PatternObject forbidden) {
        MatchOtherThen otherThen = (MatchOtherThen)this.createMatchOtherThen().withForbidden(forbidden).withPattern(this.getPattern());
        this.getPattern().findMatch();
        return (POC)this;
    }

    public MatchOtherThenSet getExcluders() {
        if (this.excluders == null) {
            return MatchOtherThen.EMPTY_SET;
        }
        return this.excluders;
    }

    public boolean addToExcluders(MatchOtherThen value) {
        boolean changed = false;
        if (value != null) {
            if (this.excluders == null) {
                this.excluders = new MatchOtherThenSet();
            }
            if (changed = this.excluders.add(value)) {
                value.withForbidden(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_EXCLUDERS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromExcluders(MatchOtherThen value) {
        boolean changed = false;
        if (this.excluders != null && value != null && (changed = this.excluders.remove(value))) {
            value.setForbidden(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_EXCLUDERS, value, null);
        }
        return changed;
    }

    public PatternObject withExcluders(MatchOtherThen value) {
        this.addToExcluders(value);
        return this;
    }

    public PatternObject withoutExcluders(MatchOtherThen value) {
        this.removeFromExcluders(value);
        return this;
    }

    public void removeAllFromExcluders() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getExcluders());
        for (MatchOtherThen value : tmpSet) {
            this.removeFromExcluders(value);
        }
    }

    MatchOtherThen createExcluders() {
        MatchOtherThen value = new MatchOtherThen();
        this.withExcluders(value);
        return value;
    }

    public PatternObject withAttrConstraints(AttributeConstraint ... value) {
        if (value == null) {
            return this;
        }
        for (AttributeConstraint item : value) {
            this.addToAttrConstraints(item);
        }
        return this;
    }

    public PatternObject withoutAttrConstraints(AttributeConstraint ... value) {
        for (AttributeConstraint item : value) {
            this.removeFromAttrConstraints(item);
        }
        return this;
    }

    public AttributeConstraint createAttrConstraintsNew() {
        AttributeConstraint value = new AttributeConstraint();
        this.withAttrConstraints(value);
        return value;
    }

    public PatternObject withCardConstraints(CardinalityConstraint ... value) {
        if (value == null) {
            return this;
        }
        for (CardinalityConstraint item : value) {
            this.addToCardConstraints(item);
        }
        return this;
    }

    public PatternObject<?, ?> withoutCardConstraints(CardinalityConstraint ... value) {
        for (CardinalityConstraint item : value) {
            this.removeFromCardConstraints(item);
        }
        return this;
    }

    public PatternObject withMatchOtherThen(MatchOtherThen ... value) {
        for (MatchOtherThen item : value) {
            this.addToMatchOtherThen(item);
        }
        return this;
    }

    public PatternObject withoutMatchOtherThen(MatchOtherThen ... value) {
        for (MatchOtherThen item : value) {
            this.removeFromMatchOtherThen(item);
        }
        return this;
    }

    public PatternObject withExcluders(MatchOtherThen ... value) {
        if (value == null) {
            return this;
        }
        for (MatchOtherThen item : value) {
            this.addToExcluders(item);
        }
        return this;
    }

    public PatternObject withoutExcluders(MatchOtherThen ... value) {
        for (MatchOtherThen item : value) {
            this.removeFromExcluders(item);
        }
        return this;
    }

    public Object createAttrConstraints() {
        AttributeConstraint value = new AttributeConstraint();
        this.withAttrConstraints(value);
        return value;
    }
}

