/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.beans.PropertyChangeSupport;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.models.pattern.util.PatternLinkSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class PatternLink
extends PatternElement
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_SRCROLENAME = "srcRoleName";
    private String srcRoleName;
    public static final String PROPERTY_TGTROLENAME = "tgtRoleName";
    private String tgtRoleName;
    public static final String PROPERTY_TGT = "tgt";
    private PatternObject tgt = null;
    public static final PatternLinkSet EMPTY_SET = new PatternLinkSet();
    public static final String PROPERTY_SRC = "src";
    private PatternObject src = null;
    public static final String PROPERTY_HOSTGRAPHSRCOBJECT = "hostGraphSrcObject";
    private Object hostGraphSrcObject;

    @Override
    public boolean findNextMatch() {
        if (this.getHostGraphSrcObject() == null) {
            this.setHostGraphSrcObject(this.getSrc().getCurrentMatch());
            if (this.hostGraphSrcObject != null) {
                LinkedHashSet<String> variablesAlreadyInTrace;
                String setVarName;
                AbstractCollection value = null;
                if (this.tgtRoleName.equals("instanceof")) {
                    Class<?> hostGraphScrObjectClass = this.hostGraphSrcObject.getClass();
                    String fullTgtClassName = this.getTgt().getClass().getName();
                    fullTgtClassName = CGUtil.baseClassName(fullTgtClassName, "PO");
                    try {
                        Class<?> tgtPOClass = hostGraphScrObjectClass.getClassLoader().loadClass(fullTgtClassName);
                        if (tgtPOClass.isAssignableFrom(hostGraphScrObjectClass)) {
                            value = this.hostGraphSrcObject;
                        }
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                } else if (this.hostGraphSrcObject != null && this.hostGraphSrcObject instanceof Collection) {
                    LinkedHashSet<Object> tgtSet = new LinkedHashSet<Object>();
                    SendableEntityCreator creatorClass = null;
                    for (Object src : (Collection)this.hostGraphSrcObject) {
                        Object tgt;
                        if (creatorClass == null) {
                            creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(src);
                        }
                        if ((tgt = creatorClass.getValue(src, this.tgtRoleName)) instanceof Collection) {
                            tgtSet.addAll((Collection)tgt);
                            continue;
                        }
                        tgtSet.add(tgt);
                    }
                    value = tgtSet;
                } else {
                    SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(this.hostGraphSrcObject);
                    value = creatorClass.getValue(this.hostGraphSrcObject, this.tgtRoleName);
                    if (value != null && value instanceof Collection && !this.getTopPattern().getRiskConcurrentModification()) {
                        value = new ArrayList(value);
                    }
                }
                if (value != null && value instanceof Collection) {
                    this.getTgt().setCandidates(value);
                    if (this.getTopPattern().getDebugMode() >= 1) {
                        setVarName = this.getTgt().getPatternObjectName() + "Candidates";
                        variablesAlreadyInTrace = this.getTopPattern().getVariablesAlreadyInTrace();
                        if (!variablesAlreadyInTrace.contains(setVarName)) {
                            variablesAlreadyInTrace.add(setVarName);
                            setVarName = value.getClass().getSimpleName() + " " + setVarName;
                        }
                        this.getTopPattern().addLogMsg(setVarName + " = " + this.getSrc().getPatternObjectName() + ".get" + StrUtil.upFirstChar(this.tgtRoleName) + "(); // " + this.valueSetString(value));
                        if (((Collection)value).isEmpty()) {
                            this.getTopPattern().addLogMsg("// No candidates, backtrack!");
                        }
                    }
                } else {
                    this.getTgt().setCandidates(value);
                    if (this.getTopPattern().getDebugMode() >= 1) {
                        setVarName = this.getTgt().getPatternObjectName();
                        variablesAlreadyInTrace = this.getTopPattern().getVariablesAlreadyInTrace();
                        if (!variablesAlreadyInTrace.contains(setVarName)) {
                            variablesAlreadyInTrace.add(setVarName);
                            setVarName = value.getClass().getSimpleName() + " " + setVarName;
                        }
                        this.getTopPattern().addLogMsg(setVarName + " = " + this.getSrc().getPatternObjectName() + ".get" + StrUtil.upFirstChar(this.tgtRoleName) + "(); // " + this.getTopPattern().getJsonIdMap().getId(value) + " " + value);
                    }
                }
                return true;
            }
            return false;
        }
        this.setHostGraphSrcObject(null);
        return false;
    }

    @Override
    public void resetSearch() {
        this.setHostGraphSrcObject(null);
    }

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setTgt(null);
        this.setSrc(null);
        this.setPattern(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getSrcRoleName() {
        return this.srcRoleName;
    }

    public void setSrcRoleName(String value) {
        if (!StrUtil.stringEquals(this.srcRoleName, value)) {
            String oldValue = this.srcRoleName;
            this.srcRoleName = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SRCROLENAME, oldValue, value);
        }
    }

    public PatternLink withSrcRoleName(String value) {
        this.setSrcRoleName(value);
        return this;
    }

    public String getTgtRoleName() {
        return this.tgtRoleName;
    }

    public void setTgtRoleName(String value) {
        if (!StrUtil.stringEquals(this.tgtRoleName, value)) {
            String oldValue = this.tgtRoleName;
            this.tgtRoleName = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TGTROLENAME, oldValue, value);
        }
    }

    public PatternLink withTgtRoleName(String value) {
        this.setTgtRoleName(value);
        return this;
    }

    public PatternObject getTgt() {
        return this.tgt;
    }

    public boolean setTgt(PatternObject value) {
        boolean changed = false;
        if (this.tgt != value) {
            PatternObject oldValue = this.tgt;
            if (this.tgt != null) {
                this.tgt = null;
                oldValue.withoutIncomming(this);
            }
            this.tgt = value;
            if (value != null) {
                value.withIncomming(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TGT, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public PatternLink withTgt(PatternObject value) {
        this.setTgt(value);
        return this;
    }

    public PatternObject getSrc() {
        return this.src;
    }

    public boolean setSrc(PatternObject value) {
        boolean changed = false;
        if (this.src != value) {
            PatternObject oldValue = this.src;
            if (this.src != null) {
                this.src = null;
                oldValue.withoutOutgoing(this);
            }
            this.src = value;
            if (value != null) {
                value.withOutgoing(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SRC, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public PatternLink withSrc(PatternObject value) {
        this.setSrc(value);
        return this;
    }

    public Object getHostGraphSrcObject() {
        return this.hostGraphSrcObject;
    }

    public void setHostGraphSrcObject(Object value) {
        if (this.hostGraphSrcObject != value) {
            Object oldValue = this.hostGraphSrcObject;
            this.hostGraphSrcObject = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOSTGRAPHSRCOBJECT, oldValue, value);
        }
    }

    public PatternLink withHostGraphSrcObject(Object value) {
        this.setHostGraphSrcObject(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTgtRoleName());
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        return s.substring(1);
    }
}

