/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import java.io.File;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.sdmlib.CGUtil;
import org.sdmlib.StrUtil;
import org.sdmlib.doc.GraphFactory;
import org.sdmlib.doc.interfaze.Adapter.GuiAdapter;
import org.sdmlib.models.pattern.AttributeConstraint;
import org.sdmlib.models.pattern.CardinalityConstraint;
import org.sdmlib.models.pattern.CloneOp;
import org.sdmlib.models.pattern.DestroyObjectElem;
import org.sdmlib.models.pattern.GenericConstraint;
import org.sdmlib.models.pattern.LinkConstraint;
import org.sdmlib.models.pattern.Match;
import org.sdmlib.models.pattern.MatchIsomorphicConstraint;
import org.sdmlib.models.pattern.MatchOtherThen;
import org.sdmlib.models.pattern.NegativeApplicationCondition;
import org.sdmlib.models.pattern.OptionalSubPattern;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternLink;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.models.pattern.ReachabilityGraph;
import org.sdmlib.models.pattern.UnifyGraphsOp;
import org.sdmlib.models.pattern.util.PatternElementSet;
import org.sdmlib.models.pattern.util.PatternSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class Pattern<MP>
extends PatternElement<MP>
implements PropertyChangeInterface,
Iterable<Match> {
    public static final String CREATE = "create";
    public static final String DESTROY = "destroy";
    public static final String BOUND = "bound";
    private JsonIdMap jsonIdMap;
    private GuiAdapter adapter;
    private boolean restartSearchAtIndex0 = false;
    public static final String PROPERTY_ELEMENTS = "elements";
    private PatternElementSet elements = null;
    private int objNo;
    private GenericConstraint previousConstraint = null;
    public static final String PROPERTY_CURRENTSUBPATTERN = "currentSubPattern";
    private Pattern currentSubPattern;
    public static final String PROPERTY_DEBUGMODE = "debugMode";
    private int debugMode;
    private int patternObjectCount = 0;
    private LinkedHashSet<String> variablesAlreadyInTrace;
    public static final String PROPERTY_TRACE = "trace";
    private StringBuilder trace;
    public static int traceLength = 0;
    public static final PatternSet EMPTY_SET = new PatternSet();
    public static final String PROPERTY_RGRAPH = "rgraph";
    private ReachabilityGraph rgraph = null;
    public static final String PROPERTY_NAME = "name";
    private String name;
    private boolean riskConcurrentModification;

    public GuiAdapter getAdapter() {
        if (this.adapter == null) {
            this.adapter = GraphFactory.getAdapter();
        }
        return this.adapter;
    }

    public JsonIdMap getJsonIdMap() {
        return this.jsonIdMap;
    }

    public void setJsonIdMap(JsonIdMap jsonIdMap) {
        this.jsonIdMap = jsonIdMap;
    }

    public void clone(ReachabilityGraph rgraph) {
        CloneOp cloneOp = new CloneOp();
        this.withElements((PatternElement)cloneOp);
        this.findMatch();
    }

    public void unify(ReachabilityGraph rgraph) {
        UnifyGraphsOp unifyGraphsOp = new UnifyGraphsOp();
        this.withElements((PatternElement)unifyGraphsOp);
        this.findMatch();
    }

    public Pattern(JsonIdMap createIdMap) {
        this.jsonIdMap = createIdMap;
        this.setHasMatch(true);
    }

    public Pattern() {
        this.hasMatch = true;
    }

    public MP startCreate() {
        this.setModifier(CREATE);
        return (MP)this;
    }

    public MP endCreate() {
        this.setModifier(null);
        return (MP)this;
    }

    public MP startNAC() {
        NegativeApplicationCondition nac = new NegativeApplicationCondition();
        this.addToElements(nac);
        if (this.getTopPattern().getDebugMode() >= 1) {
            nac.setPatternObjectName("n" + this.getTopPattern().getPatternObjectCount());
        }
        return (MP)this;
    }

    public MP startDestroy() {
        this.setModifier(DESTROY);
        return (MP)this;
    }

    public MP endDestroy() {
        this.setModifier(null);
        return (MP)this;
    }

    public MP matchIsomorphic() {
        MatchIsomorphicConstraint isoConstraint = new MatchIsomorphicConstraint();
        this.addToElements(isoConstraint);
        this.findMatch();
        return (MP)this;
    }

    public int allMatches() {
        this.setDoAllMatches(true);
        int result = 0;
        while (this.getHasMatch()) {
            ++result;
            this.findMatch();
        }
        return result;
    }

    public boolean rebind(PatternObject boundObject, Object value) {
        boundObject.setCurrentMatch(value);
        this.resetSearch();
        return this.findMatch();
    }

    public boolean findMatch() {
        if (!this.getHasMatch()) {
            return false;
        }
        boolean done = false;
        int i = this.getElements().size() - 1;
        if (this.restartSearchAtIndex0) {
            this.restartSearchAtIndex0 = false;
            i = 0;
            if (this.getTopPattern().getDebugMode() >= 1) {
                this.getTopPattern().addLogMsg("\n     Restart pattern: ");
            }
        }
        PatternElement currentPE = null;
        while (i >= 0 && i < this.getElements().size()) {
            currentPE = (PatternElement)this.getElements().get(i);
            boolean hasNextMatch = currentPE.findNextMatch();
            if (hasNextMatch) {
                ++i;
                continue;
            }
            --i;
        }
        this.setHasMatch(i >= this.getElements().size());
        return this.getHasMatch();
    }

    @Override
    public boolean findNextMatch() {
        return this.findMatch();
    }

    @Override
    public void resetSearch() {
        this.restartSearchAtIndex0 = true;
        this.setHasMatch(true);
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            PatternElement pe = (PatternElement)iterator.next();
            pe.resetSearch();
        }
    }

    @Override
    public void removeYou() {
        this.removeAllFromElements();
        this.setPattern(null);
        this.setRgraph(null);
        this.withoutElements((PatternElement[])this.getElements().toArray(new PatternElement[this.getElements().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public PatternElementSet getElements() {
        if (this.elements == null) {
            return PatternElement.EMPTY_SET;
        }
        return this.elements;
    }

    public boolean addToElements(PatternElement value) {
        boolean changed = false;
        if (this.currentSubPattern != null) {
            changed = this.currentSubPattern.addToElements(value);
        } else if (value != null) {
            if (this.elements == null) {
                this.elements = new PatternElementSet();
            }
            if (!this.elements.contains(value)) {
                changed = this.elements.add(value);
                value.withPattern(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ELEMENTS, null, value);
                if (value instanceof PatternObject || value instanceof Pattern) {
                    this.getTopPattern().incrementPatternObjectCount();
                }
            }
            if (value instanceof Pattern) {
                this.setCurrentSubPattern((Pattern)value);
                ((Pattern)value).setJsonIdMap(this.getJsonIdMap());
            }
        }
        return changed;
    }

    public boolean removeFromElements(PatternElement value) {
        boolean changed = false;
        if (this.elements != null && value != null && (changed = this.elements.remove(value))) {
            value.setPattern(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ELEMENTS, value, null);
        }
        return changed;
    }

    public MP withElements(PatternElement value) {
        this.addToElements(value);
        return (MP)this;
    }

    public MP withoutElements(PatternElement value) {
        this.removeFromElements(value);
        return (MP)this;
    }

    public void removeAllFromElements() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getElements());
        for (PatternElement value : tmpSet) {
            this.removeFromElements(value);
        }
    }

    public String getPOClassName(String modelClassName) {
        int pos = modelClassName.lastIndexOf(46);
        return modelClassName.substring(0, pos + 1) + "creators." + modelClassName.substring(pos + 1, modelClassName.length()) + "PO";
    }

    public PatternObject bind(Object hostGraphObject) {
        SendableEntityCreator creatorClass = this.getJsonIdMap().getCreator(this.getPOClassName(hostGraphObject.getClass().getName()), true);
        PatternObject po = (PatternObject)creatorClass.getSendableInstance(false);
        this.addToElements(po);
        po.setCurrentMatch(hostGraphObject);
        return po;
    }

    public String dumpDiagram(String diagramName) {
        return this.dumpDiagram(diagramName, true);
    }

    public String dumpDiagram(String diagramName, boolean showMatch) {
        JsonObject result = new JsonObject();
        result.put((Object)"typ", (Object)"object");
        JsonArray nodes = new JsonArray();
        result.put((Object)"nodes", (Object)nodes);
        JsonArray edges = new JsonArray();
        result.put((Object)"edges", (Object)edges);
        LinkedHashMap<PatternObject, String> nameMap = new LinkedHashMap<PatternObject, String>();
        this.addNodesToDiagram(this.elements, nodes, nameMap);
        this.addEdgesToDiagram(this.elements, edges, nameMap);
        String text = "<script>\n   var json = " + result.toString(3) + "   ;\n" + "   json[\"options\"]={\"canvasid\":\"canvas" + diagramName + "\", " + "\"display\":\"html\", " + "\"fontsize\":10," + "\"bar\":true};" + "   var g = new Graph(json);\n" + "   g.layout(100,100);\n" + "</script>\n";
        return text;
    }

    private void addEdgesToDiagram(PatternElementSet elements, JsonArray edges, LinkedHashMap<PatternObject, String> nameMap) {
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            PatternElement elem = (PatternElement)iterator.next();
            if (elem instanceof PatternLink) {
                PatternLink link = (PatternLink)elem;
                PatternObject src = link.getSrc();
                PatternObject tgt = link.getTgt();
                JsonObject edge = new JsonObject();
                edges.add((Object)edge);
                edge.put((Object)"typ", (Object)"EDGE");
                JsonObject role = new JsonObject();
                edge.put((Object)"source", (Object)role);
                role.put((Object)"property", (Object)" ");
                role.put((Object)"id", (Object)nameMap.get(src));
                role = new JsonObject();
                edge.put((Object)"target", (Object)role);
                role.put((Object)"property", (Object)link.getTgtRoleName());
                role.put((Object)"id", (Object)nameMap.get(tgt));
                continue;
            }
            if (!(elem instanceof Pattern)) continue;
            Pattern subPattern = (Pattern)elem;
            this.addEdgesToDiagram(subPattern.getElements(), edges, nameMap);
        }
    }

    private void addNodesToDiagram(PatternElementSet elements, JsonArray nodes, LinkedHashMap<PatternObject, String> nameMap) {
        Iterator iterator = elements.iterator();
        while (iterator.hasNext()) {
            JsonObject node;
            PatternElement elem = (PatternElement)iterator.next();
            if (elem instanceof PatternObject) {
                PatternObject po = (PatternObject)elem;
                node = new JsonObject();
                node.put((Object)"typ", (Object)"patternObject");
                String shortClassName = CGUtil.shortClassName(po.getClass().getName());
                String firstChar = shortClassName.substring(0, 1).toLowerCase();
                int num = nameMap.size() + 1;
                String jsonId = firstChar + num + " : " + shortClassName;
                node.put((Object)"id", (Object)jsonId);
                nameMap.put(po, jsonId);
                JsonArray attrs = new JsonArray();
                if (num == 1) {
                    attrs.add((Object)"<< start >>");
                }
                if (po.getModifier() != null) {
                    attrs.add((Object)("<< " + po.getModifier() + ">>"));
                }
                Iterator iterator2 = po.getAttrConstraints().iterator();
                while (iterator2.hasNext()) {
                    AttributeConstraint attr = (AttributeConstraint)iterator2.next();
                    if (attr.getUpperTgtValue() != null) {
                        attrs.add((Object)("" + attr.getAttrName() + " in [" + attr.getTgtValue() + ".." + attr.getUpperTgtValue() + "]"));
                        continue;
                    }
                    attrs.add((Object)("" + attr.getAttrName() + " == " + attr.getTgtValue()));
                }
                node.put((Object)"attributes", (Object)attrs);
                nodes.add((Object)node);
                continue;
            }
            if (!(elem instanceof Pattern)) continue;
            Pattern subPattern = (Pattern)elem;
            node = new JsonObject();
            node.put((Object)"typ", (Object)"objectdiagram");
            node.put((Object)"style", (Object)"nac");
            node.put((Object)"info", (Object)CGUtil.shortClassName(subPattern.getClass().getName()));
            nodes.add((Object)node);
            JsonArray subNodes = new JsonArray();
            node.put((Object)"nodes", (Object)subNodes);
            this.addNodesToDiagram(subPattern.getElements(), subNodes, nameMap);
            System.out.println("");
        }
    }

    public String dumpDiagramOld(String diagramName, boolean showMatch) {
        Object allMatchesLine;
        this.objNo = 0;
        LinkedHashSet<Object> matchedObjects = new LinkedHashSet<Object>();
        String imgLink = "<embed type=\"image/svg+xml\"src='<imagename>'>\n".replaceFirst("<imagename>", diagramName + ".svg");
        String fileText = "graph ObjectDiagram {\n   node [shape = none, fontsize = 10, fontname = \"Arial\"];\n   edge [fontsize = 10, fontname = \"Arial\"];\n\n<nodes>\n<edges>}\n";
        StringBuilder nodeBuilder = new StringBuilder();
        StringBuilder edgeBuilder = new StringBuilder();
        this.dumpPatternObjects(nodeBuilder, edgeBuilder, showMatch, matchedObjects);
        if (this.getDoAllMatches()) {
            allMatchesLine = "allMatches;\n";
            nodeBuilder.append((String)allMatchesLine);
        }
        allMatchesLine = this.getElementsTransitive(null).iterator();
        while (allMatchesLine.hasNext()) {
            String srcRoleName;
            PatternElement patElem = (PatternElement)allMatchesLine.next();
            if (!(patElem instanceof PatternLink)) continue;
            PatternLink patLink = (PatternLink)patElem;
            String color = "black";
            if (CREATE.equals(patLink.getModifier())) {
                color = "green";
            } else if (DESTROY.equals(patLink.getModifier())) {
                color = "red";
            }
            StringBuilder oneEdgeLine = new StringBuilder("<srcId> -- <tgtId> [headlabel = \"headText\" taillabel = \"tailText\" color=\"black\" fontcolor=\"black\"];\n");
            String tgtRoleName = patLink.getTgtRoleName();
            if (tgtRoleName == null) {
                tgtRoleName = "";
            }
            if ((srcRoleName = patLink.getSrcRoleName()) == null) {
                srcRoleName = "";
            }
            CGUtil.replaceAll(oneEdgeLine, "<srcId>", this.nameForPatElem(patLink.getSrc()), "<tgtId>", this.nameForPatElem(patLink.getTgt()), "headText", tgtRoleName, "tailText", srcRoleName, "black", color);
            edgeBuilder.append(oneEdgeLine.toString());
        }
        if (showMatch && !matchedObjects.isEmpty()) {
            JsonArray jsonArray = this.getJsonIdMap().toJsonArray(matchedObjects.iterator().next());
            this.getAdapter().fillNodeAndEdgeBuilders(diagramName, jsonArray, nodeBuilder, edgeBuilder, false, new String[0]);
        }
        fileText = fileText.replaceFirst("<nodes>", nodeBuilder.toString());
        fileText = fileText.replaceFirst("<edges>", edgeBuilder.toString());
        this.dumpDiagram(diagramName, fileText);
        return imgLink;
    }

    public PatternElementSet getElementsTransitive(PatternElementSet result) {
        if (result == null) {
            result = new PatternElementSet();
        }
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            PatternElement patternElement = (PatternElement)iterator.next();
            boolean isNewElem = result.add(patternElement);
            if (!isNewElem || !(patternElement instanceof Pattern)) continue;
            result = ((Pattern)patternElement).getElementsTransitive(result);
        }
        return result;
    }

    public void dumpPatternObjects(StringBuilder nodeBuilder, StringBuilder edgeBuilder, boolean showMatch, LinkedHashSet<Object> matchedObjects) {
        this.previousConstraint = null;
        Iterator iterator = this.getElements().iterator();
        while (iterator.hasNext()) {
            StringBuilder dottedEdgeBuilder;
            StringBuilder cardConstrBuilder;
            StringBuilder destroyEdgeBuilder;
            PatternElement patElem = (PatternElement)iterator.next();
            if (patElem instanceof PatternObject) {
                Object matchEdge;
                PatternObject patObject = (PatternObject)patElem;
                StringBuilder nodeLine = new StringBuilder("<id> [label=<<table border='0' cellborder='1' cellspacing='0' color='black' bgcolor='deepskyblue'> <modifier> <tr> <td align='center'> <font color='black'> <id> :<classname> </font></td></tr> <tr> <td align='left'> <table border='0' cellborder='0' cellspacing='0' color='black'> <tr> <td>  </td></tr></table></td></tr></table>>];\n");
                String id = this.nameForPatElem(patObject);
                String color = "black";
                String modifier = "";
                if (CREATE.equals(patObject.getModifier())) {
                    color = "green";
                    modifier = "<tr> <td border='0' align='right'><font color='green'>&#171;create&#187;</font></td></tr>";
                } else if (BOUND.equals(patObject.getModifier())) {
                    modifier = "<tr> <td border='0' align='right'><font color='black'>&#171;bound&#187;</font></td></tr>";
                }
                CGUtil.replaceAll(nodeLine, "<id>", id, "<classname>", CGUtil.shortClassName(patElem.getClass().getName()), "black", color, "<modifier>", modifier);
                if (!patObject.getAttrConstraints().isEmpty()) {
                    StringBuilder allAttrLines = new StringBuilder();
                    Iterator iterator2 = patObject.getAttrConstraints().iterator();
                    while (iterator2.hasNext()) {
                        AttributeConstraint attrConstr = (AttributeConstraint)iterator2.next();
                        StringBuilder oneAttrLine = new StringBuilder("<tr><td><font color='black'> attrName Op value </font></td></tr>");
                        String op = "==";
                        color = "black";
                        if (CREATE.equals(attrConstr.getModifier())) {
                            op = ":=";
                            color = "green";
                        }
                        if (attrConstr.getCmpOp() != null) {
                            op = attrConstr.getCmpOp();
                        }
                        Object tgtValue = attrConstr.getTgtValue();
                        String value = "" + (tgtValue instanceof String ? "\"" + tgtValue + "\"" : tgtValue);
                        if (attrConstr.getUpperTgtValue() != null) {
                            op = "in";
                            value = "" + tgtValue + ".." + attrConstr.getUpperTgtValue();
                        }
                        CGUtil.replaceAll(oneAttrLine, "attrName", attrConstr.getAttrName(), "black", color, "Op", op, "value", value);
                        allAttrLines.append(oneAttrLine.toString());
                    }
                    CGUtil.replaceAll(nodeLine, "<tr> <td>  </td></tr>", allAttrLines.toString());
                }
                nodeBuilder.append(nodeLine.toString());
                if (patObject.getDoAllMatches()) {
                    StringBuilder allMatchesBuilder = new StringBuilder("allMatches_patElemId [label=allMatches];\n");
                    CGUtil.replaceAll(allMatchesBuilder, "patElemId", id);
                    nodeBuilder.append(allMatchesBuilder.toString());
                    edgeBuilder.append("" + id + " -- allMatches_" + id + " [style=\"dotted\"];\n");
                }
                if (!showMatch) continue;
                if (patObject.getCurrentMatch() != null) {
                    matchedObjects.add(patObject.getCurrentMatch());
                    matchEdge = new StringBuilder("<srcId> -- <tgtId> [headlabel = \\\"match\\\" style=\"dotted\" color=\"black\" fontcolor=\"black\"];\n");
                    CGUtil.replaceAll((StringBuilder)matchEdge, "<srcId>", id, "<tgtId>", this.nameForPatElem(patObject.getCurrentMatch()), "black", color);
                    edgeBuilder.append(((StringBuilder)matchEdge).toString());
                }
                if (patObject.getCandidates() == null) continue;
                if (patObject.getCandidates() instanceof Collection) {
                    for (Object candidate : (Collection)patObject.getCandidates()) {
                        matchedObjects.add(candidate);
                        StringBuilder matchEdge2 = new StringBuilder("<srcId> -- <tgtId> [headlabel = \\\"candidate\\\" style=\"dotted\" color=\"black\" fontcolor=\"black\"];\n");
                        CGUtil.replaceAll(matchEdge2, "<srcId>", id, "<tgtId>", this.nameForPatElem(candidate), "black", color);
                        edgeBuilder.append(matchEdge2.toString());
                    }
                    continue;
                }
                matchedObjects.add(patObject.getCandidates());
                matchEdge = new StringBuilder("<srcId> -- <tgtId> [headlabel = \\\"candidate\\\" style=\"dotted\" color=\"black\" fontcolor=\"black\"];\n");
                CGUtil.replaceAll((StringBuilder)matchEdge, "<srcId>", id, "<tgtId>", this.nameForPatElem(patObject.getCandidates()), "black", color);
                edgeBuilder.append(((StringBuilder)matchEdge).toString());
                continue;
            }
            if (patElem instanceof MatchIsomorphicConstraint) {
                nodeBuilder.append("matchIsomorphic;\n");
                continue;
            }
            if (patElem instanceof DestroyObjectElem) {
                DestroyObjectElem destroyElem = (DestroyObjectElem)patElem;
                StringBuilder destroyBuilder = new StringBuilder("id [label=\"destroy\" fontcolor=\"red\"]\n");
                CGUtil.replaceAll(destroyBuilder, "id", this.nameForPatElem(destroyElem));
                nodeBuilder.append(destroyBuilder.toString());
                destroyEdgeBuilder = new StringBuilder("<srcId> -- <tgtId> [style=\"dotted\" color=\"red\" fontcolor=\"red\"];\n");
                CGUtil.replaceAll(destroyEdgeBuilder, "<srcId>", this.nameForPatElem(destroyElem.getPatternObject()), "<tgtId>", this.nameForPatElem(destroyElem));
                edgeBuilder.append(destroyEdgeBuilder.toString());
                continue;
            }
            if (patElem instanceof CardinalityConstraint) {
                CardinalityConstraint cardConstr = (CardinalityConstraint)patElem;
                cardConstrBuilder = new StringBuilder("id [label=\"{mincard <= tgtRole.size <= maxcard}\"]\n");
                CGUtil.replaceAll(cardConstrBuilder, "id", this.nameForPatElem(cardConstr), "mincard", "" + cardConstr.getMinCard(), "maxcard", "" + cardConstr.getMaxCard(), "tgtRole", cardConstr.getTgtRoleName());
                nodeBuilder.append(cardConstrBuilder.toString());
                dottedEdgeBuilder = new StringBuilder("<srcId> -- <tgtId> [style=\"dotted\"];\n");
                CGUtil.replaceAll(dottedEdgeBuilder, "<srcId>", this.nameForPatElem(cardConstr.getSrc()), "<tgtId>", this.nameForPatElem(cardConstr));
                edgeBuilder.append(dottedEdgeBuilder.toString());
                continue;
            }
            if (patElem instanceof GenericConstraint) {
                GenericConstraint genericConstraint = (GenericConstraint)patElem;
                StringBuilder constrBuilder = new StringBuilder("id [label=\"text\"]\n");
                CGUtil.replaceAll(constrBuilder, "id", this.nameForPatElem(genericConstraint), "text", "" + genericConstraint.getText());
                nodeBuilder.append(constrBuilder.toString());
                if (this.previousConstraint != null) {
                    dottedEdgeBuilder = new StringBuilder("<srcId> -- <tgtId> [style=\"dotted\"];\n");
                    CGUtil.replaceAll(dottedEdgeBuilder, "<srcId>", this.nameForPatElem(this.previousConstraint), "<tgtId>", this.nameForPatElem(genericConstraint));
                    edgeBuilder.append(dottedEdgeBuilder.toString());
                }
                this.previousConstraint = genericConstraint;
                continue;
            }
            if (patElem instanceof MatchOtherThen) {
                MatchOtherThen matchOther = (MatchOtherThen)patElem;
                cardConstrBuilder = new StringBuilder("id [label=\"{nodeX != nodeY}\"]\n");
                CGUtil.replaceAll(cardConstrBuilder, "id", this.nameForPatElem(matchOther), "nodeX", this.nameForPatElem(matchOther.getSrc()), "nodeY", this.nameForPatElem(matchOther.getForbidden()));
                nodeBuilder.append(cardConstrBuilder.toString());
                destroyEdgeBuilder = new StringBuilder("<srcId> -- <tgtId> [style=\"dotted\"];\n");
                CGUtil.replaceAll(destroyEdgeBuilder, "<srcId>", this.nameForPatElem(matchOther.getSrc()), "<tgtId>", this.nameForPatElem(matchOther));
                edgeBuilder.append(destroyEdgeBuilder.toString());
                continue;
            }
            if (patElem instanceof NegativeApplicationCondition) {
                NegativeApplicationCondition nac = (NegativeApplicationCondition)patElem;
                StringBuilder nacBuilder = new StringBuilder("subgraph cluster_nacId \n{\n   label=<<table border='0' cellborder='0'><tr><td><img src='../../SDMLib.net/doc/forbiddensign.svg'/></td><td>NAC nacId</td></tr></table>>;\n   color=grey;\n\n");
                CGUtil.replaceAll(nacBuilder, "nacId", this.nameForPatElem(nac));
                nodeBuilder.append(nacBuilder.toString());
                nac.dumpPatternObjects(nodeBuilder, edgeBuilder, showMatch, matchedObjects);
                nodeBuilder.append("}\n\n");
                continue;
            }
            if (!(patElem instanceof OptionalSubPattern)) continue;
            OptionalSubPattern optSubPattern = (OptionalSubPattern)patElem;
            StringBuilder optSubBuilder = new StringBuilder("subgraph cluster_nacId \n{\n   label=<<table border='0' cellborder='0'><tr><td>optional nacId</td></tr></table>>;\n   color=grey;\n\n");
            CGUtil.replaceAll(optSubBuilder, "nacId", this.nameForPatElem(optSubPattern));
            nodeBuilder.append(optSubBuilder.toString());
            optSubPattern.dumpPatternObjects(nodeBuilder, edgeBuilder, showMatch, matchedObjects);
            nodeBuilder.append("}\n\n");
        }
    }

    private String nameForPatElem(Object patElem) {
        PatternObject patObj;
        if (patElem instanceof PatternObject && (patObj = (PatternObject)patElem).getPatternObjectName() != null) {
            return patObj.getPatternObjectName();
        }
        return this.getJsonIdMap().getId(patElem).split("\\.")[1].toLowerCase();
    }

    private void dumpDiagram(String diagramName, String fileText) {
        File docDir = new File("doc");
        docDir.mkdir();
        this.getAdapter().dumpDiagram(diagramName, fileText);
    }

    public Pattern getCurrentSubPattern() {
        return this.currentSubPattern;
    }

    public void setCurrentSubPattern(Pattern value) {
        if (this.currentSubPattern != value) {
            Pattern oldValue = this.currentSubPattern;
            this.currentSubPattern = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CURRENTSUBPATTERN, oldValue, value);
        }
    }

    public MP withCurrentSubPattern(Pattern value) {
        this.setCurrentSubPattern(value);
        return (MP)this;
    }

    public int getDebugMode() {
        return this.debugMode;
    }

    public void setDebugMode(int value) {
        if (this.debugMode != value) {
            int oldValue = this.debugMode;
            this.debugMode = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_DEBUGMODE, oldValue, value);
            if (value >= 1) {
                this.setTrace(new StringBuilder());
            }
        }
    }

    public MP withDebugMode(int value) {
        this.setDebugMode(value);
        return (MP)this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getDebugMode());
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        s.append(" ").append(this.getName());
        return s.substring(1);
    }

    public int getPatternObjectCount() {
        return this.patternObjectCount;
    }

    public void incrementPatternObjectCount() {
        ++this.patternObjectCount;
    }

    public LinkedHashSet<String> getVariablesAlreadyInTrace() {
        if (this.variablesAlreadyInTrace == null) {
            this.variablesAlreadyInTrace = new LinkedHashSet();
        }
        return this.variablesAlreadyInTrace;
    }

    public StringBuilder getTrace() {
        return this.trace;
    }

    public void setTrace(StringBuilder value) {
        if (this.trace != value) {
            StringBuilder oldValue = this.trace;
            this.trace = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TRACE, oldValue, value);
        }
    }

    public MP withTrace(StringBuilder value) {
        this.setTrace(value);
        return (MP)this;
    }

    public MP addLogMsg(String msg) {
        if (this.debugMode >= 1) {
            if (this.trace == null) {
                this.trace = new StringBuilder();
                traceLength = 0;
            }
            String line = "" + ++traceLength + ": " + msg + "\n";
            this.trace.append(line);
            if (this.debugMode >= 2) {
                System.out.print(line);
            }
            if (traceLength >= 9) {
                traceLength += 0;
            }
        }
        return (MP)this;
    }

    public ReachabilityGraph getRgraph() {
        return this.rgraph;
    }

    public boolean setRgraph(ReachabilityGraph value) {
        boolean changed = false;
        if (this.rgraph != value) {
            ReachabilityGraph oldValue = this.rgraph;
            if (this.rgraph != null) {
                this.rgraph = null;
                oldValue.withoutRules(this);
            }
            this.rgraph = value;
            if (value != null) {
                value.withRules(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_RGRAPH, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public Pattern withRgraph(ReachabilityGraph value) {
        this.setRgraph(value);
        return this;
    }

    public ReachabilityGraph createRgraph() {
        ReachabilityGraph value = new ReachabilityGraph();
        this.withRgraph(value);
        return value;
    }

    public boolean getRiskConcurrentModification() {
        return this.riskConcurrentModification;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (!StrUtil.stringEquals(this.name, value)) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    public Pattern withName(String value) {
        this.setName(value);
        return this;
    }

    @Override
    public Iterator<Match> iterator() {
        return new Iterator<Match>(){
            private boolean needsNewMatch = false;
            int i = 0;

            @Override
            public boolean hasNext() {
                if (this.needsNewMatch) {
                    Pattern.this.findNextMatch();
                    this.needsNewMatch = false;
                }
                return Pattern.this.getHasMatch();
            }

            @Override
            public Match next() {
                this.needsNewMatch = true;
                ++this.i;
                return new Match().withNumber(this.i);
            }

            @Override
            public void remove() {
            }
        };
    }

    public Pattern withElements(PatternElement ... value) {
        if (value == null) {
            return this;
        }
        for (PatternElement item : value) {
            this.addToElements(item);
        }
        return this;
    }

    public Pattern withoutElements(PatternElement ... value) {
        for (PatternElement item : value) {
            this.removeFromElements(item);
        }
        return this;
    }

    public PatternElement createElements() {
        PatternElement value = new PatternElement();
        this.withElements(value);
        return value;
    }

    public MP withRiskConcurrentModification(boolean riskConcurrentModification) {
        this.riskConcurrentModification = riskConcurrentModification;
        return (MP)this;
    }

    public PatternObject has(PatternObject po) {
        po.withModifier(this.getModifier());
        this.setJsonIdMap(po.getPattern().getJsonIdMap());
        this.addToElements(po);
        this.findMatch();
        return po;
    }

    public PatternElement createElementsPattern() {
        Pattern<MP> value = new Pattern<MP>();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsPatternObject() {
        PatternObject value = new PatternObject();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsPatternLink() {
        PatternLink value = new PatternLink();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsAttributeConstraint() {
        AttributeConstraint value = new AttributeConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsMatchIsomorphicConstraint() {
        MatchIsomorphicConstraint value = new MatchIsomorphicConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsCloneOp() {
        CloneOp value = new CloneOp();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsUnifyGraphsOp() {
        UnifyGraphsOp value = new UnifyGraphsOp();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsDestroyObjectElem() {
        DestroyObjectElem value = new DestroyObjectElem();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsCardinalityConstraint() {
        CardinalityConstraint value = new CardinalityConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsMatchOtherThen() {
        MatchOtherThen value = new MatchOtherThen();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsGenericConstraint() {
        GenericConstraint value = new GenericConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsNegativeApplicationCondition() {
        NegativeApplicationCondition value = new NegativeApplicationCondition();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsOptionalSubPattern() {
        OptionalSubPattern value = new OptionalSubPattern();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternElement createElementsLinkConstraint() {
        LinkConstraint value = new LinkConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    @Override
    public Pattern createPattern() {
        Pattern<MP> value = new Pattern<MP>();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternObject createPatternObject() {
        PatternObject value = new PatternObject();
        this.withElements((PatternElement)value);
        return value;
    }

    public PatternLink createPatternLink() {
        PatternLink value = new PatternLink();
        this.withElements((PatternElement)value);
        return value;
    }

    public AttributeConstraint createAttributeConstraint() {
        AttributeConstraint value = new AttributeConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public MatchIsomorphicConstraint createMatchIsomorphicConstraint() {
        MatchIsomorphicConstraint value = new MatchIsomorphicConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public CloneOp createCloneOp() {
        CloneOp value = new CloneOp();
        this.withElements((PatternElement)value);
        return value;
    }

    public UnifyGraphsOp createUnifyGraphsOp() {
        UnifyGraphsOp value = new UnifyGraphsOp();
        this.withElements((PatternElement)value);
        return value;
    }

    public DestroyObjectElem createDestroyObjectElem() {
        DestroyObjectElem value = new DestroyObjectElem();
        this.withElements((PatternElement)value);
        return value;
    }

    public CardinalityConstraint createCardinalityConstraint() {
        CardinalityConstraint value = new CardinalityConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public MatchOtherThen createMatchOtherThen() {
        MatchOtherThen value = new MatchOtherThen();
        this.withElements((PatternElement)value);
        return value;
    }

    public GenericConstraint createGenericConstraint() {
        GenericConstraint value = new GenericConstraint();
        this.withElements((PatternElement)value);
        return value;
    }

    public NegativeApplicationCondition createNegativeApplicationCondition() {
        NegativeApplicationCondition value = new NegativeApplicationCondition();
        this.withElements((PatternElement)value);
        return value;
    }

    public OptionalSubPattern createOptionalSubPattern() {
        OptionalSubPattern value = new OptionalSubPattern();
        this.withElements((PatternElement)value);
        return value;
    }

    public LinkConstraint createLinkConstraint() {
        LinkConstraint value = new LinkConstraint();
        this.withElements((PatternElement)value);
        return value;
    }
}

