/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import org.sdmlib.StrUtil;
import org.sdmlib.models.pattern.Pattern;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.serialization.PropertyChangeInterface;

public class NegativeApplicationCondition
extends Pattern
implements PropertyChangeInterface {
    public static final String PROPERTY_CURRENTSUBPATTERN = "currentSubPattern";
    private Pattern currentSubPattern;
    public static final String PROPERTY_DEBUGMODE = "debugMode";
    private int debugMode;
    public static final String PROPERTY_NAME = "name";
    private String name;

    public NegativeApplicationCondition() {
        this.setHasMatch(true);
    }

    @Override
    public boolean findMatch() {
        if (this.getPattern().getCurrentSubPattern() != null) {
            return true;
        }
        return super.findMatch();
    }

    @Override
    public boolean findNextMatch() {
        if (this.getPattern().getCurrentSubPattern() != null) {
            return true;
        }
        if (this.getHasMatch()) {
            this.resetSearch();
            if (this.getTopPattern().getDebugMode() >= 1) {
                this.getTopPattern().addLogMsg("// start NAC " + this.getPatternObjectName());
            }
            boolean nacHasMatch = this.findMatch();
            if (this.getTopPattern().getDebugMode() >= 1) {
                if (nacHasMatch) {
                    this.getTopPattern().addLogMsg("// NAC " + this.getPatternObjectName() + " has match, backtrack!");
                } else {
                    this.getTopPattern().addLogMsg("// NAC " + this.getPatternObjectName() + " has NO match, that is good");
                }
            }
            return !nacHasMatch;
        }
        this.setHasMatch(true);
        return false;
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.removeAllFromElements();
        this.setPattern(null);
        this.setRgraph(null);
        this.withoutElements((PatternElement[])this.getElements().toArray(new PatternElement[this.getElements().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getDebugMode());
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        s.append(" ").append(this.getName());
        return s.substring(1);
    }

    @Override
    public Pattern getCurrentSubPattern() {
        return this.currentSubPattern;
    }

    @Override
    public void setCurrentSubPattern(Pattern value) {
        if (this.currentSubPattern != value) {
            Pattern oldValue = this.currentSubPattern;
            this.currentSubPattern = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CURRENTSUBPATTERN, oldValue, value);
        }
    }

    public Pattern withCurrentSubPattern(Pattern value) {
        this.setCurrentSubPattern(value);
        return this;
    }

    @Override
    public int getDebugMode() {
        return this.debugMode;
    }

    @Override
    public void setDebugMode(int value) {
        if (this.debugMode != value) {
            int oldValue = this.debugMode;
            this.debugMode = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_DEBUGMODE, oldValue, value);
        }
    }

    public Pattern withDebugMode(int value) {
        this.setDebugMode(value);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String value) {
        if (!StrUtil.stringEquals(this.name, value)) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    @Override
    public Pattern withName(String value) {
        this.setName(value);
        return this;
    }
}

