/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import java.util.Iterator;
import java.util.LinkedHashSet;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.serialization.PropertyChangeInterface;

public class MatchIsomorphicConstraint
extends PatternElement
implements PropertyChangeInterface {
    @Override
    public boolean findNextMatch() {
        if (!this.getPattern().getHasMatch()) {
            return false;
        }
        if (this.getHasMatch()) {
            this.setHasMatch(false);
            return false;
        }
        LinkedHashSet usedObjects = new LinkedHashSet();
        Iterator iterator = this.getPattern().getElements().iterator();
        while (iterator.hasNext()) {
            Object currentMatch;
            PatternElement patElem = (PatternElement)iterator.next();
            if (!(patElem instanceof PatternObject) || (currentMatch = ((PatternObject)patElem).getCurrentMatch()) == null) continue;
            if (usedObjects.contains(currentMatch)) {
                if (this.getTopPattern().getDebugMode() >= 1) {
                    this.getTopPattern().addLogMsg("// match is NOT isomorphic. " + this.dumpHostGraphObject(currentMatch) + " has been matched twice (or more). Backtrack! ");
                }
                return false;
            }
            usedObjects.add(currentMatch);
        }
        this.setHasMatch(true);
        if (this.getTopPattern().getDebugMode() >= 1) {
            this.getTopPattern().addLogMsg("// match is isomorphic");
        }
        return true;
    }

    @Override
    public void resetSearch() {
        this.setHasMatch(false);
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setPattern(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        return s.substring(1);
    }
}

