/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.util.Collection;
import org.sdmlib.StrUtil;
import org.sdmlib.models.pattern.PatternLink;
import org.sdmlib.serialization.PropertyChangeInterface;

public class LinkConstraint
extends PatternLink
implements PropertyChangeInterface {
    public static final String PROPERTY_TGTROLENAME = "tgtRoleName";
    private String tgtRoleName;
    public static final String PROPERTY_HOSTGRAPHSRCOBJECT = "hostGraphSrcObject";
    private Object hostGraphSrcObject;

    @Override
    public boolean findNextMatch() {
        if ("create".equals(this.getModifier())) {
            if (!this.getPattern().getHasMatch()) {
                return false;
            }
            if (this.getHasMatch()) {
                this.setHasMatch(false);
                return false;
            }
            Object srcObj = this.getSrc().getCurrentMatch();
            SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(srcObj);
            creatorClass.setValue(srcObj, this.getTgtRoleName(), this.getTgt().getCurrentMatch(), "");
            this.setHasMatch(true);
            if (this.getTopPattern().getDebugMode() >= 1) {
                this.getTopPattern().addLogMsg(this.getSrc().getPatternObjectName() + ".set" + StrUtil.upFirstChar(this.getTgtRoleName()) + "(" + this.getTgt().getPatternObjectName() + ")");
            }
            return true;
        }
        if ("destroy".equals(this.getModifier())) {
            if (!this.getPattern().getHasMatch()) {
                return false;
            }
            if (this.getHasMatch()) {
                this.setHasMatch(false);
                return false;
            }
            Object srcObj = this.getSrc().getCurrentMatch();
            SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(srcObj);
            Object value = creatorClass.getValue(srcObj, this.getTgtRoleName());
            if (value != null) {
                if (value instanceof Collection) {
                    if (this.getTopPattern().getDebugMode() >= 1) {
                        this.getTopPattern().addLogMsg(this.getSrc().getPatternObjectName() + ".removeFrom" + StrUtil.upFirstChar(this.getTgtRoleName()) + "(" + this.getTgt().getPatternObjectName() + ")");
                    }
                    creatorClass.setValue(srcObj, this.getTgtRoleName() + "rem", this.getTgt().getCurrentMatch(), "");
                } else {
                    if (this.getTopPattern().getDebugMode() >= 1) {
                        this.getTopPattern().addLogMsg(this.getSrc().getPatternObjectName() + ".set" + StrUtil.upFirstChar(this.getTgtRoleName()) + "(null); // remove" + this.getTgt().dumpHostGraphObject(this.getTgt().getCurrentMatch()));
                    }
                    creatorClass.setValue(srcObj, this.getTgtRoleName(), null, "");
                }
            }
            this.setHasMatch(true);
            return true;
        }
        if (this.getHostGraphSrcObject() == null) {
            this.setHostGraphSrcObject(this.getSrc().getCurrentMatch());
            if (this.getHostGraphSrcObject() != null) {
                SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(this.getHostGraphSrcObject());
                Object value = creatorClass.getValue(this.getHostGraphSrcObject(), this.getTgtRoleName());
                Object hostGraphTgtObject = this.getTgt().getCurrentMatch();
                if (hostGraphTgtObject != null && (hostGraphTgtObject == value || value instanceof Collection && ((Collection)value).contains(hostGraphTgtObject))) {
                    if (this.getTopPattern().getDebugMode() >= 1) {
                        String msg = "// cnet link from x to y exists";
                        msg = msg.replaceFirst("y", this.getTopPattern().getJsonIdMap().getId(value) + " " + value.toString());
                        msg = msg.replaceFirst("x", this.getTopPattern().getJsonIdMap().getId(this.getHostGraphSrcObject()) + " " + this.getHostGraphSrcObject().toString());
                        msg = msg.replaceFirst("cnet", this.getTgtRoleName());
                        this.getTopPattern().addLogMsg(msg);
                    }
                    return true;
                }
                if (this.getTopPattern().getDebugMode() >= 1) {
                    String msg = "// cnet link from x to ? does not exists, backtrack";
                    if (value != null) {
                        msg = msg.replaceFirst("\\?", this.getTopPattern().getJsonIdMap().getId(value) + " " + value.toString());
                    }
                    msg = msg.replaceFirst("x", this.getTopPattern().getJsonIdMap().getId(this.getHostGraphSrcObject()) + " " + this.getHostGraphSrcObject().toString());
                    msg = msg.replaceFirst("cnet", this.getTgtRoleName());
                    this.getTopPattern().addLogMsg(msg);
                }
                this.setHostGraphSrcObject(null);
                return false;
            }
            return false;
        }
        this.setHostGraphSrcObject(null);
        return false;
    }

    @Override
    public void resetSearch() {
        this.setHasMatch(false);
        super.resetSearch();
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setPattern(null);
        this.setTgt(null);
        this.setSrc(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTgtRoleName());
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        return s.substring(1);
    }

    @Override
    public String getTgtRoleName() {
        return this.tgtRoleName;
    }

    @Override
    public void setTgtRoleName(String value) {
        if (!StrUtil.stringEquals(this.tgtRoleName, value)) {
            String oldValue = this.tgtRoleName;
            this.tgtRoleName = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TGTROLENAME, oldValue, value);
        }
    }

    @Override
    public PatternLink withTgtRoleName(String value) {
        this.setTgtRoleName(value);
        return this;
    }

    @Override
    public Object getHostGraphSrcObject() {
        return this.hostGraphSrcObject;
    }

    @Override
    public void setHostGraphSrcObject(Object value) {
        if (this.hostGraphSrcObject != value) {
            Object oldValue = this.hostGraphSrcObject;
            this.hostGraphSrcObject = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOSTGRAPHSRCOBJECT, oldValue, value);
        }
    }

    @Override
    public PatternLink withHostGraphSrcObject(Object value) {
        this.setHostGraphSrcObject(value);
        return this;
    }
}

