/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.logic.Condition;
import java.beans.PropertyChangeListener;
import org.sdmlib.StrUtil;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.serialization.PropertyChangeInterface;

public class GenericConstraint
extends PatternElement<GenericConstraint>
implements PropertyChangeInterface {
    Condition<Object> condition;
    private PatternObject src = null;
    public static final String PROPERTY_TEXT = "text";
    private String text;

    @Override
    public boolean findNextMatch() {
        if (!this.getPattern().getHasMatch()) {
            return false;
        }
        if (this.getHasMatch()) {
            this.setHasMatch(false);
            return false;
        }
        boolean ok = this.condition.check(this.getSrc().getCurrentMatch());
        this.setHasMatch(ok);
        if (ok && this.getTopPattern().getDebugMode() >= 1) {
            this.getTopPattern().addLogMsg("// match is isomorphic");
        }
        return ok;
    }

    @Override
    public void resetSearch() {
        this.setHasMatch(false);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.getPropertyChangeSupport().addPropertyChangeListener(listener);
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setPattern(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getText());
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        return s.substring(1);
    }

    public GenericConstraint withCondition(Condition<Object> newCondition) {
        this.condition = newCondition;
        return this;
    }

    public PatternObject getSrc() {
        return this.src;
    }

    public GenericConstraint withSrc(PatternObject value) {
        if (value != this.src) {
            this.src = value;
        }
        return this;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String value) {
        if (!StrUtil.stringEquals(this.text, value)) {
            String oldValue = this.text;
            this.text = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TEXT, oldValue, value);
        }
    }

    public GenericConstraint withText(String value) {
        this.setText(value);
        return this;
    }
}

