/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.serialization.EntityFactory;
import org.sdmlib.serialization.PropertyChangeInterface;

public class DestroyObjectElem
extends PatternElement
implements PropertyChangeInterface {
    public static final String PROPERTY_PATTERNOBJECT = "patternObject";
    private PatternObject patternObject = null;

    @Override
    public boolean findNextMatch() {
        if (this.getHasMatch()) {
            this.setHasMatch(false);
            return false;
        }
        if (this.getPattern().getHasMatch()) {
            this.setHasMatch(true);
            Object currentMatch = this.getPatternObject().getCurrentMatch();
            EntityFactory creatorClass = (EntityFactory)this.getPattern().getJsonIdMap().getCreatorClass(currentMatch);
            creatorClass.removeObject(currentMatch);
            if (this.getTopPattern().getDebugMode() >= 1) {
                this.getTopPattern().addLogMsg(this.getPatternObject().getPatternObjectName() + ".removeYou(); // kill: " + this.dumpHostGraphObject(currentMatch));
            }
            return true;
        }
        return false;
    }

    @Override
    public void resetSearch() {
        this.setHasMatch(false);
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setPatternObject(null);
        this.setPattern(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public PatternObject getPatternObject() {
        return this.patternObject;
    }

    public boolean setPatternObject(PatternObject value) {
        boolean changed = false;
        if (this.patternObject != value) {
            PatternObject oldValue = this.patternObject;
            if (this.patternObject != null) {
                this.patternObject = null;
                oldValue.setDestroyElem(null);
            }
            this.patternObject = value;
            if (value != null) {
                value.withDestroyElem(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_PATTERNOBJECT, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public DestroyObjectElem withPatternObject(PatternObject value) {
        this.setPatternObject(value);
        return this;
    }

    public PatternObject createPatternObject() {
        PatternObject value = new PatternObject();
        this.withPatternObject(value);
        return value;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        return s.substring(1);
    }
}

