/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import java.util.Collection;
import org.sdmlib.StrUtil;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.models.pattern.util.CardinalityConstraintSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class CardinalityConstraint
extends PatternElement
implements PropertyChangeInterface {
    public static final String PROPERTY_TGTROLENAME = "tgtRoleName";
    private String tgtRoleName;
    public static final String PROPERTY_HOSTGRAPHSRCOBJECT = "hostGraphSrcObject";
    private Object hostGraphSrcObject;
    public static final String PROPERTY_MINCARD = "minCard";
    private long minCard;
    public static final String PROPERTY_MAXCARD = "maxCard";
    private long maxCard;
    public static final String PROPERTY_SRC = "src";
    private PatternObject src = null;
    public static final CardinalityConstraintSet EMPTY_SET = new CardinalityConstraintSet();

    @Override
    public boolean findNextMatch() {
        if ("create".equals(this.getModifier())) {
            throw new RuntimeException("cannot create a cardinality constraint");
        }
        if (this.getHostGraphSrcObject() == null) {
            this.setHostGraphSrcObject(this.getSrc().getCurrentMatch());
            if (this.hostGraphSrcObject != null) {
                SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(this.hostGraphSrcObject);
                Object value = creatorClass.getValue(this.hostGraphSrcObject, this.tgtRoleName);
                long valueSize = -1L;
                valueSize = value == null ? 0L : (value instanceof Collection ? (long)((Collection)value).size() : 1L);
                if (this.minCard <= valueSize && valueSize <= this.maxCard) {
                    if (this.getTopPattern().getDebugMode() >= 1) {
                        String msg = "// node x has size tgtRole neighbors, which is between minCard and maxCard";
                        msg = msg.replaceFirst(PROPERTY_MAXCARD, "" + this.maxCard);
                        msg = msg.replaceFirst(PROPERTY_MINCARD, "" + this.minCard);
                        msg = msg.replaceFirst("tgtRole", "" + this.tgtRoleName);
                        msg = msg.replaceFirst("size", "" + valueSize);
                        msg = msg.replaceFirst("x", "" + this.getTopPattern().getJsonIdMap().getId(this.hostGraphSrcObject) + " " + this.hostGraphSrcObject.toString());
                        this.getTopPattern().addLogMsg(msg);
                    }
                    return true;
                }
                if (this.getTopPattern().getDebugMode() >= 1) {
                    String msg = "// node x has size tgtRole neighbors, which is NOT between minCard and maxCard";
                    msg = msg.replaceFirst(PROPERTY_MAXCARD, "" + this.maxCard);
                    msg = msg.replaceFirst(PROPERTY_MINCARD, "" + this.minCard);
                    msg = msg.replaceFirst("tgtRole", "" + this.tgtRoleName);
                    msg = msg.replaceFirst("size", "" + valueSize);
                    msg = msg.replaceFirst("x", "" + this.getTopPattern().getJsonIdMap().getId(this.hostGraphSrcObject) + " " + this.hostGraphSrcObject.toString());
                    this.getTopPattern().addLogMsg(msg);
                }
                this.setHostGraphSrcObject(null);
                return false;
            }
            return false;
        }
        this.setHostGraphSrcObject(null);
        return false;
    }

    @Override
    public void resetSearch() {
        this.setHasMatch(false);
        this.setHostGraphSrcObject(null);
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setPattern(null);
        this.setSrc(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getTgtRoleName() {
        return this.tgtRoleName;
    }

    public void setTgtRoleName(String value) {
        if (!StrUtil.stringEquals(this.tgtRoleName, value)) {
            String oldValue = this.tgtRoleName;
            this.tgtRoleName = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TGTROLENAME, oldValue, value);
        }
    }

    public CardinalityConstraint withTgtRoleName(String value) {
        this.setTgtRoleName(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getTgtRoleName());
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getPatternObjectName());
        return s.substring(1);
    }

    public Object getHostGraphSrcObject() {
        return this.hostGraphSrcObject;
    }

    public void setHostGraphSrcObject(Object value) {
        if (this.hostGraphSrcObject != value) {
            Object oldValue = this.hostGraphSrcObject;
            this.hostGraphSrcObject = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOSTGRAPHSRCOBJECT, oldValue, value);
        }
    }

    public CardinalityConstraint withHostGraphSrcObject(Object value) {
        this.setHostGraphSrcObject(value);
        return this;
    }

    public long getMinCard() {
        return this.minCard;
    }

    public void setMinCard(long value) {
        if (this.minCard != value) {
            long oldValue = this.minCard;
            this.minCard = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MINCARD, oldValue, value);
        }
    }

    public CardinalityConstraint withMinCard(long value) {
        this.setMinCard(value);
        return this;
    }

    public long getMaxCard() {
        return this.maxCard;
    }

    public void setMaxCard(long value) {
        if (this.maxCard != value) {
            long oldValue = this.maxCard;
            this.maxCard = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_MAXCARD, oldValue, value);
        }
    }

    public CardinalityConstraint withMaxCard(long value) {
        this.setMaxCard(value);
        return this;
    }

    public PatternObject getSrc() {
        return this.src;
    }

    public boolean setSrc(PatternObject value) {
        boolean changed = false;
        if (this.src != value) {
            PatternObject oldValue = this.src;
            if (this.src != null) {
                this.src = null;
                oldValue.withoutCardConstraints(this);
            }
            this.src = value;
            if (value != null) {
                value.withCardConstraints(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SRC, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public CardinalityConstraint withSrc(PatternObject value) {
        this.setSrc(value);
        return this;
    }

    public PatternObject createSrc() {
        PatternObject value = new PatternObject();
        this.withSrc(value);
        return value;
    }
}

