/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.pattern;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import org.sdmlib.StrUtil;
import org.sdmlib.models.pattern.PatternElement;
import org.sdmlib.models.pattern.PatternObject;
import org.sdmlib.models.pattern.util.AttributeConstraintSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class AttributeConstraint
extends PatternElement<AttributeConstraint>
implements PropertyChangeInterface {
    public static final String PROPERTY_ATTRNAME = "attrName";
    private String attrName;
    public static final String PROPERTY_TGTVALUE = "tgtValue";
    private Object tgtValue;
    public static final String PROPERTY_HOSTGRAPHSRCOBJECT = "hostGraphSrcObject";
    private Object hostGraphSrcObject;
    public static final String PROPERTY_SRC = "src";
    private PatternObject src = null;
    public static final AttributeConstraintSet EMPTY_SET = new AttributeConstraintSet();
    public static final String PROPERTY_CMPOP = "cmpOp";
    private String cmpOp;
    public static final String PROPERTY_UPPERTGTVALUE = "upperTgtValue";
    private Object upperTgtValue;

    @Override
    public boolean findNextMatch() {
        if ("create".equals(this.getModifier())) {
            if (!this.getPattern().getHasMatch()) {
                return false;
            }
            if (this.getHasMatch()) {
                this.setHasMatch(false);
                return false;
            }
            Object srcObj = this.getSrc().getCurrentMatch();
            SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(srcObj);
            creatorClass.setValue(srcObj, this.getAttrName(), this.getTgtValue(), "");
            this.setHasMatch(true);
            return true;
        }
        if (this.getHostGraphSrcObject() == null) {
            this.setHostGraphSrcObject(this.getSrc().getCurrentMatch());
            if (this.hostGraphSrcObject != null) {
                String msg;
                boolean itWorks;
                SendableEntityCreator creatorClass = this.getPattern().getJsonIdMap().getCreatorClass(this.hostGraphSrcObject);
                Object value = creatorClass.getValue(this.hostGraphSrcObject, this.attrName);
                boolean bl = itWorks = value == null && this.tgtValue == null || value != null && value.equals(this.tgtValue);
                if (this.cmpOp != null && this.cmpOp.equals("!=")) {
                    boolean bl2 = itWorks = value == null && this.tgtValue != null || value != null && !value.equals(this.tgtValue);
                }
                if (this.upperTgtValue != null) {
                    Comparable comparable = (Comparable)value;
                    boolean bl3 = itWorks = comparable.compareTo(this.tgtValue) >= 0 && comparable.compareTo(this.upperTgtValue) <= 0;
                }
                if (itWorks) {
                    if (this.getTopPattern().getDebugMode() >= 1) {
                        msg = "// attribute a1 of node x has required value y";
                        msg = msg.replaceFirst("y", "" + value);
                        msg = msg.replaceFirst("x", "" + this.getTopPattern().getJsonIdMap().getId(this.hostGraphSrcObject) + " " + this.hostGraphSrcObject.toString());
                        msg = msg.replaceFirst("a1", "" + this.attrName);
                        this.getTopPattern().addLogMsg(msg);
                    }
                    return true;
                }
                if (this.getTopPattern().getDebugMode() >= 1) {
                    msg = "// attribute a1 of node x has value actual and not required value y, backtrack!";
                    msg = msg.replaceFirst("y", "" + this.tgtValue);
                    msg = msg.replaceFirst("actual", "" + value);
                    msg = msg.replaceFirst("x", "" + this.getTopPattern().getJsonIdMap().getId(this.hostGraphSrcObject) + " " + this.hostGraphSrcObject.toString());
                    msg = msg.replaceFirst("a1", "" + this.attrName);
                    this.getTopPattern().addLogMsg(msg);
                }
                this.setHostGraphSrcObject(null);
                return false;
            }
            return false;
        }
        this.setHostGraphSrcObject(null);
        return false;
    }

    @Override
    public void resetSearch() {
        this.setHasMatch(false);
        this.setHostGraphSrcObject(null);
    }

    @Override
    public void removeYou() {
        super.removeYou();
        this.setSrc(null);
        this.setPattern(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getAttrName() {
        return this.attrName;
    }

    public void setAttrName(String value) {
        if (!StrUtil.stringEquals(this.attrName, value)) {
            String oldValue = this.attrName;
            this.attrName = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRNAME, oldValue, value);
        }
    }

    public AttributeConstraint withAttrName(String value) {
        this.setAttrName(value);
        return this;
    }

    public Object getTgtValue() {
        return this.tgtValue;
    }

    public void setTgtValue(Object value) {
        if (this.tgtValue == null && value != null || this.tgtValue != null && !this.tgtValue.equals(value)) {
            Object oldValue = this.tgtValue;
            this.tgtValue = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TGTVALUE, oldValue, value);
        }
    }

    public AttributeConstraint withTgtValue(Object value) {
        this.setTgtValue(value);
        return this;
    }

    public Object getHostGraphSrcObject() {
        return this.hostGraphSrcObject;
    }

    public void setHostGraphSrcObject(Object value) {
        if (this.hostGraphSrcObject != value) {
            Object oldValue = this.hostGraphSrcObject;
            this.hostGraphSrcObject = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_HOSTGRAPHSRCOBJECT, oldValue, value);
        }
    }

    public AttributeConstraint withHostGraphSrcObject(Object value) {
        this.setHostGraphSrcObject(value);
        return this;
    }

    public PatternObject getSrc() {
        return this.src;
    }

    public boolean setSrc(PatternObject value) {
        boolean changed = false;
        if (this.src != value) {
            PatternObject oldValue = this.src;
            if (this.src != null) {
                this.src = null;
                oldValue.withoutAttrConstraints(this);
            }
            this.src = value;
            if (value != null) {
                value.withAttrConstraints(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_SRC, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public AttributeConstraint withSrc(PatternObject value) {
        this.setSrc(value);
        return this;
    }

    @Override
    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getPatternObjectName());
        s.append(" ").append(this.getAttrName());
        s.append(" ").append(this.getModifier());
        s.append(" ").append(this.getCmpOp());
        s.append(" ").append(this.getTgtValue());
        return s.substring(1);
    }

    public String getCmpOp() {
        return this.cmpOp;
    }

    public void setCmpOp(String value) {
        if (!StrUtil.stringEquals(this.cmpOp, value)) {
            String oldValue = this.cmpOp;
            this.cmpOp = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_CMPOP, oldValue, value);
        }
    }

    public AttributeConstraint withCmpOp(String value) {
        this.setCmpOp(value);
        return this;
    }

    public Object getUpperTgtValue() {
        return this.upperTgtValue;
    }

    public void setUpperTgtValue(Object value) {
        if (this.upperTgtValue != value) {
            Object oldValue = this.upperTgtValue;
            this.upperTgtValue = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_UPPERTGTVALUE, oldValue, value);
        }
    }

    public AttributeConstraint withUpperTgtValue(Object value) {
        this.setUpperTgtValue(value);
        return this;
    }

    public PatternObject createSrc() {
        PatternObject value = new PatternObject();
        this.withSrc(value);
        return value;
    }
}

