/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.objects;

import de.uniks.networkparser.interfaces.BaseItem;
import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.interfaces.UpdateListener;
import de.uniks.networkparser.json.JsonArray;
import de.uniks.networkparser.json.JsonIdMap;
import de.uniks.networkparser.json.JsonObject;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.sdmlib.models.objects.GenericGraph;
import org.sdmlib.models.objects.GenericObject;

public class Specific2Generic {
    public GenericGraph convert(JsonIdMap idMap, Object root) {
        GenericGraph graph = new GenericGraph();
        LinkedHashMap<String, GenericObject> genObjMap = new LinkedHashMap<String, GenericObject>();
        LinkedHashSet knownLinks = new LinkedHashSet();
        MyUpdateListener changeListener = new MyUpdateListener();
        idMap.withUpdateListenerSend((UpdateListener)changeListener);
        JsonArray jsonArray = idMap.toJsonArray(root);
        for (int i = 0; i < jsonArray.size(); ++i) {
            JsonObject jsonObj = jsonArray.getJSONObject(i);
            String currentJsonId = jsonObj.getString((Object)"id");
            GenericObject genObj = graph.createObjects().withName(currentJsonId).withType(jsonObj.getString((Object)"class"));
            genObjMap.put(genObj.getName(), genObj);
            JsonObject jsonProps = (JsonObject)jsonObj.get((Object)"prop");
            if (jsonProps == null) continue;
            Iterator iter = jsonProps.keyIterator();
            while (iter.hasNext()) {
                String attrName = (String)iter.next();
                Object value = jsonProps.get((Object)attrName);
                if (value instanceof JsonObject) {
                    this.addOneGenericLink(idMap, graph, genObjMap, changeListener, currentJsonId, genObj, attrName, value, false);
                    continue;
                }
                if (value instanceof JsonArray) {
                    JsonArray jsonRefs = (JsonArray)value;
                    for (int j = 0; j < jsonRefs.size(); ++j) {
                        this.addOneGenericLink(idMap, graph, genObjMap, changeListener, currentJsonId, genObj, attrName, jsonRefs.get(j), true);
                    }
                    continue;
                }
                genObj.createAttrs().withName(attrName).withValue("" + value);
            }
        }
        return graph;
    }

    private void addOneGenericLink(JsonIdMap idMap, GenericGraph graph, LinkedHashMap<String, GenericObject> genObjMap, MyUpdateListener changeListener, String currentJsonId, GenericObject genObj, String attrName, Object value, boolean multi) {
        String tgtJsonId = ((JsonObject)value).getString((Object)"id");
        GenericObject genTgtObj = genObjMap.get(tgtJsonId);
        if (genTgtObj != null) {
            Object specObj = idMap.getObject(currentJsonId);
            SendableEntityCreator creatorClass = idMap.getCreatorClass(specObj);
            Object specTgtObject = idMap.getObject(tgtJsonId);
            if (multi) {
                creatorClass.setValue(specObj, attrName + "rem", specTgtObject, "");
                creatorClass.setValue(specObj, attrName, specTgtObject, "");
            } else {
                creatorClass.setValue(specObj, attrName, null, null);
                creatorClass.setValue(specObj, attrName, specTgtObject, null);
            }
            if (changeListener.firstPropName.compareTo(attrName) <= 0) {
                graph.createLinks().withSrc(genObj).withSrcLabel(changeListener.firstPropName).withTgt(genTgtObj).withTgtLabel(attrName);
            } else {
                graph.createLinks().withTgt(genObj).withTgtLabel(changeListener.firstPropName).withSrc(genTgtObj).withSrcLabel(attrName);
            }
            creatorClass.setValue(specObj, attrName, specTgtObject, null);
        }
    }

    private class MyUpdateListener
    implements UpdateListener {
        public String firstPropName = null;
        public String secondPropName = null;

        private MyUpdateListener() {
        }

        public boolean update(String typ, BaseItem jsonObject, Object target, String property, Object oldValue, Object newValue) {
            Object tmp = jsonObject.getValueItem((Object)"rem");
            if (tmp != null && tmp instanceof JsonObject) {
                JsonObject remObj = (JsonObject)tmp;
                String propName = (String)remObj.first();
                this.firstPropName = this.secondPropName;
                this.secondPropName = propName;
            }
            return false;
        }
    }
}

