/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.objects;

import java.beans.PropertyChangeSupport;
import java.util.LinkedHashSet;
import org.sdmlib.StrUtil;
import org.sdmlib.models.objects.GenericAttribute;
import org.sdmlib.models.objects.GenericGraph;
import org.sdmlib.models.objects.GenericLink;
import org.sdmlib.models.objects.util.GenericAttributeSet;
import org.sdmlib.models.objects.util.GenericLinkSet;
import org.sdmlib.models.objects.util.GenericObjectSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class GenericObject
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_NAME = "name";
    private String name;
    public static final String PROPERTY_TYPE = "type";
    private String type;
    public static final GenericObjectSet EMPTY_SET = new GenericObjectSet();
    public static final String PROPERTY_GRAPH = "graph";
    private GenericGraph graph = null;
    public static final String PROPERTY_ATTRS = "attrs";
    private GenericAttributeSet attrs = null;
    public static final String PROPERTY_OUTGOINGLINKS = "outgoingLinks";
    private GenericLinkSet outgoingLinks = null;
    public static final String PROPERTY_INCOMMINGLINKS = "incommingLinks";
    private GenericLinkSet incommingLinks = null;
    public static final String PROPERTY_ICON = "icon";
    private String icon;

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.setGraph(null);
        this.withoutAttrs((GenericAttribute[])this.getAttrs().toArray(new GenericAttribute[this.getAttrs().size()]));
        this.withoutOutgoingLinks((GenericLink[])this.getOutgoingLinks().toArray(new GenericLink[this.getOutgoingLinks().size()]));
        this.withoutIncommingLinks((GenericLink[])this.getIncommingLinks().toArray(new GenericLink[this.getIncommingLinks().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (!StrUtil.stringEquals(this.name, value)) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    public GenericObject withName(String value) {
        this.setName(value);
        return this;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String value) {
        if (!StrUtil.stringEquals(this.type, value)) {
            String oldValue = this.type;
            this.type = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_TYPE, oldValue, value);
        }
    }

    public GenericObject withType(String value) {
        this.setType(value);
        return this;
    }

    public GenericGraph getGraph() {
        return this.graph;
    }

    public boolean setGraph(GenericGraph value) {
        boolean changed = false;
        if (this.graph != value) {
            GenericGraph oldValue = this.graph;
            if (this.graph != null) {
                this.graph = null;
                oldValue.withoutObjects(this);
            }
            this.graph = value;
            if (value != null) {
                value.withObjects(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_GRAPH, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public GenericObject withGraph(GenericGraph value) {
        this.setGraph(value);
        return this;
    }

    public GenericGraph createGraph() {
        GenericGraph value = new GenericGraph();
        this.withGraph(value);
        return value;
    }

    public GenericAttributeSet getAttrs() {
        if (this.attrs == null) {
            return GenericAttribute.EMPTY_SET;
        }
        return this.attrs;
    }

    public boolean addToAttrs(GenericAttribute value) {
        boolean changed = false;
        if (value != null) {
            if (this.attrs == null) {
                this.attrs = new GenericAttributeSet();
            }
            if (changed = this.attrs.add(value)) {
                value.withOwner(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromAttrs(GenericAttribute value) {
        boolean changed = false;
        if (this.attrs != null && value != null && (changed = this.attrs.remove(value))) {
            value.setOwner(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ATTRS, value, null);
        }
        return changed;
    }

    public GenericObject withAttrs(GenericAttribute value) {
        this.addToAttrs(value);
        return this;
    }

    public GenericObject withoutAttrs(GenericAttribute value) {
        this.removeFromAttrs(value);
        return this;
    }

    public void removeAllFromAttrs() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getAttrs());
        for (GenericAttribute value : tmpSet) {
            this.removeFromAttrs(value);
        }
    }

    public GenericAttribute createAttrs() {
        GenericAttribute value = new GenericAttribute();
        this.withAttrs(value);
        return value;
    }

    public GenericLinkSet getOutgoingLinks() {
        if (this.outgoingLinks == null) {
            return GenericLink.EMPTY_SET;
        }
        return this.outgoingLinks;
    }

    public boolean addToOutgoingLinks(GenericLink value) {
        boolean changed = false;
        if (value != null) {
            if (this.outgoingLinks == null) {
                this.outgoingLinks = new GenericLinkSet();
            }
            if (changed = this.outgoingLinks.add(value)) {
                value.withSrc(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OUTGOINGLINKS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromOutgoingLinks(GenericLink value) {
        boolean changed = false;
        if (this.outgoingLinks != null && value != null && (changed = this.outgoingLinks.remove(value))) {
            value.setSrc(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OUTGOINGLINKS, value, null);
        }
        return changed;
    }

    public GenericObject withOutgoingLinks(GenericLink value) {
        this.addToOutgoingLinks(value);
        return this;
    }

    public GenericObject withoutOutgoingLinks(GenericLink value) {
        this.removeFromOutgoingLinks(value);
        return this;
    }

    public void removeAllFromOutgoingLinks() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getOutgoingLinks());
        for (GenericLink value : tmpSet) {
            this.removeFromOutgoingLinks(value);
        }
    }

    public GenericLink createOutgoingLinks() {
        GenericLink value = new GenericLink().withGraph(this.getGraph());
        this.withOutgoingLinks(value);
        return value;
    }

    public GenericLinkSet getIncommingLinks() {
        if (this.incommingLinks == null) {
            return GenericLink.EMPTY_SET;
        }
        return this.incommingLinks;
    }

    public boolean addToIncommingLinks(GenericLink value) {
        boolean changed = false;
        if (value != null) {
            if (this.incommingLinks == null) {
                this.incommingLinks = new GenericLinkSet();
            }
            if (changed = this.incommingLinks.add(value)) {
                value.withTgt(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INCOMMINGLINKS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromIncommingLinks(GenericLink value) {
        boolean changed = false;
        if (this.incommingLinks != null && value != null && (changed = this.incommingLinks.remove(value))) {
            value.setTgt(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_INCOMMINGLINKS, value, null);
        }
        return changed;
    }

    public GenericObject withIncommingLinks(GenericLink value) {
        this.addToIncommingLinks(value);
        return this;
    }

    public GenericObject withoutIncommingLinks(GenericLink value) {
        this.removeFromIncommingLinks(value);
        return this;
    }

    public void removeAllFromIncommingLinks() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getIncommingLinks());
        for (GenericLink value : tmpSet) {
            this.removeFromIncommingLinks(value);
        }
    }

    public GenericLink createIncommingLinks() {
        GenericLink value = new GenericLink().withGraph(this.getGraph());
        this.withIncommingLinks(value);
        return value;
    }

    public GenericObject with(String ... params) {
        for (int i = 0; i <= params.length - 2; i += 2) {
            this.with(params[i], params[i + 1]);
        }
        return this;
    }

    public GenericObject with(String name, String value) {
        this.createAttrs().withName(name).withValue(value);
        return this;
    }

    public String getIcon() {
        return this.icon;
    }

    public void setIcon(String value) {
        if (!StrUtil.stringEquals(this.icon, value)) {
            String oldValue = this.icon;
            this.icon = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_ICON, oldValue, value);
        }
    }

    public GenericObject withIcon(String value) {
        this.setIcon(value);
        return this;
    }

    public GenericObject createSubElem(String string) {
        return this.createOutgoingLinks().withTgtLabel(string).createTgt();
    }

    public GenericLink createOutgoingLinks(String tgtLabel, GenericObject tgt) {
        return this.createOutgoingLinks().withTgtLabel(tgtLabel).withTgt(tgt);
    }

    public GenericLink createOutgoingLinks(String srcLabel, String tgtLabel, GenericObject tgt) {
        return this.createOutgoingLinks().withSrcLabel(srcLabel).withTgtLabel(tgtLabel).withTgt(tgt);
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getName());
        s.append(" ").append(this.getType());
        s.append(" ").append(this.getIcon());
        return s.substring(1);
    }

    public GenericObject withAttrs(GenericAttribute ... value) {
        for (GenericAttribute item : value) {
            this.addToAttrs(item);
        }
        return this;
    }

    public GenericObject withoutAttrs(GenericAttribute ... value) {
        for (GenericAttribute item : value) {
            this.removeFromAttrs(item);
        }
        return this;
    }

    public GenericObject withOutgoingLinks(GenericLink ... value) {
        for (GenericLink item : value) {
            this.addToOutgoingLinks(item);
        }
        return this;
    }

    public GenericObject withoutOutgoingLinks(GenericLink ... value) {
        for (GenericLink item : value) {
            this.removeFromOutgoingLinks(item);
        }
        return this;
    }

    public GenericObject withIncommingLinks(GenericLink ... value) {
        for (GenericLink item : value) {
            this.addToIncommingLinks(item);
        }
        return this;
    }

    public GenericObject withoutIncommingLinks(GenericLink ... value) {
        for (GenericLink item : value) {
            this.removeFromIncommingLinks(item);
        }
        return this;
    }
}

