/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.objects;

import java.beans.PropertyChangeSupport;
import java.util.LinkedHashSet;
import org.sdmlib.models.objects.GenericLink;
import org.sdmlib.models.objects.GenericObject;
import org.sdmlib.models.objects.util.GenericLinkSet;
import org.sdmlib.models.objects.util.GenericObjectSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class GenericGraph
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_OBJECTS = "objects";
    private GenericObjectSet objects = null;
    public static final String PROPERTY_LINKS = "links";
    private GenericLinkSet links = null;

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.withoutObjects((GenericObject[])this.getObjects().toArray(new GenericObject[this.getObjects().size()]));
        this.withoutLinks((GenericLink[])this.getLinks().toArray(new GenericLink[this.getLinks().size()]));
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public GenericObjectSet getObjects() {
        if (this.objects == null) {
            return GenericObject.EMPTY_SET;
        }
        return this.objects;
    }

    public boolean addToObjects(GenericObject value) {
        boolean changed = false;
        if (value != null) {
            if (this.objects == null) {
                this.objects = new GenericObjectSet();
            }
            if (changed = this.objects.add(value)) {
                value.withGraph(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OBJECTS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromObjects(GenericObject value) {
        boolean changed = false;
        if (this.objects != null && value != null && (changed = this.objects.remove(value))) {
            value.setGraph(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OBJECTS, value, null);
        }
        return changed;
    }

    public GenericGraph withObjects(GenericObject value) {
        this.addToObjects(value);
        return this;
    }

    public GenericGraph withoutObjects(GenericObject value) {
        this.removeFromObjects(value);
        return this;
    }

    public void removeAllFromObjects() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getObjects());
        for (GenericObject value : tmpSet) {
            this.removeFromObjects(value);
        }
    }

    public GenericObject createObjects() {
        GenericObject value = new GenericObject();
        this.withObjects(value);
        return value;
    }

    public GenericLinkSet getLinks() {
        if (this.links == null) {
            return GenericLink.EMPTY_SET;
        }
        return this.links;
    }

    public boolean addToLinks(GenericLink value) {
        boolean changed = false;
        if (value != null) {
            if (this.links == null) {
                this.links = new GenericLinkSet();
            }
            if (changed = this.links.add(value)) {
                value.withGraph(this);
                this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LINKS, null, value);
            }
        }
        return changed;
    }

    public boolean removeFromLinks(GenericLink value) {
        boolean changed = false;
        if (this.links != null && value != null && (changed = this.links.remove(value))) {
            value.setGraph(null);
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_LINKS, value, null);
        }
        return changed;
    }

    public GenericGraph withLinks(GenericLink value) {
        this.addToLinks(value);
        return this;
    }

    public GenericGraph withoutLinks(GenericLink value) {
        this.removeFromLinks(value);
        return this;
    }

    public void removeAllFromLinks() {
        LinkedHashSet tmpSet = new LinkedHashSet(this.getLinks());
        for (GenericLink value : tmpSet) {
            this.removeFromLinks(value);
        }
    }

    public GenericLink createLinks() {
        GenericLink value = new GenericLink();
        this.withLinks(value);
        return value;
    }

    public GenericGraph withObjects(GenericObject ... value) {
        for (GenericObject item : value) {
            this.addToObjects(item);
        }
        return this;
    }

    public GenericGraph withoutObjects(GenericObject ... value) {
        for (GenericObject item : value) {
            this.removeFromObjects(item);
        }
        return this;
    }

    public GenericGraph withLinks(GenericLink ... value) {
        for (GenericLink item : value) {
            this.addToLinks(item);
        }
        return this;
    }

    public GenericGraph withoutLinks(GenericLink ... value) {
        for (GenericLink item : value) {
            this.removeFromLinks(item);
        }
        return this;
    }
}

