/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.objects;

import java.beans.PropertyChangeSupport;
import org.sdmlib.StrUtil;
import org.sdmlib.models.objects.GenericObject;
import org.sdmlib.models.objects.util.GenericAttributeSet;
import org.sdmlib.serialization.PropertyChangeInterface;

public class GenericAttribute
implements PropertyChangeInterface {
    protected PropertyChangeSupport listeners = new PropertyChangeSupport(this);
    public static final String PROPERTY_NAME = "name";
    private String name;
    public static final String PROPERTY_VALUE = "value";
    private String value;
    public static final GenericAttributeSet EMPTY_SET = new GenericAttributeSet();
    public static final String PROPERTY_OWNER = "owner";
    private GenericObject owner = null;

    @Override
    public PropertyChangeSupport getPropertyChangeSupport() {
        return this.listeners;
    }

    public void removeYou() {
        this.setOwner(null);
        this.getPropertyChangeSupport().firePropertyChange("REMOVE_YOU", this, null);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String value) {
        if (!StrUtil.stringEquals(this.name, value)) {
            String oldValue = this.name;
            this.name = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_NAME, oldValue, value);
        }
    }

    public GenericAttribute withName(String value) {
        this.setName(value);
        return this;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (!StrUtil.stringEquals(this.value, value)) {
            String oldValue = this.value;
            this.value = value;
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_VALUE, oldValue, value);
        }
    }

    public GenericAttribute withValue(String value) {
        this.setValue(value);
        return this;
    }

    public GenericObject getOwner() {
        return this.owner;
    }

    public boolean setOwner(GenericObject value) {
        boolean changed = false;
        if (this.owner != value) {
            GenericObject oldValue = this.owner;
            if (this.owner != null) {
                this.owner = null;
                oldValue.withoutAttrs(this);
            }
            this.owner = value;
            if (value != null) {
                value.withAttrs(this);
            }
            this.getPropertyChangeSupport().firePropertyChange(PROPERTY_OWNER, oldValue, value);
            changed = true;
        }
        return changed;
    }

    public GenericAttribute withOwner(GenericObject value) {
        this.setOwner(value);
        return this;
    }

    public GenericObject createOwner() {
        GenericObject value = new GenericObject();
        this.withOwner(value);
        return value;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(" ").append(this.getName());
        s.append(" ").append(this.getValue());
        return s.substring(1);
    }
}

