/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.objects;

import de.uniks.networkparser.interfaces.SendableEntityCreator;
import de.uniks.networkparser.json.JsonIdMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import org.sdmlib.models.objects.GenericAttribute;
import org.sdmlib.models.objects.GenericGraph;
import org.sdmlib.models.objects.GenericLink;
import org.sdmlib.models.objects.GenericObject;

public class Generic2Specific {
    public Object convert(JsonIdMap jsonIdMap, String packageName, GenericGraph graph) {
        Object result = null;
        LinkedHashMap<GenericObject, Object> gen2specObjTable = new LinkedHashMap<GenericObject, Object>();
        Iterator iterator = graph.getObjects().iterator();
        while (iterator.hasNext()) {
            SendableEntityCreator creatorClass;
            GenericObject genericObject = (GenericObject)iterator.next();
            String type = genericObject.getType();
            if (type == null) continue;
            if (packageName != null) {
                type = packageName + "." + type;
            }
            if ((creatorClass = jsonIdMap.getCreator(type, true)) == null) continue;
            Object specObject = creatorClass.getSendableInstance(false);
            gen2specObjTable.put(genericObject, specObject);
            if (result == null) {
                result = specObject;
            }
            Iterator iterator2 = genericObject.getAttrs().iterator();
            while (iterator2.hasNext()) {
                GenericAttribute genericAttribute = (GenericAttribute)iterator2.next();
                creatorClass.setValue(specObject, genericAttribute.getName(), (Object)genericAttribute.getValue(), "");
            }
        }
        iterator = graph.getLinks().iterator();
        while (iterator.hasNext()) {
            GenericLink genericLink = (GenericLink)iterator.next();
            GenericObject genericSrc = genericLink.getSrc();
            Object specSrc = gen2specObjTable.get(genericSrc);
            GenericObject genericTgt = genericLink.getTgt();
            Object specTgt = gen2specObjTable.get(genericTgt);
            if (specSrc == null || specTgt == null) continue;
            if (genericLink.getTgtLabel() != null) {
                SendableEntityCreator srcCreatorClass = jsonIdMap.getCreatorClass(specSrc);
                srcCreatorClass.setValue(specSrc, genericLink.getTgtLabel(), specTgt, "");
                continue;
            }
            if (genericLink.getSrcLabel() == null) continue;
            SendableEntityCreator tgtCreatorClass = jsonIdMap.getCreatorClass(specTgt);
            tgtCreatorClass.setValue(specTgt, genericLink.getSrcLabel(), specSrc, "");
        }
        return result;
    }
}

