/*
 * Decompiled with CFR 0.152.
 */
package org.sdmlib.models.modelsets;

import de.uniks.networkparser.list.AbstractArray;
import de.uniks.networkparser.list.SimpleIterator;
import de.uniks.networkparser.list.SimpleList;
import de.uniks.networkparser.logic.Condition;
import java.lang.reflect.ParameterizedType;
import java.util.Collection;
import java.util.Iterator;
import org.sdmlib.CGUtil;
import org.sdmlib.models.modelsets.ModelSet;
import org.sdmlib.models.modelsets.StringList;

public abstract class SDMSet<T>
extends SimpleList<T>
implements ModelSet {
    private SimpleIterator oldIterator = null;

    public <ST extends SDMSet> ST withReadOnly(boolean value) {
        if (value) {
            this.addFlag((byte)16);
        }
        return (ST)this;
    }

    public Iterator<T> iterator() {
        if (this.oldIterator == null || !this.oldIterator.isReusable()) {
            this.oldIterator = (SimpleIterator)super.iterator();
            return this.oldIterator;
        }
        this.oldIterator.withList((AbstractArray)this);
        return this.oldIterator;
    }

    public String toString() {
        StringList stringList = new StringList();
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T elem = iterator.next();
            stringList.add(elem.toString());
        }
        return "(" + stringList.concat(", ") + ")";
    }

    public <ST extends SDMSet> ST instanceOf(ST target) {
        String className;
        ParameterizedType genericSuperclass = (ParameterizedType)target.getClass().getGenericSuperclass();
        if (genericSuperclass.getActualTypeArguments().length > 0) {
            className = genericSuperclass.getActualTypeArguments()[0].getTypeName();
        } else {
            className = target.getClass().getName();
            className = CGUtil.baseClassName(className, "Set");
        }
        try {
            Class<?> targetClass = target.getClass().getClassLoader().loadClass(className);
            Iterator<T> iterator = this.iterator();
            while (iterator.hasNext()) {
                T elem = iterator.next();
                if (!targetClass.isAssignableFrom(elem.getClass())) continue;
                target.add(elem);
            }
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return target;
    }

    public <ST extends SDMSet<T>> ST union(Collection<? extends T> other) {
        SDMSet<T> result = this.getNewList(false);
        result.addAll((Collection)((Object)this));
        result.addAll(other);
        return (ST)result;
    }

    public <ST extends SDMSet<T>> ST intersection(Collection<? extends T> other) {
        SDMSet<T> result = this.getNewList(false);
        result.addAll((Collection)((Object)this));
        result.retainAll(other);
        return (ST)result;
    }

    public <ST extends SDMSet<T>> ST minus(Object other) {
        SDMSet<T> result = this.getNewList(false);
        result.addAll((Collection)((Object)this));
        if (other instanceof Collection) {
            result.removeAll((Collection)other);
        } else {
            result.remove(other);
        }
        return (ST)result;
    }

    public <ST extends SDMSet<T>> ST has(Condition<T> condition) {
        SDMSet<T> result = this.getNewList(false);
        result.addAll((Collection)((Object)this));
        Iterator<T> iterator = this.iterator();
        while (iterator.hasNext()) {
            T elem = iterator.next();
            if (condition.check(elem)) continue;
            result.remove(elem);
        }
        return (ST)result;
    }

    public Iterator<T> cloneIterator() {
        return super.clone().iterator();
    }

    public SDMSet<T> getNewList(boolean keyValue) {
        SDMSet result = null;
        try {
            result = (SDMSet)this.getClass().newInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return result;
    }

    public boolean remove(Object value) {
        return this.removeByObject(value) >= 0;
    }

    public T set(int index, T element) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("set(" + index + ")");
        }
        return (T)super.set(index, element);
    }

    public void add(int index, T element) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("add(" + index + ")");
        }
        super.add(index, element);
    }

    public T remove(int index) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("remove(" + index + ")");
        }
        return (T)super.remove(index);
    }

    public boolean add(T newValue) {
        if (this.isReadOnly()) {
            throw new UnsupportedOperationException("add()");
        }
        return super.add(newValue);
    }
}

